/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.extension.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.extension.constant.UccConstants;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.extension.busibase.atom.api.BkUccItemcreationAtomService;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccItemcreationAtomReqBO;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccItemcreationAtomRspBO;
import com.tydic.commodity.extension.dao.BkUccEMdmMaterialMapper;
import com.tydic.commodity.extension.dao.BkUccPriceLibraryMapper;
import com.tydic.commodity.extension.dao.BkUccPriceVersionInfoMapper;
import com.tydic.commodity.extension.dao.BkUccRelPriceVersionMapper;
import com.tydic.commodity.extension.dao.BkUccSkuExtMapper;
import com.tydic.commodity.extension.dao.BkUccSkuMapper;
import com.tydic.commodity.extension.po.BkUccEMdmMaterialPO;
import com.tydic.commodity.extension.po.BkUccPriceLibraryPO;
import com.tydic.commodity.extension.po.BkUccRelPriceVersionResultPO;
import com.tydic.commodity.extension.po.BkUccSkuExtPO;
import com.tydic.commodity.extension.po.BkUccSkuPo;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuDetailPO;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BkUccItemcreationAtomServiceImpl
implements BkUccItemcreationAtomService {
    private static final Logger log = LoggerFactory.getLogger(BkUccItemcreationAtomServiceImpl.class);
    @Autowired
    private BkUccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Resource(name="uccSkuIdSequence")
    private OrderSequence orderSequence;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private BkUccSkuExtMapper bkUccSkuExtMapper;
    @Autowired
    private BkUccEMdmMaterialMapper bkUccEMdmMaterialMapper;
    @Autowired
    private BkUccPriceLibraryMapper bkUccPriceLibraryMapper;
    @Autowired
    private BkUccRelPriceVersionMapper bkUccRelPriceVersionMapper;
    @Autowired
    private BkUccPriceVersionInfoMapper bkUccPriceVersionInfoMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;

    @Override
    public BkUccItemcreationAtomRspBO dealCreateSku(BkUccItemcreationAtomReqBO reqBO) {
        List<UccSkuPicPo> uccSkuPicPoList;
        BkUccItemcreationAtomRspBO rspBO = new BkUccItemcreationAtomRspBO();
        BkUccSkuPo uccSkuPo = new BkUccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPo);
        uccSkuPo.setMaterialId(reqBO.getMaterialId().toString());
        try {
            uccSkuPo.setSkuId(this.orderSequence.nextId());
        }
        catch (SQLException e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u5e8f\u5217\u751f\u6210\u5931\u8d25\uff01");
        }
        try {
            Long salePrice = 0L;
            BkUccPriceLibraryPO po = new BkUccPriceLibraryPO();
            po.setAgrId(reqBO.getAgreementId());
            po.setMaterialCode(reqBO.getMaterialCode());
            List<BkUccPriceLibraryPO> bkUccAgrPriceLibraryPOList = this.bkUccPriceLibraryMapper.qryUccPriceLibraryForSkuDetail(po);
            if (!CollectionUtils.isEmpty(bkUccAgrPriceLibraryPOList)) {
                if (reqBO.getAgrType() == 2) {
                    salePrice = this.selectSalePrice(bkUccAgrPriceLibraryPOList);
                } else {
                    String agrPriceVersionCode = bkUccAgrPriceLibraryPOList.get(0).getPriceVersionCode();
                    BkUccRelPriceVersionResultPO salePriceVersionPo = this.bkUccRelPriceVersionMapper.qryRelPriceVersionByAgr(agrPriceVersionCode, null, UccConstants.PRICE_STATUS_PUR_EFFECT);
                    ArrayList<BkUccPriceLibraryPO> bkUccSalePriceLibraryPOList = new ArrayList();
                    if (!Objects.isNull(salePriceVersionPo)) {
                        BkUccPriceLibraryPO salePriceLibPo = new BkUccPriceLibraryPO();
                        salePriceLibPo.setPriceVersionCode(salePriceVersionPo.getSalePriceVersionCode());
                        salePriceLibPo.setMaterialCode(reqBO.getMaterialCode());
                        bkUccSalePriceLibraryPOList = this.bkUccPriceLibraryMapper.qryUccEffSalePriceLibrary(salePriceLibPo);
                        if (!CollectionUtils.isEmpty(bkUccSalePriceLibraryPOList)) {
                            salePrice = this.selectSalePrice(bkUccSalePriceLibraryPOList);
                        }
                    }
                }
            }
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            uccSkuPricePo.setCreateOperId(uccSkuPo.getCreateOperId());
            uccSkuPricePo.setSkuPriceId(this.sequence.nextId());
            uccSkuPricePo.setSwitchOn(0);
            uccSkuPricePo.setSalePrice(salePrice);
            this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            uccSkuPo.setSkuPrice(salePrice);
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u9ed8\u8ba4\u4ef7\u683c\u5931\u8d25:" + e.getMessage());
        }
        try {
            this.uccSkuMapper.addsku(uccSkuPo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u65b0\u589e\u5931\u8d25" + e.getMessage());
        }
        BkUccSkuExtPO bkUccSkuExtPO = new BkUccSkuExtPO();
        bkUccSkuExtPO.setSkuId(uccSkuPo.getSkuId());
        bkUccSkuExtPO.setAgreementPriceId(reqBO.getAgreementPriceId());
        bkUccSkuExtPO.setAfterService(reqBO.getAfterService());
        bkUccSkuExtPO.setAgrType(reqBO.getAgrType());
        bkUccSkuExtPO.setInnerSkuCode(reqBO.getInnerSkuCode());
        bkUccSkuExtPO.setMaterialRemark(reqBO.getMaterialRemark());
        try {
            BkUccEMdmMaterialPO bkUccEMdmMaterialPO = this.bkUccEMdmMaterialMapper.qryMaterialInfoById(reqBO.getMaterialId());
            String shortDesc = bkUccEMdmMaterialPO.getShortDesc();
            if (!StringUtils.isEmpty((Object)shortDesc)) {
                String[] split = shortDesc.split("\\\\");
                String memoryWord = this.getPinYinHeadChar(split[0]);
                log.info("\u8bb0\u52a9\u8bcd\u4e3a:" + memoryWord);
                bkUccSkuExtPO.setMemoryWord(memoryWord);
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u52a9\u8bcd\u751f\u6210\u5931\u8d25:" + e.getMessage());
        }
        this.bkUccSkuExtMapper.insert(bkUccSkuExtPO);
        if (!(StringUtils.isEmpty((Object)reqBO.getSkuPcDetailChar()) && StringUtils.isEmpty((Object)reqBO.getSkuPcDetailUrl()) && StringUtils.isEmpty((Object)reqBO.getSkuPhoneDetailChar()) && StringUtils.isEmpty((Object)reqBO.getSkuPhoneDetailUrl()))) {
            UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuDetailPO);
            uccSkuDetailPO.setSkuId(uccSkuPo.getSkuId());
            this.uccSkuDetailMapper.addSkuDetail(uccSkuDetailPO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getSkuImages())) {
            uccSkuPicPoList = JSONObject.parseArray((String)JSONObject.toJSONString(reqBO.getSkuImages()), UccSkuPicPo.class);
            uccSkuPicPoList.stream().forEach(each -> {
                each.setSkuId(uccSkuPo.getSkuId());
                each.setSupplierShopId(reqBO.getSupplierShopId());
                each.setCreateOperId(reqBO.getCreateOperId());
                each.setSkuPicId(this.sequence.nextId());
                if (each.getPicOrder() == null) {
                    each.setPicOrder(1);
                }
            });
            try {
                this.uccSkuPicMapper.addskuPicList(uccSkuPicPoList);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u4ef7\u683c\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        uccSkuPicPoList = new ArrayList();
        Date now = new Date();
        for (int i = 0; i < 5; ++i) {
            UccSkuPicPo each2 = new UccSkuPicPo();
            each2.setSkuId(uccSkuPo.getSkuId());
            each2.setSupplierShopId(reqBO.getSupplierShopId());
            each2.setCreateOperId(reqBO.getCreateOperId());
            each2.setSkuPicId(this.sequence.nextId());
            each2.setPicOrder(i);
            if (i == 0) {
                each2.setCommodityPicType(1);
                each2.setRemark("\u4e3b\u56fe");
            } else {
                each2.setCommodityPicType(2);
                each2.setRemark("\u7ec6\u8282\u56fe");
            }
            each2.setSkuPicUrl("");
            each2.setCreateTime(now);
            uccSkuPicPoList.add(each2);
        }
        try {
            this.uccSkuPicMapper.addskuPicList(uccSkuPicPoList);
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u56fe\u7247\u65b0\u589e\u5931\u8d25" + e.getMessage());
        }
        UccSaleNumPo saleNumPo = new UccSaleNumPo();
        saleNumPo.setSkuId(uccSkuPo.getSkuId());
        saleNumPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        saleNumPo.setSoldNumber(new BigDecimal(0));
        saleNumPo.setSaleId(this.sequence.nextId());
        try {
            this.uccSaleNumMapper.insertSaleNum(saleNumPo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u9500\u91cf\u65b0\u589e\u5931\u8d25" + e.getMessage());
        }
        if (reqBO.getOnShelveWay() != null) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPutCirPo.setId(this.sequence.nextId());
            uccSkuPutCirPo.setState(1);
            if (0 == reqBO.getOnShelveWay()) {
                uccSkuPutCirPo.setUpType(1);
                uccSkuPutCirPo.setDownType(1);
            } else {
                uccSkuPutCirPo.setUpType(2);
                uccSkuPutCirPo.setDownType(2);
            }
            try {
                if (!StringUtils.isEmpty((Object)reqBO.getPreUpTime())) {
                    uccSkuPutCirPo.setPreUpTime(DateUtils.strToDate(reqBO.getPreUpTime()));
                }
                if (!StringUtils.isEmpty((Object)reqBO.getPreDownTime())) {
                    uccSkuPutCirPo.setPreDownTime(DateUtils.strToDate(reqBO.getPreDownTime()));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ZTBusinessException(RspConstantEnums.TYPE_CONVERSION_FAILED.code() + e.getMessage());
            }
            try {
                this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u4e0a\u4e0b\u67b6\u5468\u671f\u5f02\u5e38");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setSku(uccSkuPo.getSkuId());
        return rspBO;
    }

    public String getPinYinHeadChar(String str) {
        if (Objects.isNull(str)) {
            return "";
        }
        String convert = "";
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            convert = pinyinArray != null ? convert + pinyinArray[0].charAt(0) : convert + word;
        }
        return convert.toUpperCase();
    }

    private Long selectSalePrice(List<BkUccPriceLibraryPO> bkUccAgrPriceLibraryPOList) {
        Long salePrice = 0L;
        List priceList1 = bkUccAgrPriceLibraryPOList.stream().filter(a -> a.getPriceMod() == 1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(priceList1)) {
            salePrice = MoneyUtils.yuanToHaoToLong(((BkUccPriceLibraryPO)priceList1.get(0)).getPrice());
        } else {
            List priceList2 = bkUccAgrPriceLibraryPOList.stream().filter(a -> a.getPriceMod() == 2).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(priceList2)) {
                BigDecimal price = priceList2.stream().max(Comparator.comparing(BkUccPriceLibraryPO::getPrice)).get().getPrice();
                salePrice = MoneyUtils.yuanToHaoToLong(price);
            } else {
                List priceList4 = bkUccAgrPriceLibraryPOList.stream().filter(a -> a.getPriceMod() == 4).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(priceList4)) {
                    BigDecimal price = priceList4.stream().max(Comparator.comparing(BkUccPriceLibraryPO::getPrice)).get().getPrice();
                    salePrice = MoneyUtils.yuanToHaoToLong(price);
                }
            }
        }
        return salePrice;
    }
}

