/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.extension.busibase.atom.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.extension.constant.UccConstants;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.extension.busibase.atom.api.BkUccGemiSendMessageAtomService;
import com.tydic.commodity.extension.busibase.atom.api.BkUccSendTodoAtomService;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccSendTodoAtomServiceRspBo;
import com.tydic.commodity.extension.busibase.busi.bo.BkPushTodoResultInfoBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkReceiverBo;
import com.tydic.commodity.extension.busibase.busi.bo.NotifyBO;
import com.tydic.commodity.extension.dao.BkEacRuTaskApprovalMapper;
import com.tydic.commodity.extension.dao.BkUccPriceVersionInfoMapper;
import com.tydic.commodity.extension.po.BkEacRuTaskApprovalPo;
import com.tydic.commodity.extension.po.BkUccPriceVersionInfoPO;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.api.BkUmcTodoService;
import com.tydic.dyc.umc.service.extension.api.BkUmcUserService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushTodoInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserSummaryInfoBO;
import com.tydic.dyc.umc.service.user.UmcQryUserInfoDetailService;
import com.tydic.dyc.umc.service.user.bo.UmcQryUserInfoDetailReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcQryUserInfoDetailRspBo;
import com.tydic.osworkflow.approve.ability.EacQueryOperationRecordsListAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacOperationRecordsInfoAbilityBO;
import com.tydic.osworkflow.approve.ability.bo.EacQueryOperationRecordsListAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacQueryOperationRecordsListAbilityRspBO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUccSendTodoAtomServiceImpl
implements BkUccSendTodoAtomService {
    private static final Logger log = LoggerFactory.getLogger(BkUccSendTodoAtomServiceImpl.class);
    @Autowired
    private BkUmcTodoService bkUmcTodoService;
    @Autowired
    private EacQueryOperationRecordsListAbilityService eacQueryOperationRecordsListAbilityService;
    @Autowired
    private UmcQryUserInfoDetailService umcQryUserInfoDetailService;
    @Autowired
    private BkUmcUserService bkUmcUserService;
    @Autowired
    private BkUccGemiSendMessageAtomService bkUccGemiSendMessageAtomService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private BkEacRuTaskApprovalMapper bkEacRuTaskApprovalMapper;
    @Autowired
    private BkUccPriceVersionInfoMapper bkUccPriceVersionInfoMapper;
    @Value(value="${toDo.sendUrl:}")
    private String sendUrl;
    @Value(value="${toDo.sysCode:}")
    private String sysCode;
    @Value(value="${toDo.status:true}")
    private Boolean status;
    @Value(value="${PORTAL_ADDRESS:}")
    private String portalAddress;

    @Override
    public BkUccSendTodoAtomServiceRspBo sendTodo(List<Long> taskIds, Integer sendTodoType, String procInstId) {
        BkUccSendTodoAtomServiceRspBo rspBo = new BkUccSendTodoAtomServiceRspBo();
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setTaskIds(taskIds);
        List<EacRuTaskPO> list = this.eacRuTaskMapper.getList(eacRuTaskPO);
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("8888", "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u4efb\u52a1");
        }
        EacQueryOperationRecordsListAbilityReqBO eacQueryOperationRecordsListAbilityReqBO = new EacQueryOperationRecordsListAbilityReqBO();
        eacQueryOperationRecordsListAbilityReqBO.setProcInstId(list.get(0).getApproveInstId());
        log.info("\u5ba1\u6279\u4e2d\u5fc3\u64cd\u4f5c\u8bb0\u5f55\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)eacQueryOperationRecordsListAbilityReqBO));
        EacQueryOperationRecordsListAbilityRspBO eacQueryOperationRecordsListAbilityRspBO = this.eacQueryOperationRecordsListAbilityService.queryOperationRecordsList(eacQueryOperationRecordsListAbilityReqBO);
        log.info("\u5ba1\u6279\u4e2d\u5fc3\u64cd\u4f5c\u8bb0\u5f55\u5217\u8868\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)eacQueryOperationRecordsListAbilityRspBO));
        eacQueryOperationRecordsListAbilityRspBO.getRows().sort(Comparator.comparing(EacOperationRecordsInfoAbilityBO::getCreateTime));
        log.info("\u6392\u5e8f\u540e\u7684\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)eacQueryOperationRecordsListAbilityRspBO));
        Long createUserId = Long.parseLong(((EacOperationRecordsInfoAbilityBO)eacQueryOperationRecordsListAbilityRspBO.getRows().get(eacQueryOperationRecordsListAbilityRspBO.getRows().size() - 1)).getUserId());
        String createUserName = ((EacOperationRecordsInfoAbilityBO)eacQueryOperationRecordsListAbilityRspBO.getRows().get(eacQueryOperationRecordsListAbilityRspBO.getRows().size() - 1)).getUserName();
        UmcQryUserInfoDetailReqBo infoDetailReqBo = new UmcQryUserInfoDetailReqBo();
        infoDetailReqBo.setUserId(createUserId);
        UmcQryUserInfoDetailRspBo umcQryUserInfoDetailRspBo = this.umcQryUserInfoDetailService.qryUserInfoDetail(infoDetailReqBo);
        log.info("\u63d0\u4ea4\u4eba\u4f1a\u5458\u8be6\u60c5\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)umcQryUserInfoDetailRspBo));
        BkUmcBatchQueryUserInfoReqBO bo = new BkUmcBatchQueryUserInfoReqBO();
        List candidateList = list.stream().map(v -> Long.parseLong(v.getUserId())).distinct().collect(Collectors.toList());
        bo.setUserIds(candidateList);
        BkUmcBatchQueryUserInfoRspBO infoRspBO = this.bkUmcUserService.batchQueryUserInfo(bo);
        List userInfos = infoRspBO.getUserInfos();
        log.info("\u5f85\u529e\u4eba\u4f1a\u5458\u8be6\u60c5\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)infoRspBO));
        Map<Long, List<BkUmcUserSummaryInfoBO>> candidateMap = userInfos.stream().collect(Collectors.groupingBy(BkUmcUserSummaryInfoBO::getUserId));
        ArrayList<BkUmcPushTodoInfoBO> todoInfos = new ArrayList<BkUmcPushTodoInfoBO>();
        String approvalCode = null;
        String procDefKey = null;
        Integer priceType = null;
        String priceVersionCode = null;
        for (EacRuTaskPO each : list) {
            BkUmcPushTodoInfoBO bkUmcPushTodoInfoBO = new BkUmcPushTodoInfoBO();
            bkUmcPushTodoInfoBO.setBusiId(each.getBusinessId() + procInstId);
            bkUmcPushTodoInfoBO.setTodoType(Integer.valueOf(1));
            bkUmcPushTodoInfoBO.setBelongModule("UCC");
            if (sendTodoType.equals(1)) {
                BkUccPriceVersionInfoPO bkUccPriceVersionInfoPO = this.bkUccPriceVersionInfoMapper.qryPriceVersionById(Long.parseLong(each.getBusinessId()));
                priceType = bkUccPriceVersionInfoPO.getPriceType();
                priceVersionCode = bkUccPriceVersionInfoPO.getPriceVersionCode();
                if (bkUccPriceVersionInfoPO.getPriceType().equals(UccConstants.PRICE_TYPE_PUR)) {
                    bkUmcPushTodoInfoBO.setTodoEvent("\u5ba1\u6279\u91c7\u8d2d\u4ef7\u8c03\u6574\u5355:" + bkUccPriceVersionInfoPO.getPriceVersionCode());
                    bkUmcPushTodoInfoBO.setLinkUrl("index/purPriceAdApproval?priceVersionCode=" + priceVersionCode + "&procInstId=" + procInstId);
                } else {
                    bkUmcPushTodoInfoBO.setTodoEvent("\u5ba1\u6279\u9500\u552e\u4ef7\u8c03\u6574\u5355:" + bkUccPriceVersionInfoPO.getPriceVersionCode());
                    bkUmcPushTodoInfoBO.setLinkUrl("index/salesPriceAdApproval?priceVersionCode=" + priceVersionCode + "&procInstId=" + procInstId);
                }
            } else if (sendTodoType.equals(2)) {
                List<BkEacRuTaskApprovalPo> bkEacRuTaskApprovalPoList = this.bkEacRuTaskApprovalMapper.qryModelByApprovalId(Long.parseLong(each.getBusinessId()));
                if (CollectionUtils.isEmpty(bkEacRuTaskApprovalPoList)) {
                    throw new BusinessException("8888", "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u5ba1\u6279\u5355");
                }
                approvalCode = bkEacRuTaskApprovalPoList.get(0).getApprovalCode();
                procDefKey = each.getProcDefKey();
                if ("ARG_ON_SHELF_PROCESS".equals(each.getProcDefKey())) {
                    bkUmcPushTodoInfoBO.setTodoEvent("\u4e0a\u67b6\u5ba1\u6838\u5546\u54c1:" + approvalCode);
                    bkUmcPushTodoInfoBO.setLinkUrl("index/noEleShopApproval?approvalId=" + bkEacRuTaskApprovalPoList.get(0).getApprovalId() + "&procInstId=" + procInstId + "&type=1&approvalCode=" + approvalCode);
                } else if ("ARG_OFF_SHELF_PROCESS".equals(each.getProcDefKey())) {
                    bkUmcPushTodoInfoBO.setTodoEvent("\u4e0b\u67b6\u5ba1\u6838\u5546\u54c1:" + approvalCode);
                    bkUmcPushTodoInfoBO.setLinkUrl("index/noEleShopApproval?approvalId=" + bkEacRuTaskApprovalPoList.get(0).getApprovalId() + "&procInstId=" + procInstId + "&type=2&approvalCode=" + approvalCode);
                } else {
                    bkUmcPushTodoInfoBO.setTodoEvent("");
                }
            }
            bkUmcPushTodoInfoBO.setCreateUserId(createUserId + "");
            bkUmcPushTodoInfoBO.setCreateUserName(umcQryUserInfoDetailRspBo.getCustInfoBo().getCustName());
            bkUmcPushTodoInfoBO.setCreateUserPhone(umcQryUserInfoDetailRspBo.getCustInfoBo().getRegMobile());
            bkUmcPushTodoInfoBO.setCreateOrgId(umcQryUserInfoDetailRspBo.getOrgId() + "");
            bkUmcPushTodoInfoBO.setCreateOrgName(umcQryUserInfoDetailRspBo.getOrgName());
            bkUmcPushTodoInfoBO.setCreateCompanyId(umcQryUserInfoDetailRspBo.getCustInfoBo().getCompanyId() + "");
            bkUmcPushTodoInfoBO.setCreateCompanyName(umcQryUserInfoDetailRspBo.getCustInfoBo().getCompanyName());
            Long candidateUserId = Long.parseLong(each.getUserId());
            if (!candidateMap.containsKey(candidateUserId)) continue;
            bkUmcPushTodoInfoBO.setPendingUserId(each.getUserId());
            bkUmcPushTodoInfoBO.setPendingUserName(candidateMap.get(candidateUserId).get(0).getUserName());
            bkUmcPushTodoInfoBO.setPendingOrgId(candidateMap.get(candidateUserId).get(0).getOrgId() + "");
            bkUmcPushTodoInfoBO.setPendingOrgName(candidateMap.get(candidateUserId).get(0).getOrgName());
            bkUmcPushTodoInfoBO.setPendingCompanyName(candidateMap.get(candidateUserId).get(0).getCompanyName());
            bkUmcPushTodoInfoBO.setPendingCompanyId(candidateMap.get(candidateUserId).get(0).getCompanyId() + "");
            todoInfos.add(bkUmcPushTodoInfoBO);
        }
        BkUmcBatchPushTodoReqBO bkUmcBatchPushTodoReqBO = new BkUmcBatchPushTodoReqBO();
        bkUmcBatchPushTodoReqBO.setTodoInfos(todoInfos);
        log.info("\u63a8\u9001\u5f85\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)bkUmcBatchPushTodoReqBO));
        BkUmcBatchPushTodoRspBO bkUmcBatchPushTodoRspBO = this.bkUmcTodoService.batchPushTodo(bkUmcBatchPushTodoReqBO);
        log.info("\u63a8\u9001\u5f85\u529e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)bkUmcBatchPushTodoRspBO));
        try {
            this.pushTodoOut(bkUmcBatchPushTodoRspBO, bkUmcBatchPushTodoReqBO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5916\u90e8\u5f85\u529e\u62a5\u9519\uff1a" + e.getMessage());
        }
        if (sendTodoType.equals(1)) {
            this.sendMessageForPriceVersion(todoInfos, priceType, priceVersionCode);
        } else if (sendTodoType.equals(2)) {
            this.sendMessageForSku(todoInfos, procDefKey, approvalCode);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void pushTodoOut(BkUmcBatchPushTodoRspBO bkUmcBatchPushTodoRspBO, BkUmcBatchPushTodoReqBO bkUmcBatchPushTodoReqBO) {
        List resultInfo = bkUmcBatchPushTodoRspBO.getResultInfo().stream().map(bkUmcPushTodoResultInfoBO -> {
            BkPushTodoResultInfoBO bkPushTodoResultInfoBO = new BkPushTodoResultInfoBO();
            BeanUtils.copyProperties((Object)bkUmcPushTodoResultInfoBO, (Object)bkPushTodoResultInfoBO);
            return bkPushTodoResultInfoBO;
        }).collect(Collectors.toList());
        if (this.status.booleanValue()) {
            List userIds = bkUmcBatchPushTodoReqBO.getTodoInfos().stream().map(e -> Long.valueOf(e.getPendingUserId())).collect(Collectors.toList());
            BkUmcBatchQueryUserInfoReqBO userInfoReqBO = new BkUmcBatchQueryUserInfoReqBO();
            userInfoReqBO.setUserIds(userIds);
            log.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)userInfoReqBO));
            BkUmcBatchQueryUserInfoRspBO userInfoRspBO = this.bkUmcUserService.batchQueryUserInfo(userInfoReqBO);
            log.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)userInfoRspBO));
            Map<Long, String> userIdMap = userInfoRspBO.getUserInfos().stream().filter(e -> ObjectUtil.isNotEmpty((Object)e.getExtUserCode())).collect(Collectors.toMap(BkUmcUserSummaryInfoBO::getUserId, BkUmcUserSummaryInfoBO::getExtUserCode));
            Map<String, Long> PendingUserIdAndTodoIdMap = resultInfo.stream().collect(Collectors.toMap(BkPushTodoResultInfoBO::getPendingUserId, BkPushTodoResultInfoBO::getTodoId));
            List pushTodoInfoBOS = bkUmcBatchPushTodoReqBO.getTodoInfos().stream().filter(e -> userIdMap.containsKey(Long.valueOf(e.getPendingUserId()))).collect(Collectors.toList());
            if (ObjectUtil.isEmpty(pushTodoInfoBOS)) {
                log.info("\u672a\u67e5\u8be2\u5230" + userIds + "\u7684\u4e3b\u6570\u636eID\u4e0d\u63a8\u9001");
                return;
            }
            List<Map<String, String>> mapList = pushTodoInfoBOS.stream().map(bkPushTodoInfoBO -> {
                NotifyBO notifyBO = new NotifyBO();
                notifyBO.setUniid(((Long)PendingUserIdAndTodoIdMap.get(bkPushTodoInfoBO.getPendingUserId())).toString());
                notifyBO.setTitle(bkPushTodoInfoBO.getTodoEvent());
                String url = bkPushTodoInfoBO.getLinkUrl().contains("&") ? this.portalAddress + bkPushTodoInfoBO.getLinkUrl().replace("&", "&amp;") : this.portalAddress + bkPushTodoInfoBO.getLinkUrl();
                notifyBO.setUrl(url + "&amp;isApproval=1&amp;haveDoneRelativeId=null&amp;userId=" + bkPushTodoInfoBO.getPendingUserId() + "&amp;todoId=" + PendingUserIdAndTodoIdMap.get(bkPushTodoInfoBO.getPendingUserId()) + "&amp;pendingUserId=" + bkPushTodoInfoBO.getPendingUserId());
                notifyBO.setOwner((String)userIdMap.get(Long.valueOf(bkPushTodoInfoBO.getPendingUserId())));
                notifyBO.setCreated(DateUtils.dateToStrLong((Date)new Date()));
                notifyBO.setType(BkUmcStatusConstant.TodoOrDoneStatus.TODO.toString());
                notifyBO.setStatus(BkUmcStatusConstant.TodoOrDoneStatus.TODO.toString());
                notifyBO.setSender(bkPushTodoInfoBO.getCreateUserName());
                notifyBO.setDepart(bkPushTodoInfoBO.getCreateOrgName());
                if (bkPushTodoInfoBO.getCreateUserName().equals("\u7cfb\u7edf\u751f\u6210")) {
                    notifyBO.setSender("\u7cfb\u7edf");
                    notifyBO.setDepart("\u9ed8\u8ba4\u90e8\u95e8");
                }
                HashMap map = new HashMap();
                BeanUtil.copyProperties((Object)notifyBO, map);
                return map;
            }).collect(Collectors.toList());
            String xml = this.formatDataToXml(mapList);
            log.info("\u5f85\u529e\u8c03\u7528\u5730\u5740\uff1a{}", (Object)this.sendUrl);
            log.info("\u5f85\u529e\u7ec4\u88c5\u5165\u53c2\uff1a{}", (Object)xml);
            try {
                String body = HttpRequest.post((String)this.sendUrl).body(xml).timeout(10000).execute().body();
                log.info("\u8c03\u7528\u5f85\u529e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)body);
                if (!body.contains("\u53d1\u9001\u6210\u529f")) {
                    log.error("\u53d1\u9001\u5f85\u529e\u6d88\u606f\u5931\u8d25");
                }
            }
            catch (Exception exception) {
                log.error("\u53d1\u9001\u5f85\u529e\u6d88\u606f\u5931\u8d25" + exception.getMessage());
            }
        }
    }

    public String formatDataToXml(List<Map<String, String>> mapList) {
        StringBuilder xml = new StringBuilder();
        xml.append("<todo_list>");
        xml.append("<header>");
        xml.append("<syscode>");
        xml.append(this.sysCode);
        xml.append("</syscode>");
        xml.append("</header>");
        for (Map<String, String> mapdData : mapList) {
            xml.append("<todo_info>");
            if (mapdData != null) {
                Set<Map.Entry<String, String>> set = mapdData.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    if (null == entry.getValue()) continue;
                    xml.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
                }
            }
            xml.append("</todo_info>");
        }
        xml.append("</todo_list>");
        return xml.toString();
    }

    private void sendMessageForSku(List<BkUmcPushTodoInfoBO> todoInfos, String procDefKey, String approvalCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("ARG_ON_SHELF_PROCESS".equals(procDefKey)) {
            map.put("taskCode", "ucc_on_shelf_approval");
        } else if ("ARG_OFF_SHELF_PROCESS".equals(procDefKey)) {
            map.put("taskCode", "ucc_off_shelf_approval");
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("approvalCode", approvalCode);
        map.put("data", dataMap);
        map.put("sendId", 1L);
        map.put("sendName", "admin");
        ArrayList receiverIdList = new ArrayList();
        todoInfos.forEach(v -> {
            BkReceiverBo bo = new BkReceiverBo();
            bo.setReceiverId(v.getPendingUserId());
            bo.setReceiverName(v.getPendingUserName());
            receiverIdList.add(bo);
        });
        map.put("receiverIdList", JSON.toJSONString(receiverIdList.stream().distinct().collect(Collectors.toList())));
        this.bkUccGemiSendMessageAtomService.sendMessage(map);
    }

    private void sendMessageForPriceVersion(List<BkUmcPushTodoInfoBO> todoInfos, Integer priceType, String priceVersionCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (priceType == 1) {
            map.put("taskCode", "agr_price_version_approval");
        } else {
            map.put("taskCode", "sale_price_version_approval");
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("priceVersionCode", priceVersionCode);
        map.put("data", dataMap);
        map.put("sendId", 1L);
        map.put("sendName", "admin");
        ArrayList receiverIdList = new ArrayList();
        todoInfos.forEach(v -> {
            BkReceiverBo bo = new BkReceiverBo();
            bo.setReceiverId(v.getPendingUserId());
            bo.setReceiverName(v.getPendingUserName());
            receiverIdList.add(bo);
        });
        map.put("receiverIdList", JSON.toJSONString(receiverIdList.stream().distinct().collect(Collectors.toList())));
        this.bkUccGemiSendMessageAtomService.sendMessage(map);
    }
}

