/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.extension.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.SpuStatusMappingEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.extension.busibase.atom.api.BkUccSkuStatusUpdatesAtomService;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccSkuUpdateStatusBO;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.extension.dao.BkUccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuEditPO;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.dyc.agr.service.agr.AgrQryAgrDetailService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUccSkuStatusUpdatesAtomServiceImpl
implements BkUccSkuStatusUpdatesAtomService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private BkUccSkuMapper bkUccSkuMapper;
    @Autowired
    private UccSkuLogMapper skuLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private AgrQryAgrDetailService agrQryAgrDetailService;

    @Override
    public BkUccStatusChangeUpdateSpuAtomRspBO delaStatusChange(BkUccStatusChangeUpdateSpuAtomReqBO reqBO) {
        BkUccStatusChangeUpdateSpuAtomRspBO rspBO = new BkUccStatusChangeUpdateSpuAtomRspBO();
        if (CollectionUtils.isEmpty(reqBO.getSkuStatusList())) {
            throw new BusinessException("8888", "\u5355\u54c1\u72b6\u6001");
        }
        if (reqBO.getSupplierShopId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5e97\u94faID");
        }
        ArrayList<Long> SkuIdList = new ArrayList();
        SkuIdList = reqBO.getSkuStatusList().stream().map(BkUccSkuUpdateStatusBO::getSkuId).collect(Collectors.toList());
        this.addSkuLog(reqBO.getSupplierShopId(), SkuIdList);
        try {
            List uccSkuPo = JSONObject.parseArray((String)JSONObject.toJSONString(reqBO.getSkuStatusList()), UccSkuEditPO.class);
            this.bkUccSkuMapper.updateStatusBySkuIds(uccSkuPo, reqBO.getSupplierShopId(), reqBO.getUserId(), reqBO.getUserName(), reqBO.getApprovalStatus(), reqBO.getStepId());
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
        List<Long> skuIds = reqBO.getSkuStatusList().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
        ArrayList<UccCommodityPo> commodityPoList = new ArrayList<UccCommodityPo>();
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            UccCommodityPo po = new UccCommodityPo();
            po.setCommodityId(uccSkuPo.getCommodityId());
            po.setSupplierShopId(reqBO.getSupplierShopId());
            Integer spuStatus = SpuStatusMappingEnum.findSpuStatus((Integer)uccSkuPo.getSkuStatus());
            po.setCommodityStatus(spuStatus);
            commodityPoList.add(po);
        }
        if (!CollectionUtils.isEmpty(commodityPoList)) {
            Map<Integer, List<UccCommodityPo>> spuStatus = commodityPoList.stream().collect(Collectors.groupingBy(UccCommodityPo::getCommodityStatus));
            for (Integer status : spuStatus.keySet()) {
                List<Long> commods = spuStatus.get(status).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
                this.uccCommodityMapper.batchUpdateCommodityStatus(commods, status, reqBO.getSupplierShopId());
                for (Long commod : commods) {
                    this.uccCommodityMapper.updateApprovalStatus(commod, reqBO.getSupplierShopId(), reqBO.getApprovalStatus());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Integer getPriorityStatus(List<Integer> priority, List<Integer> status) {
        Integer position = priority.size();
        for (Integer sku : status) {
            for (int i = 0; i < priority.size(); ++i) {
                if (sku != priority.get(i) || i >= position) continue;
                position = i;
            }
        }
        return priority.get(position);
    }

    private void addSkuLog(Long supplierShopId, List<Long> skuIds) {
        if (supplierShopId == null || org.apache.commons.collections.CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySku(skuIds, supplierShopId);
        ArrayList<UccSkuLogPo> skuLogPoList = new ArrayList<UccSkuLogPo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccSkuPos)) {
            try {
                for (UccSkuPo uccSkuPo1 : uccSkuPos) {
                    UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPo1, (Object)uccSkuLogPo);
                    Long batchId = this.uccBatchSequence.nextId();
                    uccSkuLogPo.setBatchId(batchId);
                    skuLogPoList.add(uccSkuLogPo);
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u521b\u5efa\u5e8f\u5217\u5931\u8d25");
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(skuLogPoList)) {
                try {
                    this.skuLogMapper.addSkuLog(skuLogPoList);
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u5355\u54c1\u65e5\u5fd7\u8868\u6570\u636e\u5e93\u6dfb\u52a0\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
    }
}

