/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.extension.busibase.busi.impl;

import com.tydic.commodity.base.extension.constant.BkMoneyUtils;
import com.tydic.commodity.extension.busibase.busi.api.BkUccReplacePriceQryBusiService;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceLadderPriceBusiBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceQryBusiBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceQryBusiReqBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceQryBusiRspBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceQryBusiSkuBO;
import com.tydic.commodity.extension.dao.BkUccPriceVersionInfoMapper;
import com.tydic.commodity.extension.dao.BkUccSkuMapper;
import com.tydic.commodity.extension.po.BkUccPriceVersionInfoAndLibraryPO;
import com.tydic.commodity.extension.po.BkUccSkuAndMaterialPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUccReplacePriceQryBusiServiceImpl
implements BkUccReplacePriceQryBusiService {
    @Autowired
    private BkUccSkuMapper bkUccSkuMapper;
    @Autowired
    private BkUccPriceVersionInfoMapper bkUccPriceVersionInfoMapper;

    @Override
    public BkUccReplacePriceQryBusiRspBO replacePrice(BkUccReplacePriceQryBusiReqBO reqBO) {
        BkUccReplacePriceQryBusiRspBO rspBO = this.checkReqBo(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        List<Long> skuIdList = reqBO.getSkuList().stream().map(BkUccReplacePriceQryBusiSkuBO::getSkuId).distinct().collect(Collectors.toList());
        List<BkUccSkuAndMaterialPo> bkUccSkuAndMaterialPos = this.bkUccSkuMapper.qrySkuAndMaterialList(skuIdList);
        if (CollectionUtils.isEmpty(bkUccSkuAndMaterialPos)) {
            return rspBO;
        }
        Map<Long, List<BkUccSkuAndMaterialPo>> skuIdMap = bkUccSkuAndMaterialPos.stream().collect(Collectors.groupingBy(BkUccSkuAndMaterialPo::getSkuId));
        ArrayList<BkUccReplacePriceQryBusiBO> priceList = new ArrayList<BkUccReplacePriceQryBusiBO>();
        for (BkUccReplacePriceQryBusiSkuBO skuBO : reqBO.getSkuList()) {
            List<BkUccPriceVersionInfoAndLibraryPO> areaPriceFilterList;
            List<BkUccPriceVersionInfoAndLibraryPO> areaPriceList;
            BkUccReplacePriceQryBusiBO bkUccReplacePriceQryBusiBO = new BkUccReplacePriceQryBusiBO();
            bkUccReplacePriceQryBusiBO.setSkuId(skuBO.getSkuId());
            bkUccReplacePriceQryBusiBO.setIsAvailable(1);
            BkUccSkuAndMaterialPo bkUccSkuAndMaterialPo = skuIdMap.get(skuBO.getSkuId()).get(0);
            Integer agrType = bkUccSkuAndMaterialPo.getAgrType();
            bkUccReplacePriceQryBusiBO.setAgrType(agrType);
            String materialCode = bkUccSkuAndMaterialPo.getMaterialCode();
            List<BkUccPriceVersionInfoAndLibraryPO> bkUccPriceVersionInfoAndLibraryPOS = this.bkUccPriceVersionInfoMapper.qryPriceVersionInfoAndLibrary(skuBO.getAgrCode(), materialCode);
            if (CollectionUtils.isEmpty(bkUccPriceVersionInfoAndLibraryPOS)) {
                bkUccReplacePriceQryBusiBO.setIsAvailable(0);
                priceList.add(bkUccReplacePriceQryBusiBO);
                continue;
            }
            boolean isFindSalePrice = true;
            Map<Integer, List<BkUccPriceVersionInfoAndLibraryPO>> priceLibraryMap = bkUccPriceVersionInfoAndLibraryPOS.stream().collect(Collectors.groupingBy(BkUccPriceVersionInfoAndLibraryPO::getPriceMod));
            List<BkUccPriceVersionInfoAndLibraryPO> ladderPriceList = priceLibraryMap.get(4);
            bkUccReplacePriceQryBusiBO = !CollectionUtils.isEmpty(ladderPriceList) ? this.findLadderPrice(ladderPriceList, skuBO, agrType) : (!CollectionUtils.isEmpty(areaPriceList = priceLibraryMap.get(3)) && !Objects.isNull(reqBO.getCompanyId()) ? (!CollectionUtils.isEmpty(areaPriceFilterList = areaPriceList.stream().filter(v -> v.getOrgId().equals(reqBO.getCompanyId())).collect(Collectors.toList())) ? this.findAreaPrice(areaPriceFilterList, skuBO, agrType) : this.findRegionAndUnifyPrice(priceLibraryMap, skuBO, isFindSalePrice, reqBO, agrType)) : this.findRegionAndUnifyPrice(priceLibraryMap, skuBO, isFindSalePrice, reqBO, agrType));
            if (!agrType.equals(2) && isFindSalePrice) {
                String agrPriceVersionCode = bkUccPriceVersionInfoAndLibraryPOS.get(0).getPriceVersionCode();
                List<BkUccPriceVersionInfoAndLibraryPO> bkUccSalePriceVersionInfoAndLibraryList = this.bkUccPriceVersionInfoMapper.qrySalePriceVersionInfoAndLibrary(agrPriceVersionCode, materialCode);
                if (CollectionUtils.isEmpty(bkUccSalePriceVersionInfoAndLibraryList)) {
                    bkUccReplacePriceQryBusiBO.setIsAvailable(0);
                    priceList.add(bkUccReplacePriceQryBusiBO);
                    continue;
                }
                Map<Integer, List<BkUccPriceVersionInfoAndLibraryPO>> salePriceLibraryMap = bkUccSalePriceVersionInfoAndLibraryList.stream().collect(Collectors.groupingBy(BkUccPriceVersionInfoAndLibraryPO::getPriceMod));
                List<BkUccPriceVersionInfoAndLibraryPO> areaPriceList2 = salePriceLibraryMap.get(3);
                if (!CollectionUtils.isEmpty(areaPriceList2) && !Objects.isNull(reqBO.getCompanyId())) {
                    List areaPriceFilterList2 = areaPriceList2.stream().filter(v -> v.getOrgId().equals(reqBO.getCompanyId())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(areaPriceFilterList2)) {
                        bkUccReplacePriceQryBusiBO.setSalePrice(((BkUccPriceVersionInfoAndLibraryPO)areaPriceFilterList2.get(0)).getPrice());
                    } else {
                        this.findRegionAndUnifySalePrice(salePriceLibraryMap, reqBO, bkUccReplacePriceQryBusiBO);
                    }
                } else {
                    this.findRegionAndUnifySalePrice(salePriceLibraryMap, reqBO, bkUccReplacePriceQryBusiBO);
                }
            }
            this.unitConvertPrice(bkUccReplacePriceQryBusiBO);
            priceList.add(bkUccReplacePriceQryBusiBO);
        }
        rspBO.setPriceList(priceList);
        return rspBO;
    }

    private void unitConvertPrice(BkUccReplacePriceQryBusiBO priceBo) {
        if (!Objects.isNull(priceBo.getAgrPrice())) {
            BigDecimal agrPrice = BkMoneyUtils.unitConvertPrice((BigDecimal)priceBo.getAgrPrice());
            priceBo.setAgrPrice(agrPrice);
        }
        if (!Objects.isNull(priceBo.getSalePrice())) {
            BigDecimal salePrice = BkMoneyUtils.unitConvertPrice((BigDecimal)priceBo.getSalePrice());
            priceBo.setSalePrice(salePrice);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(priceBo.getLadderPriceList())) {
            for (BkUccReplacePriceLadderPriceBusiBO ladderPriceBo : priceBo.getLadderPriceList()) {
                if (Objects.isNull(ladderPriceBo.getPrice())) continue;
                BigDecimal price = BkMoneyUtils.unitConvertPrice((BigDecimal)ladderPriceBo.getPrice());
                ladderPriceBo.setPrice(price);
            }
        }
    }

    private void findRegionAndUnifySalePrice(Map<Integer, List<BkUccPriceVersionInfoAndLibraryPO>> priceLibraryMap, BkUccReplacePriceQryBusiReqBO reqBO, BkUccReplacePriceQryBusiBO bkUccReplacePriceQryBusiBO) {
        List<BkUccPriceVersionInfoAndLibraryPO> regionPriceList = priceLibraryMap.get(2);
        if (!(CollectionUtils.isEmpty(regionPriceList) || Objects.isNull(reqBO.getProvince()) || Objects.isNull(reqBO.getCity()))) {
            List regionPriceFilterList = regionPriceList.stream().filter(v -> v.getProvince().equals(reqBO.getProvince()) && v.getCity().equals(reqBO.getCity())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(regionPriceFilterList)) {
                bkUccReplacePriceQryBusiBO.setSalePrice(((BkUccPriceVersionInfoAndLibraryPO)regionPriceFilterList.get(0)).getPrice());
            } else {
                List<BkUccPriceVersionInfoAndLibraryPO> unifyPriceList = priceLibraryMap.get(1);
                if (!CollectionUtils.isEmpty(unifyPriceList)) {
                    bkUccReplacePriceQryBusiBO.setSalePrice(unifyPriceList.get(0).getPrice());
                } else {
                    bkUccReplacePriceQryBusiBO.setIsAvailable(0);
                }
            }
        } else {
            List<BkUccPriceVersionInfoAndLibraryPO> unifyPriceList = priceLibraryMap.get(1);
            if (!CollectionUtils.isEmpty(unifyPriceList)) {
                bkUccReplacePriceQryBusiBO.setSalePrice(unifyPriceList.get(0).getPrice());
            } else {
                bkUccReplacePriceQryBusiBO.setIsAvailable(0);
            }
        }
    }

    private BkUccReplacePriceQryBusiBO findRegionAndUnifyPrice(Map<Integer, List<BkUccPriceVersionInfoAndLibraryPO>> priceLibraryMap, BkUccReplacePriceQryBusiSkuBO skuBO, boolean isFindSalePrice, BkUccReplacePriceQryBusiReqBO reqBO, Integer agrType) {
        BkUccReplacePriceQryBusiBO bkUccReplacePriceQryBusiBO = new BkUccReplacePriceQryBusiBO();
        bkUccReplacePriceQryBusiBO.setSkuId(skuBO.getSkuId());
        bkUccReplacePriceQryBusiBO.setAgrType(agrType);
        List<BkUccPriceVersionInfoAndLibraryPO> regionPriceList = priceLibraryMap.get(2);
        if (!(CollectionUtils.isEmpty(regionPriceList) || Objects.isNull(reqBO.getProvince()) || Objects.isNull(reqBO.getCity()))) {
            List<BkUccPriceVersionInfoAndLibraryPO> regionPriceFilterList = regionPriceList.stream().filter(v -> v.getProvince().equals(reqBO.getProvince()) && v.getCity().equals(reqBO.getCity())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(regionPriceFilterList)) {
                bkUccReplacePriceQryBusiBO = this.findRegionPrice(regionPriceFilterList, skuBO, agrType);
            } else {
                List<BkUccPriceVersionInfoAndLibraryPO> unifyPriceList = priceLibraryMap.get(1);
                if (!CollectionUtils.isEmpty(unifyPriceList)) {
                    bkUccReplacePriceQryBusiBO = this.findRegionPrice(unifyPriceList, skuBO, agrType);
                } else {
                    bkUccReplacePriceQryBusiBO.setIsAvailable(0);
                    isFindSalePrice = false;
                }
            }
        } else {
            List<BkUccPriceVersionInfoAndLibraryPO> unifyPriceList = priceLibraryMap.get(1);
            if (!CollectionUtils.isEmpty(unifyPriceList)) {
                bkUccReplacePriceQryBusiBO = this.findRegionPrice(unifyPriceList, skuBO, agrType);
            } else {
                bkUccReplacePriceQryBusiBO.setIsAvailable(0);
                isFindSalePrice = false;
            }
        }
        return bkUccReplacePriceQryBusiBO;
    }

    private BkUccReplacePriceQryBusiBO findRegionPrice(List<BkUccPriceVersionInfoAndLibraryPO> regionPriceFilterList, BkUccReplacePriceQryBusiSkuBO skuBO, Integer agrType) {
        BkUccPriceVersionInfoAndLibraryPO regionPrice = regionPriceFilterList.get(0);
        BkUccReplacePriceQryBusiBO regionPriceBo = new BkUccReplacePriceQryBusiBO();
        regionPriceBo.setSkuId(skuBO.getSkuId());
        regionPriceBo.setIsAvailable(1);
        regionPriceBo.setAgrType(agrType);
        regionPriceBo.setAgrPrice(regionPrice.getPrice());
        regionPriceBo.setRate(regionPrice.getRate());
        return regionPriceBo;
    }

    private BkUccReplacePriceQryBusiBO findAreaPrice(List<BkUccPriceVersionInfoAndLibraryPO> areaPriceFilterList, BkUccReplacePriceQryBusiSkuBO skuBO, Integer agrType) {
        BkUccPriceVersionInfoAndLibraryPO areaPrice = areaPriceFilterList.get(0);
        BkUccReplacePriceQryBusiBO areaPriceBo = new BkUccReplacePriceQryBusiBO();
        areaPriceBo.setSkuId(skuBO.getSkuId());
        areaPriceBo.setIsAvailable(1);
        areaPriceBo.setAgrType(agrType);
        areaPriceBo.setAgrPrice(areaPrice.getPrice());
        areaPriceBo.setRate(areaPrice.getRate());
        return areaPriceBo;
    }

    private BkUccReplacePriceQryBusiBO findLadderPrice(List<BkUccPriceVersionInfoAndLibraryPO> ladderPriceList, BkUccReplacePriceQryBusiSkuBO skuBO, Integer agrType) {
        BkUccReplacePriceQryBusiBO ladderPriceBo = new BkUccReplacePriceQryBusiBO();
        ladderPriceBo.setSkuId(skuBO.getSkuId());
        ladderPriceBo.setIsAvailable(1);
        ladderPriceBo.setAgrType(agrType);
        ArrayList<BkUccReplacePriceLadderPriceBusiBO> ladderReplacePriceList = new ArrayList<BkUccReplacePriceLadderPriceBusiBO>();
        ladderPriceList.forEach(v -> {
            BkUccReplacePriceLadderPriceBusiBO bkUccReplacePriceLadderPriceBusiBO = new BkUccReplacePriceLadderPriceBusiBO();
            bkUccReplacePriceLadderPriceBusiBO.setStart(v.getStart());
            bkUccReplacePriceLadderPriceBusiBO.setEnd(v.getStop());
            bkUccReplacePriceLadderPriceBusiBO.setPrice(v.getPrice());
            bkUccReplacePriceLadderPriceBusiBO.setRate(v.getRate());
            ladderReplacePriceList.add(bkUccReplacePriceLadderPriceBusiBO);
        });
        ladderPriceBo.setLadderPriceList(ladderReplacePriceList);
        return ladderPriceBo;
    }

    private BkUccReplacePriceQryBusiRspBO checkReqBo(BkUccReplacePriceQryBusiReqBO reqBO) {
        BkUccReplacePriceQryBusiRspBO rspBO = new BkUccReplacePriceQryBusiRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        for (BkUccReplacePriceQryBusiSkuBO skuBO : reqBO.getSkuList()) {
            if (Objects.isNull(skuBO.getSkuId())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5355\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (!Objects.isNull(skuBO.getAgrCode())) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u534f\u8bae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

