/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.extension.busibase.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.extension.bo.BkUccBatchSkuBO;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.extension.busibase.atom.api.BkUccApproveCreationAtomService;
import com.tydic.commodity.extension.busibase.atom.api.BkUccSkuStatusUpdatesAtomService;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccApproveCreationAtomReqBO;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccApproveCreationAtomRspBO;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccSkuUpdateStatusBO;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.extension.busibase.atom.bo.BkUccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.extension.busibase.busi.api.BkUccUpAndOffApplyBusiService;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.extension.dao.BkEacRuTaskApprovalMapper;
import com.tydic.commodity.extension.po.BkEacRuTaskApprovalPo;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BkUccUpAndOffApplyBusiServiceImpl
implements BkUccUpAndOffApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(BkUccUpAndOffApplyBusiServiceImpl.class);
    @Value(value="${SERVICE_CODE:UCC001}")
    private String SERVICE_CODE;
    @Value(value="${NULL_PROCESS:NULL_PROCESS}")
    private String NULL_PROCESS;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private BkUccApproveCreationAtomService bkUccApproveCreationAtomService;
    @Autowired
    private BkUccSkuStatusUpdatesAtomService bkUccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private BkEacRuTaskApprovalMapper bkEacRuTaskApprovalMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;

    @Override
    public BkUccUpAndOffApplyAbilityRspBO dealUpAndOffApply(BkUccUpAndOffApplyAbilityReqBO reqBO, ExtReqBO extReqBO) {
        BkUccUpAndOffApplyAbilityRspBO rspBO = new BkUccUpAndOffApplyAbilityRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)extReqBO.getProcess())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u6d41\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Long, List<BkUccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(BkUccBatchSkuBO::getSupplierShopId));
        ArrayList<Long> skus = new ArrayList();
        Iterator<Long> iteratorSku = mapSku.keySet().iterator();
        Sequence instance = Sequence.getInstance();
        Long approvalId = instance.nextId();
        while (iteratorSku.hasNext()) {
            Long supplierShopId = iteratorSku.next();
            skus = mapSku.get(supplierShopId).stream().map(BkUccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPo> uccSkuPos = null;
            uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
            List<Long> failIds = new ArrayList();
            List<Long> failIdAudit = new ArrayList();
            if (uccSkuPos.size() < skus.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            try {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (extReqBO.getStatusOld().contains(uccSkuPo.getSkuStatus())) continue;
                        failIds.add(uccSkuPo.getSkuId());
                    }
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (StringUtils.isEmpty((Object)uccSkuPo.getApprovalStatus()) || !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus())) && !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus())) && !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus()))) continue;
                        failIdAudit.add(uccSkuPo.getSkuId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIds = ListUtils.removeNull(failIds))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIds.toString() + "\u5f53\u524d\u72b6\u6001\u4e0d\u6b63\u786e");
                    return rspBO;
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(failIdAudit = ListUtils.removeNull(failIdAudit))) continue;
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5355\u54c1" + failIdAudit.toString() + "\u6b63\u5728\u5ba1\u6279\u4e2d");
                return rspBO;
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
        }
        BkUccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = new BkUccApproveCreationAtomRspBO();
        if (!reqBO.getNeedProcess().booleanValue()) {
            uccApproveCreationAtomRspBO.setFinish(true);
        } else if (!extReqBO.getProcess().equals(this.NULL_PROCESS)) {
            BkUccApproveCreationAtomReqBO approveCreationAtomReqBO = new BkUccApproveCreationAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)approveCreationAtomReqBO));
            approveCreationAtomReqBO.setObjId(Arrays.asList(approvalId));
            approveCreationAtomReqBO.setMenuId(extReqBO.getProcess());
            approveCreationAtomReqBO.setObjType(extReqBO.getAuditObjType());
            approveCreationAtomReqBO.setOrderId(approvalId);
            approveCreationAtomReqBO.setUserId(reqBO.getUserId());
            try {
                uccApproveCreationAtomRspBO = this.bkUccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
            }
            if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
            }
        } else {
            uccApproveCreationAtomRspBO.setFinish(true);
        }
        if (uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
            Map<Long, List<BkUccBatchSkuBO>> mapSku1 = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(BkUccBatchSkuBO::getSupplierShopId));
            for (Long supplierShopId : mapSku1.keySet()) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO;
                skus = mapSku1.get(supplierShopId).stream().map(BkUccBatchSkuBO::getSkuId).collect(Collectors.toList());
                this.updateSkuStatus(extReqBO.getStatusApproval(), "", "", skus, supplierShopId, reqBO, extReqBO);
                if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                    try {
                        for (Long skuId : skus) {
                            uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                            uccSkuPutCirReqBO.setSkuId(skuId);
                            uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                            uccSkuPutCirReqBO.setDownType(extReqBO.getOperate());
                            uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr(new Date()));
                            uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                            uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                            this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                    }
                }
                if (!ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) continue;
                try {
                    for (Long skuId : skus) {
                        uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                        uccSkuPutCirReqBO.setSkuId(skuId);
                        uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                        uccSkuPutCirReqBO.setUptype(extReqBO.getOperate());
                        uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                        uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                        uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                        this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                }
            }
        } else {
            try {
                Map<Long, List<BkUccBatchSkuBO>> mapSku2 = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(BkUccBatchSkuBO::getSupplierShopId));
                for (Long supplierShopId : mapSku2.keySet()) {
                    skus = mapSku2.get(supplierShopId).stream().map(BkUccBatchSkuBO::getSkuId).collect(Collectors.toList());
                    if (ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) {
                        this.updateSkuStatus(null, extReqBO.getAuditStatusApply(), uccApproveCreationAtomRspBO.getStepId(), skus, supplierShopId, reqBO, extReqBO);
                    }
                    if (!ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) continue;
                    this.updateSkuStatus(extReqBO.getStatusApply(), extReqBO.getAuditStatusApply(), uccApproveCreationAtomRspBO.getStepId(), skus, supplierShopId, reqBO, extReqBO);
                }
                ArrayList<BkEacRuTaskApprovalPo> bkEacRuTaskApprovalPoList = new ArrayList<BkEacRuTaskApprovalPo>();
                for (BkUccBatchSkuBO businessIdBo : reqBO.getBatchSkuList()) {
                    BkEacRuTaskApprovalPo po = new BkEacRuTaskApprovalPo();
                    po.setId(instance.nextId());
                    po.setApprovalId(approvalId);
                    po.setApprovalCode(String.valueOf(approvalId));
                    po.setSkuId(businessIdBo.getSkuId());
                    po.setAuditFlag(1);
                    po.setCreateTime(new Date());
                    po.setCreateOperName("auto");
                    bkEacRuTaskApprovalPoList.add(po);
                }
                this.bkEacRuTaskApprovalMapper.batchInsert(bkEacRuTaskApprovalPoList);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
        if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
            for (BkUccBatchSkuBO bkUccBatchSkuBO : reqBO.getBatchSkuList()) {
                UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
                uccSkuExpandPo.setSkuId(bkUccBatchSkuBO.getSkuId());
                List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
                uccSkuExpandPo.setExpand15(reqBO.getFileAnnex());
                uccSkuExpandPo.setExpand16(reqBO.getAuditAdvice());
                if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
                    this.uccSkuExpandMapper.updateSkuExpand(uccSkuExpandPo);
                    continue;
                }
                List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(bkUccBatchSkuBO.getSkuId()), null);
                uccSkuExpandPo.setCommodityId(uccSkuPoList.get(0).getCommodityId());
                uccSkuExpandPo.setSupplierShopId(uccSkuPoList.get(0).getSupplierShopId());
                this.uccSkuExpandMapper.insertSkuExpand(uccSkuExpandPo);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, BkUccUpAndOffApplyAbilityReqBO reqBO, ExtReqBO extReqBO) {
        BkUccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        BkUccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new BkUccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<BkUccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<BkUccSkuUpdateStatusBO>();
        BkUccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new BkUccSkuUpdateStatusBO();
            bo.setSkuId(each);
            if (!Objects.isNull(newStatus)) {
                bo.setSkuStatus(newStatus);
                if (ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) {
                    bo.setOnShelveTime(new Date());
                }
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserName(reqBO.getName());
        try {
            statusChangeUpdateSpuAtomRspBO = this.bkUccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

