/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.extension.busibase.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.enumType.AssignCodeEnum;
import com.tydic.commodity.base.enumType.PricessingStepsEnum;
import com.tydic.commodity.base.enumType.ProcessingStepsEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.commodity.base.extension.constant.UccConstants;
import com.tydic.commodity.base.extension.enumType.BkSkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.extension.busibase.comb.api.BkExportSkuManagementListQryCombService;
import com.tydic.commodity.extension.busibase.comb.bo.BkUccCombEsCommodityBo;
import com.tydic.commodity.extension.busibase.comb.bo.BkUccSkuManagementListCombQryBO;
import com.tydic.commodity.extension.busibase.comb.bo.BkUccSkuManagementListQryCombReqBO;
import com.tydic.commodity.extension.busibase.comb.bo.BkUccSkuManagementListQryCombRspBO;
import com.tydic.commodity.extension.dao.BkUccPriceLibraryMapper;
import com.tydic.commodity.extension.dao.BkUccRelPriceVersionMapper;
import com.tydic.commodity.extension.po.BkUccPriceLibraryPO;
import com.tydic.commodity.extension.po.BkUccRelPriceVersionResultPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BkExportSkuManagementListQryCombServiceImpl
implements BkExportSkuManagementListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(BkExportSkuManagementListQryCombServiceImpl.class);
    private static final long serialVersionUID = 1956659951572577168L;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    private Long userId;
    @Autowired
    private BkUccPriceLibraryMapper bkUccPriceLibraryMapper;
    @Autowired
    private BkUccRelPriceVersionMapper bkUccRelPriceVersionMapper;

    @Override
    public BkUccSkuManagementListQryCombRspBO getSkuManagementListQry(BkUccSkuManagementListQryCombReqBO reqBO) {
        this.userId = reqBO.getUserId();
        BkUccSkuManagementListQryCombRspBO rspBo = new BkUccSkuManagementListQryCombRspBO();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List list = rspBo.getRows().stream().map(BkUccSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
        }
        return rspBo;
    }

    private void qryPriceDetail(BkUccSkuManagementListCombQryBO bo) {
        bo.setSalePrice(null);
        Page page = new Page();
        page.setPageNo(-1);
        page.setPageSize(-1);
        BkUccPriceLibraryPO po = new BkUccPriceLibraryPO();
        po.setAgrId(bo.getAgrId());
        po.setMaterialCode(bo.getMaterialCode());
        po.setPriceMod(UccConstants.PRICE_MOD_UNIFY);
        List<BkUccPriceLibraryPO> bkUccAgrPriceLibraryPOList = this.bkUccPriceLibraryMapper.qryUccPriceLibraryForSkuDetailToPage(po, (Page<BkUccPriceLibraryPO>)page);
        ArrayList row = new ArrayList();
        if (!CollectionUtils.isEmpty(bkUccAgrPriceLibraryPOList)) {
            if (bkUccAgrPriceLibraryPOList.size() > 1) {
                log.error("\u7269\u6599\u7f16\u7801\u4e3a\uff1a" + bo.getMaterialCode() + "\u7684\u5546\u54c1\u7edf\u4e00\u91c7\u8d2d\u4ef7\u5b58\u5728\u591a\u6761");
                return;
            }
            String agrPriceVersionCode = bkUccAgrPriceLibraryPOList.get(0).getPriceVersionCode();
            bo.setAgreementPrice(bkUccAgrPriceLibraryPOList.get(0).getPrice());
            bo.setRate(bkUccAgrPriceLibraryPOList.get(0).getRate());
            BkUccRelPriceVersionResultPO salePriceVersionPo = this.bkUccRelPriceVersionMapper.qryRelPriceVersionByAgr(agrPriceVersionCode, null, UccConstants.PRICE_STATUS_PUR_EFFECT);
            List<Object> bkUccSalePriceLibraryPOList = new ArrayList();
            if (!Objects.isNull(salePriceVersionPo)) {
                BkUccPriceLibraryPO salePriceLibPo = new BkUccPriceLibraryPO();
                salePriceLibPo.setPriceVersionCode(salePriceVersionPo.getSalePriceVersionCode());
                salePriceLibPo.setMaterialCode(bo.getMaterialCode());
                salePriceLibPo.setPriceMod(UccConstants.PRICE_MOD_UNIFY);
                bkUccSalePriceLibraryPOList = this.bkUccPriceLibraryMapper.qryUccEffSalePriceLibrary(salePriceLibPo);
                if (bkUccSalePriceLibraryPOList.size() > 1) {
                    log.error("\u7269\u6599\u7f16\u7801\u4e3a\uff1a" + bo.getMaterialCode() + "\u7684\u5546\u54c1\u7edf\u4e00\u9500\u552e\u4ef7\u5b58\u5728\u591a\u6761");
                    return;
                }
                if (!CollectionUtils.isEmpty(bkUccSalePriceLibraryPOList)) {
                    bo.setSalePrice(((BkUccPriceLibraryPO)bkUccSalePriceLibraryPOList.get(0)).getPrice());
                }
            }
        }
        if (bo.getAgrType() == 2) {
            bo.setSalePrice(bo.getAgreementPrice());
        }
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(BkUccSkuManagementListQryCombReqBO reqBo) {
        RangeQueryBuilder createTimeQb;
        WildcardQueryBuilder wildcardQuery;
        WildcardQueryBuilder wildcardQuery2;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)reqBo.getProcessingSteps())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"processing_steps", (Object)reqBo.getProcessingSteps()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(reqBo.getApprovalStatus())) {
            ArrayList<Integer> approval = new ArrayList<Integer>();
            approval.add(21);
            approval.add(23);
            approval.add(null);
            if (reqBo.getApprovalStatus().contains(null)) {
                approval.removeAll(reqBo.getApprovalStatus());
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", approval));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", reqBo.getApprovalStatus()));
            }
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        ArrayList proNotExtOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getProNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getPurNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getSupNotExtendOrgIds());
        }
        ArrayList extOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getProExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getPurExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getSupExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty(proNotExtOrgIdList) || !CollectionUtils.isEmpty(extOrgIdList)) {
            BoolQueryBuilder orgQueryBuilder = QueryBuilders.boolQuery();
            if (!CollectionUtils.isEmpty(proNotExtOrgIdList)) {
                List collect = proNotExtOrgIdList.stream().distinct().collect(Collectors.toList());
                orgQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_org_id", collect));
            }
            if (!CollectionUtils.isEmpty(extOrgIdList)) {
                List extOrgIds = extOrgIdList.stream().distinct().collect(Collectors.toList());
                for (Long extOrgId : extOrgIds) {
                    orgQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplier_org_path.keyword", (String)("*" + extOrgId + "*")));
                }
            }
            boolQueryBuilder.must((QueryBuilder)orgQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgrType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agr_type", (Object)reqBo.getAgrType()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (reqBo.getStdSkuStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_status", (Object)reqBo.getStdSkuStatus()));
        }
        if (reqBo.getCreateType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_type", (Object)reqBo.getCreateType()));
        }
        if (reqBo.getStdSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_id", (Object)reqBo.getStdSkuId()));
        }
        if (reqBo.getBindStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"bind_status", (Object)reqBo.getBindStatus()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApplyNo())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"apply_no.keyword", (String)("*" + reqBo.getApplyNo() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"std_sku_code.keyword", (String)("*" + reqBo.getStdSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            String skuName = reqBo.getSkuName().replaceAll("\\\\", "\\\\\\\\");
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + skuName + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getShortDesc())) {
            String shortDesc = reqBo.getShortDesc().replaceAll("\\\\", "\\\\\\\\");
            wildcardQuery = QueryBuilders.wildcardQuery((String)"short_desc.keyword", (String)("*" + shortDesc + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"material_name", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getInnerSkuCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"inner_sku_code.keyword", (String)("*" + reqBo.getInnerSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery2 = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery2);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            RangeQueryBuilder discountQbStar = QueryBuilders.rangeQuery((String)"discount").gte((Object)reqBo.getDiscountStar());
            boolQueryBuilder.must((QueryBuilder)discountQbStar);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            RangeQueryBuilder discountQbEnd = QueryBuilders.rangeQuery((String)"discount").lte((Object)reqBo.getDiscountEnd());
            boolQueryBuilder.must((QueryBuilder)discountQbEnd);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeStar())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").gte((Object)reqBo.getCreateTimeStar().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").lte((Object)reqBo.getCreateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        log.debug("\u67e5\u8be2\u6761\u4ef6" + boolQueryBuilder.toString());
        return boolQueryBuilder;
    }

    private String excuteEsSql(BkUccSkuManagementListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSortName()) && "asc".equals(reqBo.getSortOrder())) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSortName())) {
            if (reqBo.getSortName().equals("skuCode")) {
                sortField = "sku_code.keyword";
            } else if (reqBo.getSortName().equals("extSkuId")) {
                sortField = "ext_sku_id.keyword";
            } else if (reqBo.getSortName().equals("skuName")) {
                sortField = "sku_name.keyword";
            } else if (reqBo.getSortName().equals("commodityCode")) {
                sortField = "commodity_code.keyword";
            } else if (reqBo.getSortName().equals("extSpuId")) {
                sortField = "ext_spu_id.keyword";
            }
        }
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        return queryJson.toString();
    }

    private BkUccSkuManagementListQryCombRspBO dealSearchData(String result, BkUccSkuManagementListQryCombReqBO reqBo) {
        BkUccSkuManagementListQryCombRspBO rspBo = new BkUccSkuManagementListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<BkUccCombEsCommodityBo> commodityModels = new ArrayList<BkUccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                BkUccCombEsCommodityBo commodity = new BkUccCombEsCommodityBo();
                try {
                    commodity = (BkUccCombEsCommodityBo)JSON.toJavaObject((JSON)data, BkUccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private BkUccSkuManagementListQryCombRspBO copyData(List<BkUccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        BkUccSkuManagementListQryCombRspBO rspBo = new BkUccSkuManagementListQryCombRspBO();
        ArrayList<BkUccSkuManagementListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<BkUccSkuManagementListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            Object dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (BkUccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    BkUccSkuManagementListCombQryBO uccSkuManagementListQryBO = this.copyBean(cnncEsCommodityBo);
                    if (ObjectUtil.isNotEmpty((Object)uccSkuManagementListQryBO.getProcessingSteps()) && ObjectUtil.isNotEmpty((Object)uccSkuManagementListQryBO.getSkuStatus()) && uccSkuManagementListQryBO.getProcessingSteps() == 4 && uccSkuManagementListQryBO.getSkuStatus() == 16) {
                        uccSkuManagementListQryBO.setSkuStatus(1);
                        uccSkuManagementListQryBO.setSkuStatusDesc("\u5f85\u5173\u8054");
                    }
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private BkUccSkuManagementListCombQryBO copyBean(BkUccCombEsCommodityBo cnncEsCommodityBo) {
        BkUccSkuManagementListCombQryBO uccSkuManagementListQryBO = new BkUccSkuManagementListCombQryBO();
        uccSkuManagementListQryBO.setRelStatus(cnncEsCommodityBo.getRel_status());
        uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
        uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
        uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
        uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
        uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
        uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
        uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
        uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
        uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
        uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
        uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
        uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
        uccSkuManagementListQryBO.setProcessingSteps(cnncEsCommodityBo.getProcessing_steps());
        uccSkuManagementListQryBO.setSkuType(cnncEsCommodityBo.getSku_type());
        uccSkuManagementListQryBO.setPricePassFlag(cnncEsCommodityBo.getPrice_pass_flag());
        uccSkuManagementListQryBO.setApplyId(cnncEsCommodityBo.getApply_id());
        uccSkuManagementListQryBO.setApplyNo(cnncEsCommodityBo.getApply_no());
        uccSkuManagementListQryBO.setStdSkuId(cnncEsCommodityBo.getStd_sku_id());
        uccSkuManagementListQryBO.setStdSkuCode(cnncEsCommodityBo.getStd_sku_code());
        uccSkuManagementListQryBO.setMaterialId(cnncEsCommodityBo.getMaterial_id());
        uccSkuManagementListQryBO.setLongDesc(cnncEsCommodityBo.getLong_desc());
        if (ObjectUtil.isNotEmpty((Object)cnncEsCommodityBo.getBind_status())) {
            uccSkuManagementListQryBO.setBindStatus(cnncEsCommodityBo.getBind_status());
        }
        uccSkuManagementListQryBO.setProcessingStepsDesc(ProcessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getProcessing_steps()));
        uccSkuManagementListQryBO.setPricePassFlagDesc(PricessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getPrice_pass_flag()));
        uccSkuManagementListQryBO.setOoocCleanDesc(YesNoEnum.getTypeDesc((Integer)cnncEsCommodityBo.getOooc_clean()));
        BkSkuStatusEnum statusDesc = BkSkuStatusEnum.getStatusDesc((Integer)cnncEsCommodityBo.getSku_status());
        uccSkuManagementListQryBO.setSkuStatusDesc(statusDesc.getStatusDesc());
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getRel_status())) {
            uccSkuManagementListQryBO.setMatStatus(cnncEsCommodityBo.getRel_status());
            uccSkuManagementListQryBO.setMatStatusDesc(AssignCodeEnum.getTypeDesc((Integer)cnncEsCommodityBo.getRel_status()));
        }
        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
            uccSkuManagementListQryBO.setSkuStatusDesc("\u5df2\u4e0b\u67b6");
            if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                uccSkuManagementListQryBO.setDownTypeDesc(SkuStatusEnum.DOWN_FRAME_STATUS.getStatusDesc());
            }
            if (SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                uccSkuManagementListQryBO.setDownTypeDesc(SkuStatusEnum.EC_DOWN_STATUS.getStatusDesc());
            }
            if (SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                uccSkuManagementListQryBO.setDownTypeDesc(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatusDesc());
            }
            if (SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                uccSkuManagementListQryBO.setDownTypeDesc(SkuStatusEnum.WARN_DOWN_STATUS.getStatusDesc());
            }
        } else {
            if ("31".equals(cnncEsCommodityBo.getSku_status())) {
                uccSkuManagementListQryBO.setSkuStatusDesc("\u5df2\u5220\u9664");
            }
            if (SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                uccSkuManagementListQryBO.setDownTypeDesc(SkuStatusEnum.ON_SHELVES_STATUS.getStatusDesc());
            }
        }
        uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getBrand_id());
        uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
        uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
        uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
        uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
        uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
        uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
        uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
        uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
        uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getDiscounts())) {
            uccSkuManagementListQryBO.setDiscount(new BigDecimal(cnncEsCommodityBo.getDiscounts()));
        }
        if (cnncEsCommodityBo.getDown_time() != null) {
            uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
        }
        if (cnncEsCommodityBo.getUp_time() != null) {
            uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
        }
        if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
            uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
        }
        uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
        uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
        uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
        uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
        uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
        uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
        uccSkuManagementListQryBO.setSell(cnncEsCommodityBo.getSell());
        uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
        uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
            uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
        } else {
            uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
        }
        uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
        uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
        uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
        uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
        uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
        uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
        uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
        uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_name());
        uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
        uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
        if (cnncEsCommodityBo.getComment_number() != null) {
            uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
        } else {
            uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
        }
        if (cnncEsCommodityBo.getSupplier_id() != null) {
            uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
        }
        if (cnncEsCommodityBo.getSupplier_name() != null) {
            uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
        }
        if (cnncEsCommodityBo.getExt_spu_id() != null) {
            uccSkuManagementListQryBO.setExtSpuId(cnncEsCommodityBo.getExt_spu_id());
        }
        if (cnncEsCommodityBo.getExt_sku_id() != null) {
            uccSkuManagementListQryBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
        }
        if (cnncEsCommodityBo.getCreate_time() != null) {
            uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
        }
        if (cnncEsCommodityBo.getAudit_time() != null) {
            uccSkuManagementListQryBO.setAuditTime(new Date(cnncEsCommodityBo.getAudit_time()));
        }
        uccSkuManagementListQryBO.setAgrType(cnncEsCommodityBo.getAgr_type());
        uccSkuManagementListQryBO.setInnerSkuCode(cnncEsCommodityBo.getInner_sku_code());
        uccSkuManagementListQryBO.setAgrId(cnncEsCommodityBo.getAgreement_id());
        uccSkuManagementListQryBO.setCatalogCode(cnncEsCommodityBo.getCatalog_code());
        uccSkuManagementListQryBO.setShortDesc(cnncEsCommodityBo.getShort_desc());
        return uccSkuManagementListQryBO;
    }

    public static void main(String[] args) {
        String name = "M0000004-\u786b\u9178\u94dd\\\u6db2\u4f53\\Al2O3\\\uff1c6.5%\\-";
        String s = name.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\\", "\\\\\\\\");
        System.out.print("\u540d\u5b57\u4e3a\uff1a" + s);
    }
}

