/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecReplyLikeBusiService;
import com.tydic.uec.busi.bo.UecReplyLikeBusiReqBO;
import com.tydic.uec.busi.bo.UecReplyLikeBusiRspBO;
import com.tydic.uec.common.bo.reply.ReplyBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.ReplyThumbUpRecMapper;
import com.tydic.uec.dao.po.ReplyThumbUpRecPO;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecReplyLikeBusiServiceImpl
implements UecReplyLikeBusiService {
    private final ReplyThumbUpRecMapper replyThumbUpRecMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecReplyLikeBusiServiceImpl(ReplyThumbUpRecMapper replyThumbUpRecMapper, UecGenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.replyThumbUpRecMapper = replyThumbUpRecMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecReplyLikeBusiRspBO dealReplyLike(UecReplyLikeBusiReqBO reqBO) {
        Object hashValue = this.redisUtil.hashGet("uec_reply_list_", reqBO.getReplyId().toString());
        if (UecCommonConstant.YES_FLAG.equals(reqBO.getCancelFlag())) {
            return this.handleCancelLike(reqBO, hashValue);
        }
        return this.handleLike(reqBO, hashValue);
    }

    private UecReplyLikeBusiRspBO handleCancelLike(UecReplyLikeBusiReqBO reqBO, Object hashValue) {
        UecReplyLikeBusiRspBO rspBO = new UecReplyLikeBusiRspBO();
        ReplyThumbUpRecPO updateThumb = new ReplyThumbUpRecPO();
        updateThumb.setMemId(reqBO.getReplyThumbUpRec().getMemId());
        updateThumb.setThumbUpType(reqBO.getReplyThumbUpRec().getThumbUpType());
        updateThumb.setIpAddr(reqBO.getReplyThumbUpRec().getIpAddr());
        updateThumb.setReplyId(reqBO.getReplyId());
        updateThumb.setState(UecCommonConstant.StateEnum.NO.value);
        int count = this.replyThumbUpRecMapper.updateByPO(updateThumb);
        if (count == 0) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u70b9\u8d5e\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (UecCommonConstant.YES_FLAG.equals(reqBO.getReplyThumbUpRec().getThumbUpType())) {
            if (hashValue != null) {
                ReplyBO replyInfo = (ReplyBO)hashValue;
                replyInfo.setThumbUpCount(Integer.valueOf(replyInfo.getThumbUpCount() - 1));
                this.redisUtil.hashSet("uec_reply_list_", reqBO.getReplyId().toString(), replyInfo, UecRedisConstant.getExpireMinutes(10, 30));
            }
            this.redisUtil.sRemove("uec_reply_like_" + reqBO.getReplyId().toString(), reqBO.getReplyThumbUpRec().getMemId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u8bba\u53d6\u6d88\u70b9\u8d5e\u6210\u529f");
        return rspBO;
    }

    private UecReplyLikeBusiRspBO handleLike(UecReplyLikeBusiReqBO reqBO, Object hashValue) {
        UecReplyLikeBusiRspBO rspBO = new UecReplyLikeBusiRspBO();
        ReplyThumbUpRecPO paramPO = new ReplyThumbUpRecPO();
        paramPO.setMemId(reqBO.getReplyThumbUpRec().getMemId());
        paramPO.setThumbUpType(reqBO.getReplyThumbUpRec().getThumbUpType());
        paramPO.setReplyId(reqBO.getReplyId());
        paramPO.setState(UecCommonConstant.StateEnum.YES.value);
        ReplyThumbUpRecPO existThumb = this.replyThumbUpRecMapper.getModelBy(paramPO);
        if (existThumb != null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u5df2\u70b9\u8d5e\u8be5\u8bc4\u8bba\uff0c\u4e0d\u80fd\u91cd\u590d\u70b9\u8d5e");
            return rspBO;
        }
        ReplyThumbUpRecPO insertPO = new ReplyThumbUpRecPO();
        BeanUtils.copyProperties((Object)reqBO.getReplyThumbUpRec(), (Object)insertPO);
        if (insertPO.getIsAnonymous() == null) {
            insertPO.setIsAnonymous(UecCommonConstant.AnonymousEnum.NO.value);
        }
        insertPO.setState(UecCommonConstant.StateEnum.YES.value);
        insertPO.setId(this.generateIdUtil.nextId());
        insertPO.setReplyId(reqBO.getReplyId());
        this.replyThumbUpRecMapper.insert(insertPO);
        if (UecCommonConstant.YES_FLAG.equals(reqBO.getReplyThumbUpRec().getThumbUpType())) {
            if (hashValue != null) {
                ReplyBO replyInfo = (ReplyBO)hashValue;
                replyInfo.setThumbUpCount(Integer.valueOf(replyInfo.getThumbUpCount() + 1));
                this.redisUtil.hashSet("uec_reply_list_", reqBO.getReplyId().toString(), replyInfo, UecRedisConstant.getExpireMinutes(10, 30));
            }
            this.redisUtil.sSet("uec_reply_like_" + reqBO.getReplyId().toString(), UecRedisConstant.getExpireMinutes(10, 60), reqBO.getReplyThumbUpRec().getMemId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u8bba\u70b9\u8d5e\u6210\u529f");
        return rspBO;
    }
}

