/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecAnswerUpdateBusiService;
import com.tydic.uec.busi.bo.UecAnswerUpdateBusiReqBO;
import com.tydic.uec.busi.bo.UecAnswerUpdateBusiRspBO;
import com.tydic.uec.common.bo.answer.CommodityAnswerBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.CommodityAnswerMapper;
import com.tydic.uec.dao.po.CommodityAnswerPO;
import com.tydic.uec.utils.RedisUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecAnswerUpdateBusiServiceImpl
implements UecAnswerUpdateBusiService {
    private final CommodityAnswerMapper commodityAnswerMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecAnswerUpdateBusiServiceImpl(CommodityAnswerMapper commodityAnswerMapper, RedisUtil redisUtil) {
        this.commodityAnswerMapper = commodityAnswerMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecAnswerUpdateBusiRspBO updateAnswerInfo(UecAnswerUpdateBusiReqBO reqBO) {
        CommodityAnswerPO updateAnswer = new CommodityAnswerPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAnswerContent())) {
            updateAnswer.setAnswerContent(reqBO.getAnswerContent());
        }
        updateAnswer.setState(reqBO.getState());
        updateAnswer.setAnswerId(reqBO.getAnswerId());
        updateAnswer.setQuestionId(reqBO.getQuestionId());
        int count = this.commodityAnswerMapper.updateById(updateAnswer);
        UecAnswerUpdateBusiRspBO rspBO = new UecAnswerUpdateBusiRspBO();
        if (count != 1) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u4fee\u6539\u56de\u7b54\u5931\u8d25\uff0c\u8be5\u56de\u7b54\u4e0d\u5b58\u5728");
            return rspBO;
        }
        this.updateHashValue(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u56de\u7b54\u6210\u529f");
        return rspBO;
    }

    private void updateHashValue(UecAnswerUpdateBusiReqBO reqBO) {
        String answerId = reqBO.getAnswerId().toString();
        Object hashValue = this.redisUtil.hashGet("uec_answer_list_", answerId);
        if (hashValue == null) {
            return;
        }
        CommodityAnswerBO answerBO = (CommodityAnswerBO)hashValue;
        if (reqBO.getState() != null && !UecCommonConstant.StateEnum.YES.value.equals(reqBO.getState())) {
            this.redisUtil.hashDel("uec_answer_list_", answerId);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAnswerContent())) {
            answerBO.setAnswerContent(reqBO.getAnswerContent());
        }
        this.redisUtil.hashSet("uec_answer_list_", answerId, answerBO, UecRedisConstant.getExpireMinutes(30, 30));
    }
}

