/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.google.common.collect.Maps;
import com.tydic.uec.busi.UecEvaluateDataStatsBusiService;
import com.tydic.uec.busi.bo.UecEvaluateDataStatsBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateDataStatsBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaCountStatsBO;
import com.tydic.uec.common.bo.eva.EvaLabelBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.UnionQuerySqlMapper;
import com.tydic.uec.exception.BusinessException;
import com.tydic.uec.utils.CommonMethodUtil;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecEvaluateDataStatsBusiServiceImpl
implements UecEvaluateDataStatsBusiService {
    private final UnionQuerySqlMapper unionQuerySqlMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecEvaluateDataStatsBusiServiceImpl(UnionQuerySqlMapper unionQuerySqlMapper, RedisUtil redisUtil) {
        this.unionQuerySqlMapper = unionQuerySqlMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateDataStatsBusiRspBO dealDataStatistics(UecEvaluateDataStatsBusiReqBO reqBO) {
        ArrayList<EvaCountStatsBO> statsList = new ArrayList<EvaCountStatsBO>(reqBO.getDataList().size());
        if (UecCommonConstant.StatsType.LABEL.equals(reqBO.getStatsType())) {
            this.handleLabelStatistics(reqBO, statsList);
        } else if (UecCommonConstant.StatsType.COUNT.equals(reqBO.getStatsType())) {
            this.handleCountStatistics(reqBO, statsList);
        } else {
            throw new BusinessException("2222", "\u4e0d\u652f\u6301\u7684\u7edf\u8ba1\u7c7b\u578b[statsType]");
        }
        UecEvaluateDataStatsBusiRspBO rspBO = new UecEvaluateDataStatsBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u4ef7\u7edf\u8ba1\u6210\u529f");
        rspBO.setStatsList(statsList);
        return rspBO;
    }

    private void handleLabelStatistics(UecEvaluateDataStatsBusiReqBO reqBO, List<EvaCountStatsBO> statsList) {
        List<Object> labelList;
        String objId = reqBO.getDataList().get(0).getObjId();
        Integer objType = reqBO.getDataList().get(0).getObjType();
        String labelKey = reqBO.getSysCode() + "_objType#" + objType + "_objId#" + objId + "_label";
        Map<Object, Object> hashMap = this.redisUtil.hashMapGet(labelKey);
        EvaCountStatsBO labelStatsBO = new EvaCountStatsBO();
        if (CollectionUtils.isEmpty(hashMap)) {
            labelList = this.unionQuerySqlMapper.qryLabelCount(reqBO.getSysCode(), objId, objType);
            if (CollectionUtils.isEmpty(labelList)) {
                this.redisUtil.hashSet(labelKey, "empty_data", "empty_data", UecRedisConstant.getExpireMinutes(60, 10));
            } else {
                this.redisUtil.hashDel(labelKey, "empty_data");
                Map<String, Object> saveMap = labelList.stream().collect(Collectors.toMap(EvaLabelBO::getLabelCode, Function.identity()));
                this.redisUtil.hashMapSet(labelKey, saveMap, UecRedisConstant.getExpireMinutes(60, 30));
            }
        } else {
            labelList = hashMap.size() == 1 && hashMap.get("empty_data") != null ? new ArrayList<EvaLabelBO>() : hashMap.values().stream().map(e -> (EvaLabelBO)e).collect(Collectors.toList());
        }
        labelStatsBO.setObjId(objId);
        labelStatsBO.setLabelList(labelList);
        statsList.add(labelStatsBO);
    }

    private void handleCountStatistics(UecEvaluateDataStatsBusiReqBO reqBO, List<EvaCountStatsBO> statsList) {
        Long hashSize = this.redisUtil.hashSize("eva_total_count");
        boolean qryRedis = hashSize != null && hashSize > 0L;
        Long modId = this.unionQuerySqlMapper.getEvaObjModId(reqBO.getSysCode(), reqBO.getDataList().get(0).getObjId(), reqBO.getDataList().get(0).getObjType());
        List<Object> totalCountList = null;
        List<Object> likeCountList = null;
        if (modId != null && qryRedis) {
            List<Object> countKeys = reqBO.getDataList().stream().map(stats -> reqBO.getSysCode() + "_objType#" + stats.getObjType() + "_objId#" + stats.getObjId()).collect(Collectors.toList());
            List<Object> likeKeys = reqBO.getDataList().stream().map(stats -> reqBO.getSysCode() + "_objType#" + stats.getObjType() + "_objId#" + stats.getObjId() + "_like").collect(Collectors.toList());
            totalCountList = this.redisUtil.hashMultiGet("eva_total_count", countKeys);
            likeCountList = this.redisUtil.hashMultiGet("eva_total_count", likeKeys);
        }
        HashMap saveStatsInfo = Maps.newHashMapWithExpectedSize((int)reqBO.getDataList().size());
        for (int i = 0; i < reqBO.getDataList().size(); ++i) {
            String objId = reqBO.getDataList().get(i).getObjId();
            Integer objType = reqBO.getDataList().get(i).getObjType();
            Object countObj = totalCountList != null ? totalCountList.get(i) : null;
            Object likeCountObj = likeCountList != null ? likeCountList.get(i) : null;
            EvaCountStatsBO countStats = new EvaCountStatsBO();
            int totalCount = 0;
            int likeCount = 0;
            if (modId != null) {
                if (countObj == null) {
                    totalCount = this.unionQuerySqlMapper.qryEvaCount(reqBO.getSysCode(), objId, objType);
                    String totalCountKey = reqBO.getSysCode() + "_objType#" + objType + "_objId#" + objId;
                    saveStatsInfo.put(totalCountKey, totalCount);
                } else {
                    totalCount = (Integer)countObj;
                }
                if (likeCountObj == null) {
                    likeCount = this.unionQuerySqlMapper.qryLikeCount(modId, reqBO.getSysCode(), objId, objType);
                    String likeCountKey = reqBO.getSysCode() + "_objType#" + objType + "_objId#" + objId + "_like";
                    saveStatsInfo.put(likeCountKey, likeCount);
                } else {
                    likeCount = (Integer)likeCountObj;
                }
            }
            countStats.setPraiseRate(CommonMethodUtil.accuracy(likeCount, totalCount, 0));
            countStats.setEvaCount(Integer.valueOf(totalCount));
            countStats.setObjId(objId);
            statsList.add(countStats);
        }
        if (saveStatsInfo.size() > 0) {
            this.redisUtil.hashMapSet("eva_total_count", saveStatsInfo, UecRedisConstant.getExpireMinutes(60, 30));
        }
    }
}

