/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecQuestionUpdateBusiService;
import com.tydic.uec.busi.bo.UecQuestionUpdateBusiReqBO;
import com.tydic.uec.busi.bo.UecQuestionUpdateBusiRspBO;
import com.tydic.uec.common.bo.answer.CommodityQuestionBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.CommodityQuestionMapper;
import com.tydic.uec.dao.po.CommodityQuestionPO;
import com.tydic.uec.utils.RedisUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecQuestionUpdateBusiServiceImpl
implements UecQuestionUpdateBusiService {
    private final CommodityQuestionMapper commodityQuestionMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecQuestionUpdateBusiServiceImpl(CommodityQuestionMapper commodityQuestionMapper, RedisUtil redisUtil) {
        this.commodityQuestionMapper = commodityQuestionMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecQuestionUpdateBusiRspBO updateQuestionInfo(UecQuestionUpdateBusiReqBO reqBO) {
        CommodityQuestionPO updateQuestion = new CommodityQuestionPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getQuestionContent())) {
            updateQuestion.setQuestionContent(reqBO.getQuestionContent());
        }
        updateQuestion.setState(reqBO.getState());
        updateQuestion.setQuestionId(reqBO.getQuestionId());
        int count = this.commodityQuestionMapper.updateById(updateQuestion);
        UecQuestionUpdateBusiRspBO rspBO = new UecQuestionUpdateBusiRspBO();
        if (count != 1) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u4fee\u6539\u95ee\u9898\u5931\u8d25\uff0c\u8be5\u95ee\u9898\u4e0d\u5b58\u5728");
            return rspBO;
        }
        this.updateHashValue(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u95ee\u9898\u6210\u529f");
        return rspBO;
    }

    private void updateHashValue(UecQuestionUpdateBusiReqBO reqBO) {
        String questionId = reqBO.getQuestionId().toString();
        Object hashValue = this.redisUtil.hashGet("uec_question_list_", questionId);
        if (hashValue == null) {
            return;
        }
        CommodityQuestionBO questionBO = (CommodityQuestionBO)hashValue;
        if (reqBO.getState() != null && !UecCommonConstant.StateEnum.YES.value.equals(reqBO.getState())) {
            this.redisUtil.hashDel("uec_question_list_", questionId);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getQuestionContent())) {
            questionBO.setQuestionContent(reqBO.getQuestionContent());
        }
        this.redisUtil.hashSet("uec_question_list_", questionId, questionBO, UecRedisConstant.getExpireMinutes(30, 30));
    }
}

