/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.tydic.uec.ability.UecEvaluateBrowseAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateBrowseAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateBrowseAbilityRspBO;
import com.tydic.uec.busi.UecEvaluateBrowseBusiService;
import com.tydic.uec.busi.bo.UecEvaluateBrowseBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateBrowseBusiRspBO;
import com.tydic.uec.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_DEV/1.0.0/com.tydic.uec.ability.UecEvaluateBrowseAbilityService"})
public class UecEvaluateBrowseAbilityServiceImpl
implements UecEvaluateBrowseAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UecEvaluateBrowseAbilityServiceImpl.class);
    private final UecEvaluateBrowseBusiService uecEvaluateBrowseBusiService;

    public UecEvaluateBrowseAbilityServiceImpl(UecEvaluateBrowseBusiService uecEvaluateBrowseBusiService) {
        this.uecEvaluateBrowseBusiService = uecEvaluateBrowseBusiService;
    }

    @HystrixCommand(groupKey="uec", commandKey="dealEvaluateBrowse", commandProperties={@HystrixProperty(name="execution.isolation.strategy", value="SEMAPHORE"), @HystrixProperty(name="execution.isolation.semaphore.maxConcurrentRequests", value="25"), @HystrixProperty(name="execution.isolation.thread.timeoutInMilliseconds", value="10000"), @HystrixProperty(name="circuitBreaker.requestVolumeThreshold", value="5"), @HystrixProperty(name="circuitBreaker.sleepWindowInMilliseconds", value="60000"), @HystrixProperty(name="circuitBreaker.errorThresholdPercentage", value="50")}, threadPoolProperties={@HystrixProperty(name="coreSize", value="10"), @HystrixProperty(name="maxQueueSize", value="30"), @HystrixProperty(name="queueSizeRejectionThreshold", value="15"), @HystrixProperty(name="keepAliveTimeMinutes", value="2")}, fallbackMethod="fallBackCall")
    @PostMapping(value={"dealEvaluateBrowse"})
    public UecEvaluateBrowseAbilityRspBO dealEvaluateBrowse(@RequestBody UecEvaluateBrowseAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        UecEvaluateBrowseBusiReqBO busiReqBO = new UecEvaluateBrowseBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        UecEvaluateBrowseBusiRspBO busiRspBO = this.uecEvaluateBrowseBusiService.dealEvaluateBrowse(busiReqBO);
        UecEvaluateBrowseAbilityRspBO rspBO = new UecEvaluateBrowseAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    public UecEvaluateBrowseAbilityRspBO fallBackCall(UecEvaluateBrowseAbilityReqBO reqBO, Throwable throwable) {
        UecEvaluateBrowseAbilityRspBO rspBO = new UecEvaluateBrowseAbilityRspBO();
        log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff0c\u89e6\u53d1\u7194\u65ad\uff0c\u5931\u8d25\u539f\u56e0----", throwable);
        rspBO.setRespCode("4444");
        rspBO.setRespDesc("\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff0c\u89e6\u53d1\u7194\u65ad");
        return rspBO;
    }

    private void validArgs(UecEvaluateBrowseAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u6d4f\u89c8\u670d\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (reqBO.getEvaId() == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u6d4f\u89c8\u670d\u52a1\u8bc4\u4ef7ID[evaId]\u4e3a\u7a7a");
        }
        if (reqBO.getEvaBrowseRec() == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u6d4f\u89c8\u670d\u52a1\u6d4f\u89c8\u4fe1\u606f[evaBrowseRec]\u4e3a\u7a7a");
        }
    }
}

