/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.tydic.uec.ability.UecQuestionAskAbilityService;
import com.tydic.uec.ability.bo.UecQuestionAskAbilityReqBO;
import com.tydic.uec.ability.bo.UecQuestionAskAbilityRspBO;
import com.tydic.uec.busi.UecQuestionCreateBusiService;
import com.tydic.uec.busi.bo.UecQuestionCreateBusiReqBO;
import com.tydic.uec.busi.bo.UecQuestionCreateBusiRspBO;
import com.tydic.uec.common.bo.answer.AnswerExtBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.exception.BusinessException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_DEV/1.0.0/com.tydic.uec.ability.UecQuestionAskAbilityService"})
public class UecQuestionAskAbilityServiceImpl
implements UecQuestionAskAbilityService {
    private final UecQuestionCreateBusiService uecQuestionCreateBusiService;

    public UecQuestionAskAbilityServiceImpl(UecQuestionCreateBusiService uecQuestionCreateBusiService) {
        this.uecQuestionCreateBusiService = uecQuestionCreateBusiService;
    }

    @PostMapping(value={"askQuestion"})
    public UecQuestionAskAbilityRspBO askQuestion(@RequestBody UecQuestionAskAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        UecQuestionCreateBusiReqBO busiReqBO = new UecQuestionCreateBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        UecQuestionCreateBusiRspBO busiRspBO = this.uecQuestionCreateBusiService.createQuestion(busiReqBO);
        UecQuestionAskAbilityRspBO rspBO = new UecQuestionAskAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void validArgs(UecQuestionAskAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u63d0\u51fa\u95ee\u9898\u670d\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (reqBO.getQuestionInfo() == null) {
            throw new BusinessException("4444", "\u63d0\u51fa\u95ee\u9898\u670d\u52a1\u95ee\u9898\u57fa\u672c\u4fe1\u606f[questionInfo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getQuestionInfo().getQuestionContent())) {
            throw new BusinessException("4444", "\u63d0\u51fa\u95ee\u9898\u670d\u52a1\u95ee\u9898\u6b63\u6587[questionInfo.questionContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getQuestionInfo().getSysCode())) {
            throw new BusinessException("4444", "\u63d0\u51fa\u95ee\u9898\u670d\u52a1\u4e1a\u52a1\u7cfb\u7edf[questionInfo.sysCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuestionInfo().getObjType() == null) {
            throw new BusinessException("4444", "\u63d0\u51fa\u95ee\u9898\u670d\u52a1\u95ee\u9898\u5bf9\u8c61\u7c7b\u578b[questionInfo.objType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getQuestionInfo().getObjId())) {
            throw new BusinessException("4444", "\u63d0\u51fa\u95ee\u9898\u670d\u52a1\u95ee\u9898\u5bf9\u8c61ID[questionInfo.objId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuestionInfo().getIsAnonymous() == null) {
            reqBO.getQuestionInfo().setIsAnonymous(UecCommonConstant.AnonymousEnum.NO.value);
        }
        reqBO.getQuestionInfo().setState(UecCommonConstant.StateEnum.YES.value);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExtList())) {
            for (AnswerExtBO extBO : reqBO.getExtList()) {
                if (!StringUtils.isBlank((CharSequence)extBO.getFieldCode())) continue;
                throw new BusinessException("4444", "\u63d0\u51fa\u95ee\u9898\u670d\u52a1\u6269\u5c55\u5c5e\u6027\u7f16\u7801[extList.fieldCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

