/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.umc.service.todo.UmcQueryToDoListService;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoListReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoListRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBo;
import com.tydic.uec.atom.UecEvaluateUpdateAtomService;
import com.tydic.uec.atom.bo.UecEvaluateUpdateAtomReqBO;
import com.tydic.uec.atom.bo.UecEvaluateUpdateAtomRspBO;
import com.tydic.uec.busi.UecTaskDealBusiService;
import com.tydic.uec.busi.bo.UecTaskDealBusiReqBO;
import com.tydic.uec.busi.bo.UecTaskDealBusiRspBO;
import com.tydic.uec.common.bo.audit.UecCandidatesBO;
import com.tydic.uec.common.bo.audit.UecTaskInfoBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.UocOrderTaskDealMapper;
import com.tydic.uec.dao.UocOrderTaskInstLogMapper;
import com.tydic.uec.dao.UocOrderTaskInstMapper;
import com.tydic.uec.dao.po.UocOrderTaskDealPo;
import com.tydic.uec.dao.po.UocOrderTaskInstLogPo;
import com.tydic.uec.dao.po.UocOrderTaskInstPo;
import com.tydic.uec.exception.BusinessException;
import com.tydic.uec.utils.UecGenerateIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UecTaskDealBusiServiceImpl
implements UecTaskDealBusiService {
    private static final Logger log = LoggerFactory.getLogger(UecTaskDealBusiServiceImpl.class);
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;
    @Autowired
    private UecGenerateIdUtil generateIdUtil;
    @Autowired
    private UecEvaluateUpdateAtomService uecEvaluateUpdateAtomService;
    @Autowired
    private UmcQueryToDoListService umcQueryToDoListService;
    @Autowired
    private UmcSendHaveDoneService umcSendHaveDoneService;

    @Override
    public UecTaskDealBusiRspBO dealTask(UecTaskDealBusiReqBO reqBO) {
        UocOrderTaskInstPo UocOrderTaskInst;
        List<UecTaskInfoBO> nextTaskInfos;
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            reqBO.getCompleteTaskInfos().forEach(completeTaskBo -> {
                UocOrderTaskInstPo uocOrderTaskInstPo = new UocOrderTaskInstPo();
                uocOrderTaskInstPo.setOrderId(reqBO.getOrderId());
                uocOrderTaskInstPo.setTaskInstId(completeTaskBo.getTaskId());
                List<UocOrderTaskInstPo> uocOrderTaskInsts = this.uocOrderTaskInstMapper.getList(uocOrderTaskInstPo);
                if (CollectionUtils.isEmpty(uocOrderTaskInsts)) {
                    throw new BusinessException("8888", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u4e0d\u5b58\u5728");
                }
                if (UecCommonConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                    throw new BusinessException("8888", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5df2\u5b8c\u7ed3");
                }
                completeTaskBo.setBusiObjType(uocOrderTaskInsts.get(0).getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInsts.get(0).getObjId());
                UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
                updateSetPo.setFinishTag(UecCommonConstant.PROC_TASK_FINISHED.FINISHED);
                updateSetPo.setFinishTime(new Date());
                updateSetPo.setDealOperId(reqBO.getUserId() + "");
                updateSetPo.setDealOperName(reqBO.getUsername());
                updateSetPo.setDealResult(completeTaskBo.getDealResult());
                updateSetPo.setDealRemark(completeTaskBo.getDealRemark());
                UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
                updateWherePo.setOrderId(reqBO.getOrderId());
                updateWherePo.setTaskInstId(completeTaskBo.getTaskId());
                this.uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
                if (completeTaskBo.getAuditStepFinish() != null && completeTaskBo.getAuditStepFinish().booleanValue()) {
                    UocOrderTaskInstPo UocOrderTaskInst = new UocOrderTaskInstPo();
                    UocOrderTaskInst.setOrderId(reqBO.getOrderId());
                    UocOrderTaskInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                    UocOrderTaskInst.setFinishTag(UecCommonConstant.PROC_TASK_FINISHED.NO_FINISHED);
                    this.deleteProcTaskInst(UocOrderTaskInst);
                }
                if (completeTaskBo.getFinish() != null && completeTaskBo.getFinish().booleanValue()) {
                    UecEvaluateUpdateAtomReqBO atomReqBO = new UecEvaluateUpdateAtomReqBO();
                    atomReqBO.setEvaId(reqBO.getOrderId());
                    if (completeTaskBo.getDealResult() == 1) {
                        atomReqBO.setEvaState(UecCommonConstant.StateEnum.YES.value);
                    } else {
                        atomReqBO.setEvaState(UecCommonConstant.StateEnum.NO.value);
                    }
                    UecEvaluateUpdateAtomRspBO atomRspBO = this.uecEvaluateUpdateAtomService.updateEvaluateInfo(atomReqBO);
                    if (!"0000".equals(atomRspBO.getRespCode())) {
                        throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
                    }
                }
                this.sendTodoDoneCB(reqBO, completeTaskBo.getTaskId());
            });
        }
        if (!CollectionUtils.isEmpty(nextTaskInfos = reqBO.getNextTaskInfos())) {
            ArrayList<UocOrderTaskDealPo> saveDealList = new ArrayList<UocOrderTaskDealPo>();
            ArrayList<UocOrderTaskInstPo> saveList = new ArrayList<UocOrderTaskInstPo>();
            for (UecTaskInfoBO nextTaskInfo : nextTaskInfos) {
                UocOrderTaskInstPo taskBo = new UocOrderTaskInstPo();
                taskBo.setId(this.generateIdUtil.nextId());
                taskBo.setOrderId(reqBO.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskId());
                taskBo.setObjId(nextTaskInfo.getBusiObjId());
                taskBo.setObjType(nextTaskInfo.getBusiObjType());
                taskBo.setProcState(nextTaskInfo.getStepId());
                taskBo.setFinishTag(UecCommonConstant.PROC_TASK_FINISHED.NO_FINISHED);
                taskBo.setFormUrl(nextTaskInfo.getFormUrl());
                taskBo.setProcDefId(nextTaskInfo.getProcDefId());
                taskBo.setProcInstId(nextTaskInfo.getProcInstId());
                taskBo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
                taskBo.setDealResult(UecCommonConstant.AuditStateEnum.APPROVING.value);
                if (taskBo.getTaskSignTag() == null) {
                    taskBo.setTaskSignTag(UecCommonConstant.TASK_SING_TAG.TACHE_TASK);
                }
                saveList.add(taskBo);
                String assignee = nextTaskInfo.getAssignee();
                List candidates = nextTaskInfo.getCandidates();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)assignee)) {
                    UocOrderTaskDealPo deal = new UocOrderTaskDealPo();
                    deal.setId(this.generateIdUtil.nextId());
                    deal.setTaskInstId(nextTaskInfo.getTaskId());
                    deal.setOrderId(reqBO.getOrderId());
                    deal.setObjId(nextTaskInfo.getBusiObjId());
                    deal.setObjType(nextTaskInfo.getBusiObjType());
                    deal.setDealId(assignee);
                    deal.setDealClass("1");
                    saveDealList.add(deal);
                }
                if (CollectionUtils.isEmpty((Collection)candidates)) continue;
                for (UecCandidatesBO candidate : candidates) {
                    UocOrderTaskDealPo deal = new UocOrderTaskDealPo();
                    deal.setId(this.generateIdUtil.nextId());
                    deal.setTaskInstId(nextTaskInfo.getTaskId());
                    deal.setOrderId(reqBO.getOrderId());
                    deal.setObjId(nextTaskInfo.getBusiObjId());
                    deal.setObjType(nextTaskInfo.getBusiObjType());
                    deal.setDealId(candidate.getCandidateId());
                    deal.setDealName(candidate.getCandidateName());
                    deal.setDealClass("2");
                    saveDealList.add(deal);
                }
            }
            if (!CollectionUtils.isEmpty(saveDealList)) {
                this.uocOrderTaskDealMapper.insertBatch(saveDealList);
            }
            this.uocOrderTaskInstMapper.insertBatch(saveList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getPreTaskId())) {
            UocOrderTaskInst = new UocOrderTaskInstPo();
            UocOrderTaskInst.setOrderId(reqBO.getOrderId());
            UocOrderTaskInst.setTaskInstId(reqBO.getPreTaskId());
            UocOrderTaskInst.setFinishTag(UecCommonConstant.PROC_TASK_FINISHED.NO_FINISHED);
            this.deleteProcTaskInst(UocOrderTaskInst);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getReturnTaskId())) {
            UocOrderTaskInst = new UocOrderTaskInstPo();
            UocOrderTaskInst.setOrderId(reqBO.getOrderId());
            UocOrderTaskInst.setTaskInstId(reqBO.getReturnTaskId());
            UocOrderTaskInst.setFinishTag(UecCommonConstant.PROC_TASK_FINISHED.NO_FINISHED);
            this.deleteProcTaskInst(UocOrderTaskInst);
        }
        if (reqBO.getUpdateTaskCandidate() != null && StringUtils.hasText((String)reqBO.getUpdateTaskCandidate().getTaskId())) {
            UecCandidatesBO uecCandidatesBO = (UecCandidatesBO)reqBO.getUpdateTaskCandidate().getCandidates().get(0);
            UocOrderTaskDealPo set = new UocOrderTaskDealPo();
            set.setDealId(uecCandidatesBO.getCandidateId());
            set.setDealName(uecCandidatesBO.getCandidateName());
            UocOrderTaskDealPo where = new UocOrderTaskDealPo();
            where.setTaskInstId(reqBO.getUpdateTaskCandidate().getTaskId());
            this.uocOrderTaskDealMapper.updateBy(set, where);
        }
        UecTaskDealBusiRspBO rspBO = new UecTaskDealBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void deleteProcTaskInst(UocOrderTaskInstPo UocOrderTaskInst) {
        List<UocOrderTaskInstPo> taskInsts = this.uocOrderTaskInstMapper.getList(UocOrderTaskInst);
        if (!CollectionUtils.isEmpty(taskInsts)) {
            List uocOrderTaskInstLogPos = JSON.parseArray((String)JSON.toJSONString(taskInsts), UocOrderTaskInstLogPo.class);
            this.uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
            ArrayList<Long> ids = new ArrayList<Long>();
            taskInsts.forEach(uocOrderTaskInst -> ids.add(uocOrderTaskInst.getId()));
            UocOrderTaskInstPo where = new UocOrderTaskInstPo();
            where.setOrderId(UocOrderTaskInst.getOrderId());
            where.setIds(ids);
            this.uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
            UocOrderTaskDealPo where1 = new UocOrderTaskDealPo();
            ArrayList<String> taskIds = new ArrayList<String>();
            taskInsts.forEach(uocOrderTaskInst -> taskIds.add(uocOrderTaskInst.getTaskInstId()));
            where1.setOrderId(UocOrderTaskInst.getOrderId());
            where1.setTaskInstIds(taskIds);
            this.uocOrderTaskDealMapper.deleteProcTaskInstByIds(where1);
        }
    }

    private void sendTodoDoneCB(UecTaskDealBusiReqBO reqBO, String taskId) {
        UmcQueryToDoListReqBo umcQueryToDoListReqBo = new UmcQueryToDoListReqBo();
        umcQueryToDoListReqBo.setCandidateOperId(Convert.toStr((Object)reqBO.getUserId()));
        umcQueryToDoListReqBo.setTodoItemCode("7020");
        umcQueryToDoListReqBo.setBusiId(taskId);
        UmcQueryToDoListRspBo umcQueryToDoListRspBo = this.umcQueryToDoListService.queryToDoList(umcQueryToDoListReqBo);
        log.info("\u50ac\u529e\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)umcQueryToDoListRspBo));
        if (!CollectionUtils.isEmpty((Collection)umcQueryToDoListRspBo.getRows())) {
            UmcTodoBo umcTodoBo = (UmcTodoBo)umcQueryToDoListRspBo.getRows().get(0);
            UmcSendHaveDoneReqBo umcSendHaveDoneReqBo = new UmcSendHaveDoneReqBo();
            umcSendHaveDoneReqBo.setBusiId(taskId);
            umcSendHaveDoneReqBo.setTodoItemCode(umcTodoBo.getTodoItemCode());
            umcSendHaveDoneReqBo.setOperUserId(Convert.toStr((Object)reqBO.getUserId()));
            umcSendHaveDoneReqBo.setOperUserName(reqBO.getUsername());
            log.info("\u53d1\u9001\u50ac\u529e\u5df2\u529e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneReqBo));
            UmcSendHaveDoneRspBo umcSendHaveDoneRspBo = this.umcSendHaveDoneService.sendHaveDone(umcSendHaveDoneReqBo);
            log.info("\u53d1\u9001\u50ac\u529e\u5df2\u529e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneRspBo));
        }
    }
}

