/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uic.busi.api.UicAutoCreateCarInsuranceOrderBusiService;
import com.tydic.uic.busi.bo.UicAutoCreateCarInsuranceOrderBusiReqBO;
import com.tydic.uic.busi.bo.UicAutoCreateCarInsuranceOrderBusiRspBO;
import com.tydic.uic.busi.bo.UicQueryCarInsuranceRecordsDetailsBusiRspBO;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.dao.UicOrderRelationMapper;
import com.tydic.uic.insurance.ability.bo.UicInsureItemInfoBO;
import com.tydic.uic.po.UicOrderPO;
import com.tydic.uic.po.UicOrderRelationPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UicAutoCreateCarInsuranceOrderBusiServiceImpl
implements UicAutoCreateCarInsuranceOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicAutoCreateCarInsuranceOrderBusiServiceImpl.class);
    @Autowired
    private UicOrderMapper uicOrderMapper;
    @Autowired
    private UicOrderRelationMapper uicOrderRelationMapper;

    @Override
    public UicAutoCreateCarInsuranceOrderBusiRspBO autoCreateCarInsuranceOrder(UicAutoCreateCarInsuranceOrderBusiReqBO reqBO) {
        List<UicQueryCarInsuranceRecordsDetailsBusiRspBO> boList = this.uicOrderMapper.selectToSubmitOrder();
        log.info("\u51fa\u53c2 " + JSON.toJSONString(boList));
        boList.forEach(obj -> {
            UicOrderPO orderPO = new UicOrderPO();
            BeanUtils.copyProperties((Object)obj, (Object)orderPO);
            orderPO.setCreateTime(new Date());
            orderPO.setApproveStatus(4);
            orderPO.setStatus(4);
            orderPO.setOrderId(Sequence.getInstance().nextId());
            orderPO.setOrderNo(Sequence.getInstance().nextId() + "");
            orderPO.setGenerateFlag(1);
            int i = this.uicOrderMapper.insertSelective(orderPO);
            if (1 != i) {
                throw new ZTBusinessException("\u65b0\u589e\u4fdd\u5355\u8868\u4fe1\u606f\u5931\u8d25");
            }
            ArrayList<UicOrderRelationPO> list = new ArrayList<UicOrderRelationPO>();
            for (UicInsureItemInfoBO bo : obj.getInsureItems()) {
                UicOrderRelationPO relationPO = new UicOrderRelationPO();
                relationPO.setId(Sequence.getInstance().nextId());
                relationPO.setOrderId(orderPO.getOrderId());
                relationPO.setInsuranceCode(bo.getInsuranceCode());
                relationPO.setInsuranceName(bo.getInsuranceName());
                relationPO.setSumInsured(bo.getSumInsured());
                relationPO.setAer(bo.getAer());
                relationPO.setInsuranceType(bo.getInsuranceType());
                list.add(relationPO);
            }
            int i1 = this.uicOrderRelationMapper.insertBatch(list);
            if (i1 != list.size()) {
                throw new ZTBusinessException("\u65b0\u589e\u4fdd\u5355\u660e\u7ec6\u8868\u4fe1\u606f\u5931\u8d25");
            }
        });
        UicAutoCreateCarInsuranceOrderBusiRspBO rspBO = new UicAutoCreateCarInsuranceOrderBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6295\u4fdd\u8ba2\u5355\u81ea\u52a8\u751f\u6210\uff08\u5b9a\u65f6\u4efb\u52a1\uff09API\u6210\u529f");
        return rspBO;
    }
}

