/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uic.busi.api.UicGetVehicleNewSyncBusiService;
import com.tydic.uic.busi.bo.UicGetVehicleNewSyncBusiReqBO;
import com.tydic.uic.busi.bo.UicGetVehicleNewSyncBusiRspBO;
import com.tydic.uic.car.ability.bo.UicVehicleNewBO;
import com.tydic.uic.dao.UicAttachmentMapper;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.po.UicAttachmentPO;
import com.tydic.uic.po.UicCarPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UicGetVehicleNewSyncBusiServiceImpl
implements UicGetVehicleNewSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicGetVehicleNewSyncBusiServiceImpl.class);
    @Autowired
    private UicCarMapper uicCarMapper;
    @Autowired
    private UicAttachmentMapper uicAttachmentMapper;

    @Override
    public UicGetVehicleNewSyncBusiRspBO getUicCarInfoList(UicGetVehicleNewSyncBusiReqBO reqBO) {
        UicGetVehicleNewSyncBusiRspBO rspBO = new UicGetVehicleNewSyncBusiRspBO();
        Calendar cal = Calendar.getInstance();
        cal.add(12, -5);
        Date time = cal.getTime();
        UicCarPO po = new UicCarPO();
        log.info("flag " + reqBO.getFlag() + "\u65f6\u95f4: " + time);
        po.setUpdateTime(time);
        po.setFlag(reqBO.getFlag());
        List<UicCarPO> uicCarPOS = this.uicCarMapper.selectBySync(po);
        log.info("po\u51fa\u53c2" + JSON.toJSONString(uicCarPOS));
        ArrayList<UicVehicleNewBO> rows = new ArrayList<UicVehicleNewBO>();
        uicCarPOS.forEach(o -> {
            UicCarPO obj = this.attachMent((UicCarPO)o);
            UicVehicleNewBO bo = new UicVehicleNewBO();
            bo.setPlateId(obj.getCarId() + "");
            bo.setPlateNo(obj.getCarNo());
            bo.setVehicleStatus("2");
            bo.setVehicleKind(obj.getCarCategory() + "");
            bo.setVehicleType(obj.getCarType());
            bo.setOwner(obj.getOwner());
            bo.setAddress(obj.getAddress());
            bo.setUseCharacter(obj.getUseCharacter());
            bo.setModel(obj.getCarModel());
            bo.setVin(obj.getCarIdentifyCode());
            bo.setEngineNo(obj.getEngineNo());
            bo.setRegisterDate(obj.getRegisterDate());
            bo.setIssueDate(obj.getIssueDate());
            bo.setTotalMass(obj.getTotalWeight());
            bo.setCurbWeight(obj.getEquipWeight());
            bo.setRatedLoadMass(obj.getNuclearLoadWeight());
            bo.setTractorMass(obj.getTractWeight());
            bo.setCarAttr(obj.getCarAttr());
            bo.setCarProduce(obj.getCarProduce());
            if (obj.getCarPrice() != null) {
                bo.setVehicleAmount(String.valueOf(obj.getCarPrice()));
            } else {
                bo.setVehicleAmount("0");
            }
            if (obj.getCarCost() != null) {
                bo.setVehicleValue(String.valueOf(obj.getCarCost()));
            } else {
                bo.setVehicleValue("0");
            }
            bo.setSeatType(obj.getSeatType());
            bo.setSeatSum(obj.getSeatNum());
            bo.setDisplacementType(obj.getDisplacementType());
            bo.setLoadMassType(obj.getLoadType());
            bo.setUsedOrgName(obj.getUseOrgName());
            bo.setPolicyPic(obj.getPolicyPic());
            bo.setVehicleInvoicePic(obj.getVehicleInvoicePic());
            bo.setVehicleCertificatePic(obj.getVehicleCertificatePic());
            rows.add(bo);
        });
        rspBO.setRows(rows);
        rspBO.setTotal(rows.size());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8f66\u8f86\u540c\u6b65\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private UicCarPO attachMent(UicCarPO uicCarPO) {
        UicAttachmentPO uicAttachmentPO = new UicAttachmentPO();
        uicAttachmentPO.setRelateType(1);
        uicAttachmentPO.setRelateId(uicCarPO.getCarId());
        List<UicAttachmentPO> uicAttachmentPOS = this.uicAttachmentMapper.selectListAttach(uicAttachmentPO);
        if (!CollectionUtils.isEmpty(uicAttachmentPOS)) {
            uicAttachmentPOS.forEach(p -> {
                if (p.getAttachmentType() != null) {
                    if (p.getAttachmentType() == 1) {
                        uicCarPO.setVehicleCertificatePic(p.getAttachmentUrl());
                    }
                    if (p.getAttachmentType() == 2) {
                        uicCarPO.setVehicleInvoicePic(p.getAttachmentUrl());
                    }
                    if (p.getAttachmentType() == 3) {
                        uicCarPO.setPolicyPic(p.getAttachmentUrl());
                    }
                }
            });
        }
        return uicCarPO;
    }
}

