/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.uic.busi.api.UicInsuranceRecordsSyncBusiService;
import com.tydic.uic.busi.bo.UicInsuranceRecordsSyncBusiReqBO;
import com.tydic.uic.busi.bo.UicInsuranceRecordsSyncBusiRspBO;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.dao.UicOrderRelationMapper;
import com.tydic.uic.po.UicCarPO;
import com.tydic.uic.po.UicOrderPO;
import com.tydic.uic.po.UicOrderRelationPO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UicInsuranceRecordsSyncBusiServiceImpl
implements UicInsuranceRecordsSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicInsuranceRecordsSyncBusiServiceImpl.class);
    @Autowired
    private UicCarMapper uicCarMapper;
    @Autowired
    private UicOrderMapper uicOrderMapper;
    @Autowired
    private UicOrderRelationMapper uicOrderRelationMapper;

    @Override
    public UicInsuranceRecordsSyncBusiRspBO getUicInsuranceRecordsSync(UicInsuranceRecordsSyncBusiReqBO reqBO) {
        int a;
        UicCarPO uicCarPO = new UicCarPO();
        uicCarPO.setCarId(Long.parseLong(reqBO.getMerchVehicleInfoNo()));
        uicCarPO.setTrafficInsExpireTime(reqBO.getCompulsoryTime());
        uicCarPO.setBusiInsExpireTime(reqBO.getCommercialTime());
        int i = this.uicCarMapper.updateByPrimaryKeySelective(uicCarPO);
        if (1 != i) {
            throw new ZTBusinessException("\u66f4\u65b0\u8f66\u8f86\u8868\u4fe1\u606f\u5931\u8d25");
        }
        UicOrderPO uicOrderPO = new UicOrderPO();
        uicOrderPO.setOrderNo(reqBO.getMerchOrderNo());
        uicOrderPO.setStatus(reqBO.getStatus());
        uicOrderPO.setTotalAmount(reqBO.getTotal());
        uicOrderPO.setTrafficInsAmount(reqBO.getCompulsoryAmount());
        uicOrderPO.setBusiInsAmount(reqBO.getCommercialAmount());
        uicOrderPO.setTransportTax(reqBO.getVehicleTaxAmount());
        uicOrderPO.setTrafficInsExpireTime(reqBO.getCompulsoryTime());
        uicOrderPO.setBusiInsExpireTime(reqBO.getCommercialTime());
        uicOrderPO.setGenerateFlag(0);
        if (!StringUtils.isEmpty((String)reqBO.getPdf1()) && !reqBO.getPdf1().contains("null")) {
            uicOrderPO.setPdf1(reqBO.getPdf1());
        }
        if (!StringUtils.isEmpty((String)reqBO.getPdf2()) && !reqBO.getPdf2().contains("null")) {
            uicOrderPO.setPdf2(reqBO.getPdf2());
        }
        if (1 != (a = this.uicOrderMapper.updateByOrderNo(uicOrderPO))) {
            throw new ZTBusinessException("\u66f4\u65b0\u4fdd\u5355\u8868\u8868\u4fe1\u606f\u5931\u8d25");
        }
        Long orderId = this.uicOrderMapper.selectByOrderNo(uicOrderPO);
        log.info("orderId " + JSON.toJSONString((Object)orderId));
        if (!CollectionUtils.isEmpty(reqBO.getCommercialRiskList())) {
            reqBO.getCommercialRiskList().forEach(obj -> {
                UicOrderRelationPO po = new UicOrderRelationPO();
                po.setOrderId(orderId);
                po.setInsuranceCode(obj.getRiskCode());
                po.setPremiums(obj.getPremiums());
                po.setSumInsuredStr(obj.getSumInsuredStr());
                int i1 = this.uicOrderRelationMapper.updateByOrderId(po);
            });
        }
        UicInsuranceRecordsSyncBusiRspBO rspBO = new UicInsuranceRecordsSyncBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8f66\u8f86\u6295\u4fdd\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        return rspBO;
    }
}

