/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.uic.busi.api.UicInsureApproveBusiService;
import com.tydic.uic.busi.bo.UicAddOrderPolicyInfoReqBO;
import com.tydic.uic.busi.bo.UicAddPolicyInfoReqBO;
import com.tydic.uic.busi.bo.UicAddVehicleRiskReqBO;
import com.tydic.uic.busi.bo.UicInsureApproveBusiReqBO;
import com.tydic.uic.busi.bo.UicInsureApproveBusiRspBO;
import com.tydic.uic.busi.bo.UicInvoiceInfoReqBO;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.dao.UicInsuranceMapper;
import com.tydic.uic.dao.UicInvoiceAddressMapper;
import com.tydic.uic.dao.UicInvoiceMapper;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.dao.UicOrderRelationMapper;
import com.tydic.uic.po.EacRuTaskPO;
import com.tydic.uic.po.UicCarPO;
import com.tydic.uic.po.UicInvoiceAddressPO;
import com.tydic.uic.po.UicInvoicePO;
import com.tydic.uic.po.UicOrderPO;
import com.tydic.uic.po.UicOrderRelationPO;
import com.tydic.uic.utils.HttpUtil;
import com.tydic.uic.utils.UicTransFieldUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UicInsureApproveBusiServiceImpl
implements UicInsureApproveBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicInsureApproveBusiServiceImpl.class);
    @Autowired
    private UicOrderMapper uicOrderMapper;
    @Autowired
    private UicInvoiceMapper uicInvoiceMapper;
    @Autowired
    private UicCarMapper uicCarMapper;
    @Autowired
    private UicInvoiceAddressMapper uicInvoiceAddressMapper;
    @Autowired
    private UicOrderRelationMapper uicOrderRelationMapper;
    @Autowired
    private UicInsuranceMapper uicInsuranceMapper;
    @Value(value="${ESB_ACCESS_IP}")
    private String ADDRESS;
    private static final String SERVICE = "/OSN/api/addorderpolicy/v1";
    private static final String CODE_SUCCESS = "0";
    @Value(value="${waibuFlag:true}")
    private Boolean waibuFlag;

    @Override
    public UicInsureApproveBusiRspBO insureApprove(UicInsureApproveBusiReqBO reqBO) {
        UicInsureApproveBusiRspBO rspBO = new UicInsureApproveBusiRspBO();
        EacRuTaskPO taskPO = new EacRuTaskPO();
        taskPO.setBusinessId(reqBO.getOrderId() + "");
        taskPO.setTaskId(Long.parseLong(reqBO.getTaskId()));
        taskPO.setApproveStatus(reqBO.getApproveResult());
        taskPO.setContent(reqBO.getApproveOpinion());
        taskPO.setStatus("1");
        this.uicOrderMapper.updateEacTran(taskPO);
        if (!StringUtils.isEmpty((Object)reqBO.getNextTacheCode())) {
            EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
            eacRuTaskPO.setBusinessId(reqBO.getOrderId() + "");
            eacRuTaskPO.setTacheCode(reqBO.getNextTacheCode());
            this.uicOrderMapper.updateStatusByBusiIdAndTacheCode(eacRuTaskPO);
        }
        Long orderId = reqBO.getOrderId();
        UicOrderPO uicOrderPoRet = this.uicOrderMapper.selectByPrimaryKey(orderId);
        UicCarPO uicCarPO = this.uicCarMapper.selectByPrimaryKey(orderId);
        if (ObjectUtil.isNotEmpty((Object)uicOrderPoRet)) {
            rspBO.setDataType("1");
        } else if (ObjectUtil.isNotEmpty((Object)uicCarPO)) {
            rspBO.setDataType("2");
        }
        if (reqBO.getIsfinish().booleanValue()) {
            if (ObjectUtil.isNotEmpty((Object)uicOrderPoRet)) {
                log.info("\u8f66\u8f86\u5ba1\u6279-\u4fdd\u5355\u5ba1\u6279\uff1a{}", (Object)orderId);
                this.uicOrderMapper.updateFilter(orderId);
                UicOrderPO uicOrderPO = new UicOrderPO();
                uicOrderPO.setOrderId(orderId);
                uicOrderPO.setApproveStatus(reqBO.getApproveResult() == 0 ? 2 : 3);
                if (reqBO.getApproveResult() == 1) {
                    uicOrderPO.setStatus(5);
                }
                this.uicOrderMapper.updateByPrimaryKeySelective(uicOrderPO);
                if (reqBO.getApproveResult() == 0) {
                    this.newOrderInsurance(reqBO);
                }
            } else if (ObjectUtil.isNotEmpty((Object)uicCarPO)) {
                log.info("\u8f66\u8f86\u5ba1\u6279-\u8f66\u8f86\u7ba1\u7406\u5ba1\u6279\uff1a{}", (Object)orderId);
                UicCarPO updateCarPo = new UicCarPO();
                updateCarPo.setCarId(orderId);
                updateCarPo.setCarApproveStatus(reqBO.getApproveResult() == 0 ? 2 : 3);
                this.uicCarMapper.updateByPrimaryKeySelective(updateCarPo);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6295\u4fdd\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void newOrderInsurance(UicInsureApproveBusiReqBO reqBO) {
        UicOrderPO uicOrderPO = this.uicOrderMapper.selectByPrimaryKey(reqBO.getOrderId());
        log.info("\u8f66\u8f86id{},\u8f66\u67b6\u53f7{}", (Object)uicOrderPO.getCarId(), (Object)uicOrderPO.getInsureOrgIdOld());
        List<UicOrderRelationPO> uicOrderRelationPOS = this.uicOrderRelationMapper.selectByList(reqBO.getOrderId());
        UicInvoicePO uicInvoicePO = this.uicInvoiceMapper.selectByPrimaryKey(reqBO.getOrderId());
        UicInvoiceAddressPO uicInvoiceAddressPO = this.uicInvoiceAddressMapper.selectByPrimaryKey(reqBO.getOrderId());
        UicAddOrderPolicyInfoReqBO infoReqBO = new UicAddOrderPolicyInfoReqBO();
        infoReqBO.setMerchOrderNo(uicOrderPO.getOrderNo());
        infoReqBO.setPlateNo(uicOrderPO.getCarNo());
        infoReqBO.setMerchVehicleInfoNo(uicOrderPO.getCarId() + "");
        infoReqBO.setInsuranceCompany(this.uicInsuranceMapper.selectByCompany());
        infoReqBO.setOrderStatus(1);
        UicInvoiceInfoReqBO infoReqBO1 = new UicInvoiceInfoReqBO();
        int invoiceTypeOut = UicTransFieldUtil.tranUicInvoiceTypeOut(uicInvoicePO.getInvoiceType());
        infoReqBO1.setInvoiceType(invoiceTypeOut);
        infoReqBO1.setTin(uicInvoicePO.getTaxpayerId());
        infoReqBO1.setCompanyName(uicOrderPO.getInsureOrgName());
        infoReqBO1.setRegisterAddress(uicInvoicePO.getAddress());
        infoReqBO1.setRegisterPhone(uicInvoicePO.getPhone());
        infoReqBO1.setDepositBank(uicInvoicePO.getBank());
        infoReqBO1.setBankAccount(uicInvoicePO.getAccount());
        infoReqBO1.setReceiverName(uicInvoiceAddressPO.getName());
        infoReqBO1.setReceiverPhone(uicInvoiceAddressPO.getTel());
        String address = uicInvoiceAddressPO.getProvinceName() + uicInvoiceAddressPO.getCityName() + uicInvoiceAddressPO.getCountyName() + uicInvoiceAddressPO.getTownName() + uicInvoiceAddressPO.getAddrDesc();
        infoReqBO1.setReceiverAddress(address);
        infoReqBO.setInvoiceInfo(infoReqBO1);
        ArrayList<UicAddPolicyInfoReqBO> intgPolicyInfoList = new ArrayList<UicAddPolicyInfoReqBO>();
        ArrayList<UicAddVehicleRiskReqBO> boList1 = new ArrayList<UicAddVehicleRiskReqBO>();
        ArrayList<UicAddVehicleRiskReqBO> boList2 = new ArrayList<UicAddVehicleRiskReqBO>();
        uicOrderRelationPOS.forEach(obj -> {
            UicAddVehicleRiskReqBO riskBO = new UicAddVehicleRiskReqBO();
            riskBO.setPlateNo(uicOrderPO.getCarNo());
            riskBO.setRiskCode(obj.getInsuranceCode());
            riskBO.setRiskName(obj.getInsuranceName());
            String sumInsured = obj.getSumInsured();
            if (sumInsured.contains("\u4e07")) {
                riskBO.setSumInsured(sumInsured.substring(0, sumInsured.lastIndexOf("\u4e07")) + "0000");
            } else {
                riskBO.setSumInsured(sumInsured);
            }
            riskBO.setAerDesc(obj.getAer() == 1 ? "\u662f" : "\u5426");
            if (obj.getInsuranceType() == 1 && !"1".equals(obj.getSumInsured())) {
                boList1.add(riskBO);
            }
            if (obj.getInsuranceType() == 2 && !"1".equals(obj.getSumInsured())) {
                boList2.add(riskBO);
            }
        });
        if (!CollectionUtils.isEmpty(boList2)) {
            UicAddPolicyInfoReqBO bo1 = new UicAddPolicyInfoReqBO();
            bo1.setPlateNo(uicOrderPO.getCarNo());
            bo1.setPolicyType(1);
            bo1.setVehicleRiskList(boList2);
            bo1.setPolicyStatus(1);
            intgPolicyInfoList.add(bo1);
        }
        if (!CollectionUtils.isEmpty(boList1)) {
            UicAddPolicyInfoReqBO bo2 = new UicAddPolicyInfoReqBO();
            bo2.setPlateNo(uicOrderPO.getCarNo());
            bo2.setPolicyType(2);
            bo2.setVehicleRiskList(boList1);
            bo2.setPolicyStatus(1);
            intgPolicyInfoList.add(bo2);
        }
        infoReqBO.setIntgPolicyInfoList(intgPolicyInfoList);
        String s = "";
        try {
            log.info("\u8bf7\u6c42\u5730\u5740: " + this.ADDRESS + SERVICE);
            log.info("\u8bf7\u6c42\u53c2\u6570: " + JSON.toJSONString((Object)infoReqBO));
            if (this.waibuFlag.booleanValue()) {
                s = HttpUtil.doPost(this.ADDRESS + SERVICE, JSON.toJSONString((Object)infoReqBO));
                log.info("\u8bf7\u6c42\u51fa\u53c2\uff1a" + s);
                UicOrderPO poLog = new UicOrderPO();
                poLog.setOrderId(uicOrderPO.getOrderId());
                poLog.setParamReq(JSON.toJSONString((Object)infoReqBO));
                poLog.setParamRsq(s);
                poLog.setCreateTime(new Date());
                this.uicOrderMapper.saveLog(poLog);
            }
        }
        catch (Exception e) {
            UicOrderPO poLog = new UicOrderPO();
            poLog.setOrderId(uicOrderPO.getOrderId());
            poLog.setParamReq(JSON.toJSONString((Object)infoReqBO));
            poLog.setParamRsq(s);
            poLog.setCreateTime(new Date());
            this.uicOrderMapper.saveLog(poLog);
            e.printStackTrace();
            log.error("\u4fdd\u9669\u5355\u63a8\u9001\u5931\u8d25 {}", (Object)e.getMessage());
        }
    }
}

