/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.tydic.uic.busi.api.UicQueryCarDetailsBusiService;
import com.tydic.uic.busi.bo.UicQueryCarDetailsBusiReqBO;
import com.tydic.uic.busi.bo.UicQueryCarDetailsBusiRspBO;
import com.tydic.uic.car.ability.bo.UicAttachmentBO;
import com.tydic.uic.dao.UicAttachmentMapper;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.dao.UicOrderRelationMapper;
import com.tydic.uic.po.EacRuTaskPO;
import com.tydic.uic.po.UicAttachmentPO;
import com.tydic.uic.po.UicCarPO;
import com.tydic.uic.po.UicOrderRelationPO;
import com.tydic.uic.utils.UicTransFieldUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UicQueryCarDetailsBusiServiceImpl
implements UicQueryCarDetailsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicQueryCarDetailsBusiServiceImpl.class);
    @Autowired
    private UicCarMapper uicCarMapper;
    @Autowired
    private UicAttachmentMapper uicAttachmentMapper;
    @Autowired
    private UicOrderRelationMapper uicOrderRelationMapper;
    @Autowired
    private UicOrderMapper uicOrderMapper;

    @Override
    public UicQueryCarDetailsBusiRspBO queryCarDetails(UicQueryCarDetailsBusiReqBO reqBO) {
        List<EacRuTaskPO> taskPOList;
        UicQueryCarDetailsBusiRspBO rspBO = new UicQueryCarDetailsBusiRspBO();
        UicCarPO uicCarPO = this.uicCarMapper.selectByPrimaryKey(reqBO.getCarId());
        if (null == uicCarPO) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8f66\u8f86\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)uicCarPO, (Object)((Object)rspBO));
        log.info("rspBO " + JSON.toJSONString((Object)((Object)rspBO)));
        if (uicCarPO.getOrderId() == null) {
            rspBO.setPolicyStatus(1);
            rspBO.setCommercialStatus(1);
        } else {
            rspBO = this.statusCheck(rspBO);
        }
        log.info("\u4ea4\u5f3a\u9669\u72b6\u6001" + rspBO.getPolicyStatus());
        log.info("\u5546\u4e1a\u9669\u72b6\u6001" + rspBO.getCommercialStatus());
        rspBO.setPolicyStatusStr(UicTransFieldUtil.tranUicOrderStatus(rspBO.getPolicyStatus()));
        rspBO.setCommercialStatusStr(UicTransFieldUtil.tranUicOrderStatus(rspBO.getCommercialStatus()));
        UicAttachmentPO uicAttachmentPO = new UicAttachmentPO();
        uicAttachmentPO.setRelateType(1);
        uicAttachmentPO.setRelateId(reqBO.getCarId());
        List<UicAttachmentPO> uicAttachmentPOS = this.uicAttachmentMapper.selectListAttach(uicAttachmentPO);
        if (!CollectionUtils.isEmpty(uicAttachmentPOS)) {
            String s = JSON.toJSONString(uicAttachmentPOS);
            List uicCarInfoBOS = JSONArray.parseArray((String)s).toJavaList(UicAttachmentBO.class);
            rspBO.setAttachmentInfos(uicCarInfoBOS);
        }
        if (!CollectionUtils.isEmpty(taskPOList = this.uicOrderMapper.selectTask(reqBO.getCarId()))) {
            rspBO.setTaskId(taskPOList.get(0).getTaskId());
            rspBO.setProcInstId(taskPOList.get(0).getProcInstId());
            rspBO.setTacheCode(taskPOList.get(0).getTacheCode());
            List<Long> taskIdList = taskPOList.stream().map(EacRuTaskPO::getTaskId).collect(Collectors.toList());
            rspBO.setTaskIdList(taskIdList);
        }
        if (StringUtils.isEmpty((Object)rspBO.getProcInstId())) {
            rspBO.setProcInstId(this.uicOrderMapper.selectProcInstId(reqBO.getCarId()));
        }
        this.trans(rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8f66\u8f86\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private void trans(UicQueryCarDetailsBusiRspBO rspBO) {
        rspBO.setCarCategoryStr(UicTransFieldUtil.transDict("car_category", rspBO.getCarCategory() == null ? "" : rspBO.getCarCategory().toString()));
        rspBO.setCarProduceStr(UicTransFieldUtil.transDict("car_produce", rspBO.getCarProduce() == null ? "" : rspBO.getCarProduce().toString()));
        rspBO.setSeatTypeStr(UicTransFieldUtil.transDict("car_seat_type", rspBO.getSeatType() == null ? "" : rspBO.getSeatType().toString()));
        rspBO.setCarAttrStr(UicTransFieldUtil.transDict("car_attr", rspBO.getCarAttr() == null ? "" : rspBO.getCarAttr().toString()));
        rspBO.setDisplacementTypeStr(UicTransFieldUtil.transDict("car_displacement_type", rspBO.getDisplacementType() == null ? "" : rspBO.getDisplacementType().toString()));
        rspBO.setLoadTypeStr(UicTransFieldUtil.transDict("car_seat_type", rspBO.getLoadType() == null ? "" : rspBO.getLoadType().toString()));
        rspBO.setStatusStr(UicTransFieldUtil.transDict("car_status", rspBO.getStatus() == null ? "" : rspBO.getStatus().toString()));
    }

    private UicQueryCarDetailsBusiRspBO statusCheck(UicQueryCarDetailsBusiRspBO rspBO) {
        if (rspBO.getTrafficInsExpireTime() != null) {
            rspBO.setPolicyStatus(2);
        } else if (rspBO.getTrafficInsExpireTime() == null && rspBO.getApproveStatus() == 2) {
            rspBO.setPolicyStatus(2);
        } else {
            rspBO.setPolicyStatus(1);
        }
        if (rspBO.getBusiInsExpireTime() != null) {
            rspBO.setCommercialStatus(2);
        } else if (rspBO.getBusiInsExpireTime() == null && rspBO.getApproveStatus() == 2) {
            List<UicOrderRelationPO> uicOrderRelationPOS = this.uicOrderRelationMapper.selectByList1(rspBO.getOrderId());
            List list = uicOrderRelationPOS.stream().map(UicOrderRelationPO::getSumInsured).collect(Collectors.toList());
            log.info("\u5546\u4e1a\u9669\u72b6\u60010" + JSON.toJSONString(list));
            for (String s : list) {
                if ("1".equals(s)) continue;
                log.info("\u5546\u4e1a\u96691" + s);
                rspBO.setCommercialStatus(2);
                return rspBO;
            }
            log.info("\u5546\u4e1a\u9669\u72b6\u60012");
            rspBO.setCommercialStatus(1);
        } else {
            rspBO.setCommercialStatus(1);
        }
        log.info("\u5546\u4e1a\u9669\u72b6\u60013");
        return rspBO;
    }
}

