/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleDetailedBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSyncBO;
import com.tydic.cfc.busi.api.CfcDictionaryBusiService;
import com.tydic.cfc.busi.api.CfcEncodedRuleUpdateBusiService;
import com.tydic.cfc.busi.bo.CfcEncodedRuleUpdateBusiReqBO;
import com.tydic.cfc.busi.bo.CfcEncodedRuleUpdateBusiRspBO;
import com.tydic.cfc.constants.CfcCommConstant;
import com.tydic.cfc.dao.CfcEncodedRuleDetailedMapper;
import com.tydic.cfc.dao.CfcEncodedRuleMapper;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.cfc.po.CfcEncodedRuleDetailedPO;
import com.tydic.cfc.po.CfcEncodedRulePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="cfcEncodedRuleUpdateBusiService")
public class CfcEncodedRuleUpdateBusiServiceImpl
implements CfcEncodedRuleUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedRuleUpdateBusiServiceImpl.class);
    @Autowired
    private CfcEncodedRuleMapper cfcEncodedRuleMapper;
    @Autowired
    private CfcEncodedRuleDetailedMapper cfcEncodedRuleDetailedMapper;
    @Autowired
    private CfcDictionaryBusiService dictionaryAbilityService;
    private static final String CHANGE_ENCODED = "change_encoded";

    @Override
    @Transactional
    public CfcEncodedRuleUpdateBusiRspBO updateEncodedRule(CfcEncodedRuleUpdateBusiReqBO reqBO) {
        CfcEncodedRulePO cfcEncodedRulePO = new CfcEncodedRulePO();
        Map<String, String> replaceType = this.dictionaryAbilityService.queryBypCodeBackMap("ENCODED_RULE_DETAILED_REPLACE_TYPE");
        Map<String, String> busiTypeMap = this.dictionaryAbilityService.queryBypCodeBackMap("ENCODED_RULE_BUSI_TYPE");
        cfcEncodedRulePO.setId(reqBO.getId());
        cfcEncodedRulePO.setOperateName(reqBO.getName());
        cfcEncodedRulePO.setOperateNo(reqBO.getMemIdIn());
        cfcEncodedRulePO.setOperateTime(new Date());
        String encodedRuleStyle = "";
        ArrayList<CfcEncodedRuleDetailedPO> cfcEncodedRuleDetailedPOS = new ArrayList<CfcEncodedRuleDetailedPO>();
        DateTime nowTime = DateTime.now();
        Integer encodeEffCode = CfcCommConstant.EncodeEffFlag.NONE.getCode();
        if (reqBO.getDetaileds() != null && reqBO.getDetaileds().size() > 0) {
            int orderId = 1;
            for (CfcEncodedRuleDetailedBO itemBO : reqBO.getDetaileds()) {
                CfcEncodedRuleDetailedPO cfcEncodedRuleDetailedPO = new CfcEncodedRuleDetailedPO();
                itemBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                itemBO.setEncodedRuleId(cfcEncodedRulePO.getId());
                itemBO.setOrderId(Integer.valueOf(orderId));
                ++orderId;
                if ("text".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedContent();
                } else if ("year".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("yyyy");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.YEAR.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.YEAR.getCode();
                } else if ("month".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("MM");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.MONTH.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.MONTH.getCode();
                } else if ("day".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("dd");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.DAY.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.DAY.getCode();
                } else if ("date".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + nowTime.toString("yyyyMMdd");
                    encodeEffCode = encodeEffCode > CfcCommConstant.EncodeEffFlag.DATE.getCode() ? encodeEffCode : CfcCommConstant.EncodeEffFlag.DATE.getCode();
                } else if ("replace".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedStyle();
                } else if ("serial".equals(itemBO.getDetailedType())) {
                    int serial;
                    if (StringUtils.isEmpty((Object)itemBO.getDetailedContent())) {
                        itemBO.setDetailedContent("4");
                    }
                    if ((serial = Integer.parseInt(itemBO.getDetailedContent())) > 0) {
                        for (int i = 1; i < serial; ++i) {
                            encodedRuleStyle = encodedRuleStyle + "0";
                        }
                        encodedRuleStyle = encodedRuleStyle + "1";
                    }
                } else if ("busiType".equals(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + busiTypeMap.get(itemBO.getDetailedContent());
                    itemBO.setDetailedContent(busiTypeMap.get(itemBO.getDetailedType()));
                } else if ("orgCode".equals(itemBO.getDetailedType())) {
                    String orgCodeStr = itemBO.getDetailedContent();
                    if (StringUtils.isEmpty((Object)itemBO.getDetailedContent())) {
                        CfcEncodedRuleBO cfcBO = new CfcEncodedRuleBO();
                        cfcBO.setCenter(reqBO.getCenter());
                        cfcBO.setEncodedRuleCode(reqBO.getEncodedRuleCode());
                        cfcBO.setEncodedRuleType("1");
                        List<CfcEncodedRulePO> cfcEncodedRulePOS = this.cfcEncodedRuleMapper.getList(cfcBO);
                        if (!CollectionUtils.isEmpty(cfcEncodedRulePOS)) {
                            CfcEncodedRulePO mainPO = cfcEncodedRulePOS.get(0);
                            orgCodeStr = mainPO.getRelCode();
                        }
                    }
                    encodedRuleStyle = encodedRuleStyle + orgCodeStr;
                    itemBO.setDetailedContent(orgCodeStr);
                    itemBO.setDetailedStyle(orgCodeStr);
                } else if (replaceType.containsKey(itemBO.getDetailedType())) {
                    encodedRuleStyle = encodedRuleStyle + itemBO.getDetailedContent();
                    itemBO.setDetailedStyle(itemBO.getDetailedContent());
                }
                BeanUtils.copyProperties((Object)itemBO, (Object)cfcEncodedRuleDetailedPO);
                cfcEncodedRuleDetailedPOS.add(cfcEncodedRuleDetailedPO);
            }
        }
        cfcEncodedRulePO.setEffType(CfcCommConstant.EncodeEffFlag.getValueByCode((Integer)encodeEffCode));
        if (!StringUtils.isEmpty((Object)reqBO.getEncodedRuleStyle())) {
            cfcEncodedRulePO.setEncodedRuleStyle(reqBO.getEncodedRuleStyle());
        } else {
            cfcEncodedRulePO.setEncodedRuleStyle(encodedRuleStyle);
        }
        int update = this.cfcEncodedRuleMapper.updateByPrimaryKeySelective(cfcEncodedRulePO);
        if (update < 1) {
            throw new CfcBusinessException("223013", "\u7f16\u7801\u89c4\u5219\u4fee\u6539\u5931\u8d25");
        }
        if (cfcEncodedRuleDetailedPOS.size() > 0) {
            this.cfcEncodedRuleDetailedMapper.deleteByEncodedRuleId(reqBO.getId());
            update = this.cfcEncodedRuleDetailedMapper.insertBatch(cfcEncodedRuleDetailedPOS);
            if (update < 1) {
                throw new CfcBusinessException("223013", "\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u4fee\u6539\u5931\u8d25");
            }
        }
        cfcEncodedRulePO = this.cfcEncodedRuleMapper.selectByPrimaryKey(cfcEncodedRulePO.getId());
        CfcEncodedRuleBO cfcEncodedRuleBO = new CfcEncodedRuleBO();
        BeanUtils.copyProperties((Object)cfcEncodedRulePO, (Object)cfcEncodedRuleBO);
        cfcEncodedRuleBO.setRestartFlag(reqBO.getRestartFlag());
        CfcEncodedRuleSyncBO syncBO = new CfcEncodedRuleSyncBO();
        syncBO.setId(cfcEncodedRuleBO.getId());
        syncBO.setRestartFlag(cfcEncodedRuleBO.getRestartFlag());
        ArrayList<CfcEncodedRuleSyncBO> syncBOS = new ArrayList<CfcEncodedRuleSyncBO>();
        syncBOS.add(syncBO);
        CfcEncodedRuleUpdateBusiRspBO rspBO = new CfcEncodedRuleUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setSyncBOLIst(syncBOS);
        return rspBO;
    }
}

