/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoListService"})
public class UmcQryOrgInfoListServiceImpl
implements UmcQryOrgInfoListService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    public static final Integer NO_BLACK_LIST_FLAG = 1;

    @PostMapping(value={"qryOrgList"})
    public UmcQryOrgInfoListRspBo qryOrgList(@RequestBody UmcQryOrgInfoListReqBo reqBo) {
        this.var(reqBo);
        UmcQryOrgInfoListRspBo success = UmcRu.success(UmcQryOrgInfoListRspBo.class);
        UmcEnterpriseOrgQryBo enterpriseOrgQryBo = new UmcEnterpriseOrgQryBo();
        enterpriseOrgQryBo.setTagId(reqBo.getTagId());
        enterpriseOrgQryBo.setOrgClass(reqBo.getOrgClass());
        enterpriseOrgQryBo.setIsMerchant(reqBo.getIsMerchant());
        enterpriseOrgQryBo.setOrgClassList(reqBo.getOrgClassList());
        enterpriseOrgQryBo.setOrgName(reqBo.getOrgName());
        enterpriseOrgQryBo.setPageNo(reqBo.getPageNo());
        enterpriseOrgQryBo.setPageSize(reqBo.getPageSize());
        enterpriseOrgQryBo.setSignStatus(reqBo.getSignStatus());
        enterpriseOrgQryBo.setIsVirtual(reqBo.getIsVirtual());
        UmcEnterpriseOrgQryRspBo enterpriseInfoDoList = NO_BLACK_LIST_FLAG.equals(reqBo.getQryNoBlackListFlag()) ? this.iUmcEnterpriseInfoModel.qryNoBlackListEnterprise(enterpriseOrgQryBo) : (null != reqBo.getSignStatus() ? this.iUmcEnterpriseInfoModel.getSignSupList(StrUtil.noNullStringAttr(enterpriseOrgQryBo)) : this.iUmcEnterpriseInfoModel.getOrgTagList(StrUtil.noNullStringAttr(enterpriseOrgQryBo)));
        success.setPageNo(Integer.valueOf(enterpriseInfoDoList.getPageNo()));
        success.setTotal(Integer.valueOf(enterpriseInfoDoList.getTotal()));
        success.setRecordsTotal(Integer.valueOf(enterpriseInfoDoList.getRecordsTotal()));
        List<UmcEnterpriseInfoBo> umcEnterpriseInfoBos = UmcRu.jsl(enterpriseInfoDoList.getRows(), UmcEnterpriseInfoBo.class);
        if (!CollectionUtils.isEmpty(umcEnterpriseInfoBos)) {
            umcEnterpriseInfoBos.forEach(e -> {
                if (StringUtils.isBlank((CharSequence)e.getOrgFullName())) {
                    e.setOrgNameFull(e.getOrgName());
                } else {
                    e.setOrgNameFull(e.getOrgFullName());
                }
            });
        }
        success.setRows(umcEnterpriseInfoBos);
        return success;
    }

    private void var(UmcQryOrgInfoListReqBo reqBo) {
        if (null == reqBo.getTagId()) {
            throw new BaseBusinessException("163000", "tagId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

