/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.api.BkUmcOrgModel;
import com.tydic.dyc.umc.model.extension.api.BkUmcProjectDistributeConfigModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchAddProjectModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryOrgInfoModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcOrgSummaryInfoDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectAuthorityInfoDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectDistributeConfigDo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectDistributeConfigListRspBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectDistributeConfigQryBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.extension.api.BkUmcProjectDistributeConfigService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddProjectAuthorityReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddProjectAuthorityRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddProjectReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddProjectRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchConfigProjectDistributeReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchConfigProjectDistributeRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchUpdateProjectAuthorityReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchUpdateProjectAuthorityRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchUpdateProjectReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchUpdateProjectRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcConfigProjectDistributeReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcConfigProjectDistributeRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcProjectDistributeConfigInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcProjectInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcProjectStatusDescInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAllProjectDistributeConfigReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAllProjectDistributeConfigRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectAuthorityReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectAuthorityRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectDistributeConfigDetailsReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectDistributeConfigDetailsRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectDistributeConfigReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectDistributeConfigRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectStatusDescDropDownListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryProjectStatusDescDropDownListRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcProjectDistributeConfigService"})
public class BkUmcProjectDistributeConfigServiceImpl
implements BkUmcProjectDistributeConfigService {
    private static final Logger log = LoggerFactory.getLogger(BkUmcProjectDistributeConfigServiceImpl.class);
    @Autowired
    private BkUmcProjectDistributeConfigModel bkUmcProjectDistributeConfigModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private BkUmcOrgModel bkUmcOrgModel;

    @PostMapping(value={"queryProjectDistributeConfigList"})
    public BkUmcQueryProjectDistributeConfigRspBO queryProjectDistributeConfigList(@RequestBody BkUmcQueryProjectDistributeConfigReqBO reqBO) {
        BkUmcQueryProjectDistributeConfigRspBO rspBO = new BkUmcQueryProjectDistributeConfigRspBO();
        BkUmcProjectDistributeConfigQryBo qryBo = new BkUmcProjectDistributeConfigQryBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)qryBo));
        BkUmcProjectDistributeConfigListRspBO ProjectDistributeConfigList = this.bkUmcProjectDistributeConfigModel.queryProjectDistributeConfigList(qryBo);
        if (CollectionUtils.isEmpty((Collection)ProjectDistributeConfigList.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = UmcRu.js((Object)ProjectDistributeConfigList, BkUmcQueryProjectDistributeConfigRspBO.class);
        Map<String, String> belongStageMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "BELONG_STAGE")).getMap();
        Map<String, String> configSystemMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "CONFIG_SYSTEM")).getMap();
        for (BkUmcProjectDistributeConfigInfoBO resultBO : rspBO.getRows()) {
            if (ObjectUtil.isNotEmpty((Object)resultBO.getBelongStage()) && belongStageMap != null && belongStageMap.containsKey(resultBO.getBelongStage().toString())) {
                resultBO.setBelongStageStr(belongStageMap.get(resultBO.getBelongStage().toString()));
            }
            if (!ObjectUtil.isNotEmpty((Object)resultBO.getConfigSystem()) || configSystemMap == null || !configSystemMap.containsKey(resultBO.getConfigSystem().toString())) continue;
            resultBO.setConfigSystemStr(configSystemMap.get(resultBO.getConfigSystem().toString()));
        }
        return rspBO;
    }

    @PostMapping(value={"configProjectDistribute"})
    public BkUmcConfigProjectDistributeRspBO configProjectDistribute(@RequestBody BkUmcConfigProjectDistributeReqBO reqBO) {
        this.validConfigProjectDistributeData(reqBO);
        BkUmcConfigProjectDistributeRspBO rspBO = UmcRu.success(BkUmcConfigProjectDistributeRspBO.class);
        BkUmcProjectDistributeConfigDo modelReqBO = UmcRu.js(reqBO, BkUmcProjectDistributeConfigDo.class);
        modelReqBO.setUpdateUserId(reqBO.getUserIdIn().toString());
        modelReqBO.setUpdateUserName(reqBO.getUsername());
        modelReqBO.setUpdateTime(new Date());
        this.bkUmcProjectDistributeConfigModel.configProjectDistribute(modelReqBO);
        return rspBO;
    }

    @PostMapping(value={"batchConfigProjectDistribute"})
    public BkUmcBatchConfigProjectDistributeRspBO batchConfigProjectDistribute(@RequestBody BkUmcBatchConfigProjectDistributeReqBO reqBO) {
        this.validBatchConfigProjectDistributeData(reqBO);
        BkUmcBatchConfigProjectDistributeRspBO rspBO = UmcRu.success(BkUmcBatchConfigProjectDistributeRspBO.class);
        BkUmcProjectDistributeConfigDo modelReqBO = UmcRu.js(reqBO, BkUmcProjectDistributeConfigDo.class);
        modelReqBO.setUpdateUserId(reqBO.getUserId().toString());
        modelReqBO.setUpdateUserName(reqBO.getName());
        modelReqBO.setUpdateTime(new Date());
        this.bkUmcProjectDistributeConfigModel.batchConfigProjectDistribute(modelReqBO);
        return rspBO;
    }

    @PostMapping(value={"batchAddProject"})
    public BkUmcBatchAddProjectRspBO batchAddProject(@RequestBody BkUmcBatchAddProjectReqBO reqBO) {
        BkUmcBatchAddProjectRspBO rspBO = UmcRu.success(BkUmcBatchAddProjectRspBO.class);
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProjectInfos())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<BkUmcProjectDistributeConfigDo> bkUmcProjectDistributeConfigDos = new ArrayList<BkUmcProjectDistributeConfigDo>();
        for (BkUmcProjectInfoBO projectInfo : reqBO.getProjectInfos()) {
            if (ObjectUtil.isEmpty((Object)projectInfo.getProjectCode())) {
                log.info("\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectCode]\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)projectInfo));
                continue;
            }
            if (ObjectUtil.isEmpty((Object)projectInfo.getProjectName())) {
                log.info("\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectName]\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)projectInfo));
                continue;
            }
            BkUmcProjectDistributeConfigDo js = UmcRu.js(projectInfo, BkUmcProjectDistributeConfigDo.class);
            bkUmcProjectDistributeConfigDos.add(js);
        }
        if (!CollectionUtils.isEmpty(bkUmcProjectDistributeConfigDos)) {
            BkUmcBatchAddProjectModelReqBO bkUmcBatchAddProjectModelReqBO = new BkUmcBatchAddProjectModelReqBO();
            bkUmcBatchAddProjectModelReqBO.setProjectInfos(bkUmcProjectDistributeConfigDos);
            this.bkUmcProjectDistributeConfigModel.batchAddProject(bkUmcBatchAddProjectModelReqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"queryProjectDistributeConfigDetails"})
    public BkUmcQueryProjectDistributeConfigDetailsRspBO queryProjectDistributeConfigDetails(@RequestBody BkUmcQueryProjectDistributeConfigDetailsReqBO reqBO) {
        this.validQueryProjectDistributeConfigDetailsData(reqBO);
        BkUmcQueryProjectDistributeConfigDetailsRspBO rspBO = new BkUmcQueryProjectDistributeConfigDetailsRspBO();
        BkUmcProjectDistributeConfigQryBo qryBo = new BkUmcProjectDistributeConfigQryBo();
        qryBo.setProjectCode(reqBO.getProjectCode());
        BkUmcProjectDistributeConfigDo result = this.bkUmcProjectDistributeConfigModel.queryProjectDistributeConfigDetails(qryBo);
        if (ObjectUtil.isEmpty((Object)result)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = UmcRu.js(result, BkUmcQueryProjectDistributeConfigDetailsRspBO.class);
        BeanUtils.copyProperties((Object)result, (Object)rspBO);
        if (!StringUtils.isEmpty((Object)rspBO.getConfigSystem())) {
            Map<String, String> belongStageMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "BELONG_STAGE")).getMap();
            Map<String, String> configSystemMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "CONFIG_SYSTEM")).getMap();
            if (configSystemMap != null && configSystemMap.containsKey(rspBO.getConfigSystem().toString())) {
                rspBO.setConfigSystemStr(configSystemMap.get(rspBO.getConfigSystem().toString()));
            }
            if (belongStageMap != null && belongStageMap.containsKey(rspBO.getBelongStage().toString())) {
                rspBO.setBelongStageStr(belongStageMap.get(rspBO.getBelongStage().toString()));
            }
        }
        return rspBO;
    }

    /*
     * Enabled aggressive block sorting
     */
    @PostMapping(value={"batchUpdateProject"})
    public BkUmcBatchUpdateProjectRspBO batchUpdateProject(@RequestBody BkUmcBatchUpdateProjectReqBO reqBO) {
        BkUmcBatchUpdateProjectRspBO rspBO = UmcRu.success(BkUmcBatchUpdateProjectRspBO.class);
        List<BkUmcProjectDistributeConfigDo> modelReqBOs = UmcRu.jsl(reqBO.getProjectInfos(), BkUmcProjectDistributeConfigDo.class);
        List companyNames = modelReqBOs.stream().filter(bo -> StringUtils.isEmpty((Object)bo.getProjectCompanyName())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(companyNames)) {
            BkUmcBatchQueryOrgInfoModelReqBO bkUmcBatchQueryOrgInfoModelReqBO = new BkUmcBatchQueryOrgInfoModelReqBO();
            List<String> orgCodes = companyNames.stream().map(BkUmcProjectDistributeConfigDo::getProjectCompanyId).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(orgCodes)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            bkUmcBatchQueryOrgInfoModelReqBO.setExtOrgCodes(orgCodes);
            List<BkUmcOrgSummaryInfoDO> bkUmcOrgSummaryInfoDOS = this.bkUmcOrgModel.batchQueryOrgInfo(bkUmcBatchQueryOrgInfoModelReqBO);
            if (!CollectionUtil.isNotEmpty(bkUmcOrgSummaryInfoDOS)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u540d\u79f0\u6570\u636e");
                return rspBO;
            }
            for (BkUmcProjectDistributeConfigDo modelReqBO : modelReqBOs) {
                for (BkUmcOrgSummaryInfoDO bkUmcOrgSummaryInfoDO : bkUmcOrgSummaryInfoDOS) {
                    if (!modelReqBO.getProjectCompanyId().equals(bkUmcOrgSummaryInfoDO.getExtOrgCode())) continue;
                    modelReqBO.setProjectCompanyName(bkUmcOrgSummaryInfoDO.getCompanyName());
                }
            }
        }
        this.bkUmcProjectDistributeConfigModel.batchUpdateProject(modelReqBOs);
        return rspBO;
    }

    @PostMapping(value={"queryAllProjectDistributeConfig"})
    public BkUmcQueryAllProjectDistributeConfigRspBO queryAllProjectDistributeConfig(@RequestBody BkUmcQueryAllProjectDistributeConfigReqBO reqBO) {
        BkUmcQueryAllProjectDistributeConfigRspBO rspBO = UmcRu.success(BkUmcQueryAllProjectDistributeConfigRspBO.class);
        ArrayList<BkUmcProjectDistributeConfigInfoBO> list = new ArrayList<BkUmcProjectDistributeConfigInfoBO>();
        BkUmcProjectDistributeConfigDo modelReqBO = UmcRu.js(reqBO, BkUmcProjectDistributeConfigDo.class);
        List<BkUmcProjectDistributeConfigDo> ProjectDistributeConfigList = this.bkUmcProjectDistributeConfigModel.queryAllProjectDistributeConfig(modelReqBO);
        if (CollectionUtils.isEmpty(ProjectDistributeConfigList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        Map<String, String> belongStageMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "BELONG_STAGE")).getMap();
        Map<String, String> configSystemMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "CONFIG_SYSTEM")).getMap();
        for (BkUmcProjectDistributeConfigDo bkUmcProjectDistributeConfigDo : ProjectDistributeConfigList) {
            BkUmcProjectDistributeConfigInfoBO resultBO = UmcRu.js(bkUmcProjectDistributeConfigDo, BkUmcProjectDistributeConfigInfoBO.class);
            if (ObjectUtil.isNotEmpty((Object)resultBO.getBelongStage()) && belongStageMap != null && belongStageMap.containsKey(resultBO.getBelongStage().toString())) {
                resultBO.setBelongStageStr(belongStageMap.get(resultBO.getBelongStage().toString()));
            }
            if (ObjectUtil.isNotEmpty((Object)resultBO.getConfigSystem()) && configSystemMap != null && configSystemMap.containsKey(resultBO.getConfigSystem().toString())) {
                resultBO.setConfigSystemStr(configSystemMap.get(resultBO.getConfigSystem().toString()));
            }
            list.add(resultBO);
        }
        rspBO.setResults(list);
        return rspBO;
    }

    @PostMapping(value={"queryProjectStatusDescDropDownList"})
    public BkUmcQueryProjectStatusDescDropDownListRspBO queryProjectStatusDescDropDownList(@RequestBody BkUmcQueryProjectStatusDescDropDownListReqBO reqBO) {
        BkUmcQueryProjectStatusDescDropDownListRspBO rspBO = UmcRu.success(BkUmcQueryProjectStatusDescDropDownListRspBO.class);
        List<BkUmcProjectDistributeConfigDo> bkUmcProjectDistributeConfigDos = this.bkUmcProjectDistributeConfigModel.queryProjectStatusDescDropDownList();
        if (ObjectUtil.isEmpty(bkUmcProjectDistributeConfigDos)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u72b6\u6001\u63cf\u8ff0");
            return rspBO;
        }
        List list = bkUmcProjectDistributeConfigDos.stream().map(e -> {
            BkUmcProjectStatusDescInfoBO statusDescInfoBO = new BkUmcProjectStatusDescInfoBO();
            statusDescInfoBO.setProjectStatusDesc(e.getProjectStatusDesc());
            return statusDescInfoBO;
        }).collect(Collectors.toList());
        rspBO.setRows(list);
        return rspBO;
    }

    @PostMapping(value={"batchAddProjectAuthority"})
    public BkUmcBatchAddProjectAuthorityRspBO batchAddProjectAuthority(@RequestBody BkUmcBatchAddProjectAuthorityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getProjectAuthorityInfos())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u6743\u9650\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchAddProjectAuthorityRspBO rspBO = UmcRu.success(BkUmcBatchAddProjectAuthorityRspBO.class);
        BkUmcProjectDistributeConfigDo modelReqDO = new BkUmcProjectDistributeConfigDo();
        modelReqDO.setProjectAuthorityInfos(UmcRu.jsl(reqBO.getProjectAuthorityInfos(), BkUmcProjectAuthorityInfoDO.class));
        this.bkUmcProjectDistributeConfigModel.batchAddProjectAuthority(modelReqDO);
        return rspBO;
    }

    @PostMapping(value={"batchUpdateProjectAuthority"})
    public BkUmcBatchUpdateProjectAuthorityRspBO batchUpdateProjectAuthority(@RequestBody BkUmcBatchUpdateProjectAuthorityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getProjectAuthorityInfos())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u6743\u9650\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchUpdateProjectAuthorityRspBO rspBO = UmcRu.success(BkUmcBatchUpdateProjectAuthorityRspBO.class);
        BkUmcProjectDistributeConfigDo modelReqDO = new BkUmcProjectDistributeConfigDo();
        modelReqDO.setProjectAuthorityInfos(UmcRu.jsl(reqBO.getProjectAuthorityInfos(), BkUmcProjectAuthorityInfoDO.class));
        this.bkUmcProjectDistributeConfigModel.batchUpdateProjectAuthority(modelReqDO);
        return rspBO;
    }

    @PostMapping(value={"queryProjectAuthorityList"})
    public BkUmcQueryProjectAuthorityRspBO queryProjectAuthorityList(@RequestBody BkUmcQueryProjectAuthorityReqBO reqBO) {
        BkUmcQueryProjectAuthorityRspBO rspBO = UmcRu.success(BkUmcQueryProjectAuthorityRspBO.class);
        BkUmcProjectDistributeConfigQryBo qryBo = UmcRu.js(reqBO, BkUmcProjectDistributeConfigQryBo.class);
        BasePageRspBo<BkUmcProjectDistributeConfigDo> ProjectDistributeConfigList = this.bkUmcProjectDistributeConfigModel.queryProjectAuthorityList(qryBo);
        if (CollectionUtils.isEmpty((Collection)ProjectDistributeConfigList.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = UmcRu.js(ProjectDistributeConfigList, BkUmcQueryProjectAuthorityRspBO.class);
        Map<String, String> belongStageMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "BELONG_STAGE")).getMap();
        Map<String, String> configSystemMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "CONFIG_SYSTEM")).getMap();
        for (BkUmcProjectDistributeConfigInfoBO resultBO : rspBO.getRows()) {
            if (ObjectUtil.isNotEmpty((Object)resultBO.getBelongStage()) && belongStageMap != null && belongStageMap.containsKey(resultBO.getBelongStage().toString())) {
                resultBO.setBelongStageStr(belongStageMap.get(resultBO.getBelongStage().toString()));
            }
            if (!ObjectUtil.isNotEmpty((Object)resultBO.getConfigSystem()) || configSystemMap == null || !configSystemMap.containsKey(resultBO.getConfigSystem().toString())) continue;
            resultBO.setConfigSystemStr(configSystemMap.get(resultBO.getConfigSystem().toString()));
        }
        return rspBO;
    }

    private void validBatchUpdateProjectData(BkUmcBatchUpdateProjectReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getProjectInfos())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u4e3a\u7a7a");
        }
        reqBO.getProjectInfos().forEach(bkUmcProjectInfoBO -> {
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectCode())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectCode]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectName())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectCompanyId())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectCompanyId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectCompanyName())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectCompanyName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getFirstBusiTypeCode())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[FirstBusiTypeCode]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getFirstBusiTypeName())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[FirstBusiTypeName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getSecondBusiTypeCode())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[SecondBusiTypeCode]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getSecondBusiTypeName())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[SecondBusiTypeName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getBelongStage())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[BelongStage]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectStatus())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[BrojectStatus]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectStatusDesc())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectStatusDesc]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getChangeType())) {
                throw new BaseBusinessException("200001", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u5165\u53c2[ChangeType]\u4e3a\u7a7a");
            }
        });
    }

    private void validQueryProjectDistributeConfigDetailsData(BkUmcQueryProjectDistributeConfigDetailsReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u9879\u76ee\u5206\u914d\u914d\u7f6e\u8be6\u60c5\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProjectCode())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u9879\u76ee\u5206\u914d\u914d\u7f6e\u8be6\u60c5\u5165\u53c2[ProjectCode]\u4e3a\u7a7a");
        }
    }

    private void validBatchAddProjectData(BkUmcBatchAddProjectReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        reqBO.getProjectInfos().forEach(bkUmcProjectInfoBO -> {
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectCode())) {
                log.info("\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectCode]\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)bkUmcProjectInfoBO));
            }
            if (ObjectUtil.isEmpty((Object)bkUmcProjectInfoBO.getProjectName())) {
                log.info("\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectName]\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)bkUmcProjectInfoBO));
            }
        });
    }

    private void validConfigProjectDistributeData(BkUmcConfigProjectDistributeReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u5206\u914d\uff08\u5355\u6761\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u5206\u914d\uff08\u5355\u6761\uff09\u5165\u53c2[id]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getConfigSystem())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u5206\u914d\uff08\u5355\u6761\uff09\u5165\u53c2[ConfigSystem]\u4e3a\u7a7a");
        }
    }

    private void validBatchConfigProjectDistributeData(BkUmcBatchConfigProjectDistributeReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u5206\u914d\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getIds())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u5206\u914d\uff08\u6279\u91cf\uff09\u5165\u53c2[ids]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getConfigSystem())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u5206\u914d\uff08\u6279\u91cf\uff09\u5165\u53c2[ConfigSystem]\u4e3a\u7a7a");
        }
    }
}

