/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseOrgQryRspBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.extension.api.BkUmcSupplierOrgModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcSupplierOrgQryBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcParentOrgInfoBo;
import com.tydic.dyc.umc.service.extension.api.BkUmcQryEnterpriseOrgTreeService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcEnterpriseOrgTreeBo;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQryEnterpriseOrgTreeReqBo;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQryEnterpriseOrgTreeRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcQryEnterpriseOrgTreeService"})
public class BkUmcQryEnterpriseOrgTreeServiceImpl
implements BkUmcQryEnterpriseOrgTreeService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private BkUmcSupplierOrgModel bkUmcSupplierOrgModel;

    @PostMapping(value={"qryEnterpriseOrgTree"})
    public BkUmcQryEnterpriseOrgTreeRspBo qryEnterpriseOrgTree(@RequestBody BkUmcQryEnterpriseOrgTreeReqBo reqBo) {
        UmcEnterpriseOrgQryBo enterpriseOrgQryBo = UmcRu.js(reqBo, UmcEnterpriseOrgQryBo.class);
        StrUtil.noNullStringAttr(enterpriseOrgQryBo);
        UmcEnterpriseOrgQryRspBo enterpriseInfoDoBasePageRspBo = this.iUmcEnterpriseInfoModel.getEnterpriseOrgListPage(enterpriseOrgQryBo);
        BkUmcQryEnterpriseOrgTreeRspBo rspBo = UmcRu.success(BkUmcQryEnterpriseOrgTreeRspBo.class);
        ArrayList<BkUmcEnterpriseOrgTreeBo> rows = new ArrayList<BkUmcEnterpriseOrgTreeBo>(enterpriseInfoDoBasePageRspBo.getRows().size());
        Map<String, String> map = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "ORG_TRADE_CAPACITY")).getMap();
        if (!CollectionUtils.isEmpty((Collection)enterpriseInfoDoBasePageRspBo.getRows())) {
            Map<Long, String> orgIdToNameMap = this.packagingOrgIdToNameMap(enterpriseInfoDoBasePageRspBo.getRows());
            for (UmcEnterpriseInfoDo enterpriseInfoDo : enterpriseInfoDoBasePageRspBo.getRows()) {
                BkUmcEnterpriseOrgTreeBo enterpriseOrgTreeBo = UmcRu.js((Object)enterpriseInfoDo.getOrgInfo(), BkUmcEnterpriseOrgTreeBo.class);
                List<UmcOrgTagRel> orgTagRelList = enterpriseInfoDo.getOrgInfo().getOrgTagRelList();
                if (!CollectionUtils.isEmpty(orgTagRelList)) {
                    List tags = orgTagRelList.stream().map(UmcOrgTagRel::getTagId).collect(Collectors.toList());
                    String tagStr = tags.toString();
                    String isProfessionalOrg = "";
                    isProfessionalOrg = tagStr.contains("2") ? "2" : (tagStr.contains("0") ? "0" : (tagStr.contains("1") ? "1" : ""));
                    enterpriseOrgTreeBo.setIsProfessionalOrg(isProfessionalOrg);
                    enterpriseOrgTreeBo.setIsProfessionalOrgStr(map.get(isProfessionalOrg));
                }
                if (enterpriseInfoDo.getIsParent() > 0) {
                    enterpriseOrgTreeBo.setIsParentOrg("1");
                    enterpriseOrgTreeBo.setIsParent("0");
                } else {
                    enterpriseOrgTreeBo.setIsParentOrg("0");
                    enterpriseOrgTreeBo.setIsParent("1");
                }
                this.packagingParentOrgInfoList(enterpriseOrgTreeBo, orgIdToNameMap);
                rows.add(enterpriseOrgTreeBo);
            }
        }
        if (reqBo.isQrySup()) {
            BkUmcSupplierOrgQryBo bo = new BkUmcSupplierOrgQryBo();
            bo.setOrgName(reqBo.getOrgName());
            List<BkUmcEnterpriseOrgTreeBo> supList = this.bkUmcSupplierOrgModel.qrySup(bo);
            if (CollectionUtil.isNotEmpty(supList)) {
                rows.addAll(supList);
            }
            rspBo.setRecordsTotal(rows.size());
        } else {
            rspBo.setRecordsTotal(enterpriseInfoDoBasePageRspBo.getRecordsTotal());
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(enterpriseInfoDoBasePageRspBo.getPageNo());
        rspBo.setTotal(enterpriseInfoDoBasePageRspBo.getTotal());
        return rspBo;
    }

    public static void main(String[] args) {
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add("1");
        stringList.add("0");
        System.out.println(((Object)stringList).toString());
    }

    public Map<Long, String> packagingOrgIdToNameMap(List<UmcEnterpriseInfoDo> umcEnterpriseInfoDoList) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (UmcEnterpriseInfoDo umcEnterpriseInfoDo : umcEnterpriseInfoDoList) {
            String[] arr;
            for (String s : arr = umcEnterpriseInfoDo.getOrgInfo().getOrgTreePath().split("-")) {
                if (umcEnterpriseInfoDo.getOrgId().equals(Long.valueOf(s)) || orgIds.contains(Long.valueOf(s))) continue;
                orgIds.add(Long.valueOf(s));
            }
        }
        Map<Long, String> orgIdToNameMap = new HashMap<Long, String>(10);
        if (!CollectionUtils.isEmpty(orgIds)) {
            UmcEnterpriseInfoDo umcEnterpriseInfoDo;
            umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
            umcEnterpriseInfoDo.setOrgIds(orgIds);
            UmcOrgInfoRspBo umcOrgInfoRspBo = this.iUmcEnterpriseInfoModel.batchQueryOrgInfoListByOrgIds(umcEnterpriseInfoDo);
            if (!CollectionUtils.isEmpty((Collection)umcOrgInfoRspBo.getRows())) {
                orgIdToNameMap = umcOrgInfoRspBo.getRows().stream().filter(umcOrgInfo -> ObjectUtil.isNotEmpty((Object)umcOrgInfo.getOrgName())).collect(Collectors.toMap(UmcOrgInfo::getOrgId, UmcOrgInfo::getOrgName, (key1, key2) -> key2));
            }
        }
        return orgIdToNameMap;
    }

    public void packagingParentOrgInfoList(BkUmcEnterpriseOrgTreeBo enterpriseOrgTreeBo, Map<Long, String> orgIdToNameMap) {
        if (!CollectionUtils.isEmpty(orgIdToNameMap)) {
            ArrayList<UmcParentOrgInfoBo> parentOrgInfoBoList = new ArrayList<UmcParentOrgInfoBo>(10);
            String[] arr = enterpriseOrgTreeBo.getOrgTreePath().split("-");
            ArrayList<String> orgIds = new ArrayList<String>(Arrays.asList(arr));
            for (String orgId : orgIds) {
                if (Long.parseLong(orgId) == 1L || !ObjectUtil.isNotEmpty((Object)orgIdToNameMap.get(Long.valueOf(orgId)))) continue;
                UmcParentOrgInfoBo umcParentOrgInfoBo = new UmcParentOrgInfoBo();
                umcParentOrgInfoBo.setOrgId(Long.valueOf(orgId));
                umcParentOrgInfoBo.setOrgName(orgIdToNameMap.get(Long.valueOf(orgId)));
                parentOrgInfoBoList.add(umcParentOrgInfoBo);
            }
            enterpriseOrgTreeBo.setParentOrgInfoBoList(parentOrgInfoBoList);
        }
    }
}

