/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.api.BkUmcTodoModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchAddHaveDoneReqDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcQryHaveDoneReqDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcQryHaveDoneRspDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoDo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoListRspBo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoQryBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.api.BkUmcTodoService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddHaveDoneReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddHaveDoneRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushTodoResultInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQryHaveDoneReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQryHaveDoneRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryTodoDetailsReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryTodoDetailsRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryTodoOrDoneListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryTodoOrDoneListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcTodoInfoBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcTodoService"})
public class BkUmcTodoServiceImpl
implements BkUmcTodoService {
    private static final Logger log = LoggerFactory.getLogger(BkUmcTodoServiceImpl.class);
    @Autowired
    private BkUmcTodoModel bkUmcTodoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"queryTodoOrDoneList"})
    public BkUmcQueryTodoOrDoneListRspBO queryTodoOrDoneList(@RequestBody BkUmcQueryTodoOrDoneListReqBO reqBO) {
        this.validQueryTodoOrDoneListData(reqBO);
        BkUmcQueryTodoOrDoneListRspBO rspBO = new BkUmcQueryTodoOrDoneListRspBO();
        ArrayList<BkUmcTodoInfoBO> list = new ArrayList<BkUmcTodoInfoBO>();
        BkUmcTodoQryBo qryBo = new BkUmcTodoQryBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)qryBo));
        BkUmcTodoListRspBo bkUmcTodoListRspBo = this.bkUmcTodoModel.queryTodoOrDoneList(qryBo);
        if (CollectionUtils.isEmpty((Collection)bkUmcTodoListRspBo.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = UmcRu.js((Object)bkUmcTodoListRspBo, BkUmcQueryTodoOrDoneListRspBO.class);
        Map<String, String> dealResultMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "DEAL_RESULT")).getMap();
        for (BkUmcTodoDo bkUmcTodoDo : bkUmcTodoListRspBo.getRows()) {
            BkUmcTodoInfoBO bkUmcTodoInfoBO = new BkUmcTodoInfoBO();
            BeanUtils.copyProperties((Object)bkUmcTodoDo, (Object)bkUmcTodoInfoBO);
            if (BkUmcStatusConstant.todoType.PENDING_APPROVAL.equals(bkUmcTodoInfoBO.getTodoType()) && BkUmcStatusConstant.TodoOrDoneStatus.DONE.equals(bkUmcTodoInfoBO.getTodoStatus()) && ObjectUtil.isNotEmpty((Object)bkUmcTodoInfoBO.getDealResult()) && dealResultMap != null && dealResultMap.containsKey(bkUmcTodoInfoBO.getDealResult().toString())) {
                bkUmcTodoInfoBO.setDealResultStr(dealResultMap.get(bkUmcTodoInfoBO.getDealResult().toString()));
            }
            list.add(bkUmcTodoInfoBO);
        }
        rspBO.setRows(list);
        return rspBO;
    }

    @PostMapping(value={"batchPushTodo"})
    public BkUmcBatchPushTodoRspBO batchPushTodo(@RequestBody BkUmcBatchPushTodoReqBO reqBO) {
        this.validBatchPushTodoData(reqBO);
        BkUmcBatchPushTodoRspBO rspBO = UmcRu.success(BkUmcBatchPushTodoRspBO.class);
        List<BkUmcTodoDo> pushTodoDOS = reqBO.getTodoInfos().stream().map(bkUmcPushTodoInfoBO -> {
            BkUmcTodoDo bkUmcTodoDo = new BkUmcTodoDo();
            BeanUtils.copyProperties((Object)bkUmcPushTodoInfoBO, (Object)bkUmcTodoDo);
            if (StringUtils.isEmpty((Object)bkUmcTodoDo.getBelongIdentity())) {
                bkUmcTodoDo.setBelongIdentity("9");
            }
            return bkUmcTodoDo;
        }).collect(Collectors.toList());
        List<BkUmcPushTodoResultInfoBO> resultInfo = this.bkUmcTodoModel.batchPushTodo(pushTodoDOS);
        rspBO.setResultInfo(resultInfo);
        return rspBO;
    }

    @PostMapping(value={"pushDone"})
    public BkUmcPushDoneRspBO pushDone(@RequestBody BkUmcPushDoneReqBO reqBO) {
        this.validPushDoneData(reqBO);
        BkUmcPushDoneRspBO rspBO = UmcRu.success(BkUmcPushDoneRspBO.class);
        BkUmcTodoDo modelReqBO = UmcRu.js(reqBO, BkUmcTodoDo.class);
        List<BkUmcTodoDo> bkUmcTodoDo = this.bkUmcTodoModel.pushDone(modelReqBO);
        List<BkUmcPushDoneInfoBO> todoInfos = UmcRu.jsl(bkUmcTodoDo, BkUmcPushDoneInfoBO.class);
        rspBO.setTodoInfos(todoInfos);
        return rspBO;
    }

    @PostMapping(value={"batchAddHaveDone"})
    public BkUmcBatchAddHaveDoneRspBO batchAddHaveDone(@RequestBody BkUmcBatchAddHaveDoneReqBO bkUmcBatchAddHaveDoneReqBO) {
        this.validBatchAddHaveDoneData(bkUmcBatchAddHaveDoneReqBO);
        BkUmcBatchAddHaveDoneReqDO bkUmcBatchAddHaveDoneReqDO = UmcRu.js(bkUmcBatchAddHaveDoneReqBO, BkUmcBatchAddHaveDoneReqDO.class);
        this.bkUmcTodoModel.batchAddHaveDone(bkUmcBatchAddHaveDoneReqDO);
        BkUmcBatchAddHaveDoneRspBO rspBO = UmcRu.success(BkUmcBatchAddHaveDoneRspBO.class);
        return rspBO;
    }

    @PostMapping(value={"qryHaveDoneList"})
    public BkUmcQryHaveDoneRspBO qryHaveDoneList(@RequestBody BkUmcQryHaveDoneReqBO bkUmcQryHaveDoneReqBO) {
        this.validQryHaveDoneData(bkUmcQryHaveDoneReqBO);
        BkUmcQryHaveDoneReqDO bkUmcQryHaveDoneReqDO = UmcRu.js(bkUmcQryHaveDoneReqBO, BkUmcQryHaveDoneReqDO.class);
        BkUmcQryHaveDoneRspDO bkUmcQryHaveDoneRspDO = this.bkUmcTodoModel.qryHaveDoneList(bkUmcQryHaveDoneReqDO);
        BkUmcQryHaveDoneRspBO rspBO = new BkUmcQryHaveDoneRspBO();
        BeanUtils.copyProperties((Object)((Object)bkUmcQryHaveDoneRspDO), (Object)rspBO);
        rspBO.setRows(bkUmcQryHaveDoneRspDO.getRows());
        return rspBO;
    }

    @PostMapping(value={"queryTodoDetails"})
    public BkUmcQueryTodoDetailsRspBO queryTodoDetails(@RequestBody BkUmcQueryTodoDetailsReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5f85\u529e\u8be6\u60c5\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5f85\u529e\u8be6\u60c5\u5165\u53c2[Id]\u4e3a\u7a7a");
        }
        BkUmcQueryTodoDetailsRspBO rspBO = UmcRu.success(BkUmcQueryTodoDetailsRspBO.class);
        BkUmcTodoDo qryBO = UmcRu.js(reqBO, BkUmcTodoDo.class);
        BkUmcTodoDo umcTodoDo = this.bkUmcTodoModel.queryTodoDetails(qryBO);
        if (ObjectUtil.isEmpty((Object)umcTodoDo)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f85\u529e\u8be6\u60c5");
            return rspBO;
        }
        Map<String, String> dealResultMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "DEAL_RESULT")).getMap();
        rspBO = UmcRu.js(umcTodoDo, BkUmcQueryTodoDetailsRspBO.class);
        if (BkUmcStatusConstant.todoType.PENDING_APPROVAL.equals(rspBO.getTodoType()) && BkUmcStatusConstant.TodoOrDoneStatus.DONE.equals(rspBO.getTodoStatus()) && ObjectUtil.isNotEmpty((Object)rspBO.getDealResult()) && dealResultMap != null && dealResultMap.containsKey(rspBO.getDealResult().toString())) {
            rspBO.setDealResultStr(dealResultMap.get(rspBO.getDealResult().toString()));
        }
        return rspBO;
    }

    private void validPushDoneData(BkUmcPushDoneReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId()) && ObjectUtil.isEmpty((Object)reqBO.getBusiId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private void validBatchPushTodoData(BkUmcBatchPushTodoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTodoInfos())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        reqBO.getTodoInfos().forEach(bkPushTodoInfoBO -> {
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoType())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoType]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getBelongModule())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[belongModule]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoEvent())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoEvent]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getLinkUrl())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[linkUrl]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateUserName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgName]\u4e3a\u7a7a");
            }
        });
    }

    private void validQueryTodoOrDoneListData(BkUmcQueryTodoOrDoneListReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5f85\u529e/\u5df2\u529e\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getTodoType()) && ObjectUtil.isEmpty((Object)reqBO.getTodoStatus())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5f85\u529e/\u5df2\u529e\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private void validBatchAddHaveDoneData(BkUmcBatchAddHaveDoneReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("8888", "\u6279\u91cf\u6dfb\u52a0\u5df2\u529e\u5386\u53f2\u6570\u636e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBusinessId())) {
            throw new BaseBusinessException("8888", "\u6279\u91cf\u6dfb\u52a0\u5df2\u529e\u5386\u53f2\u6570\u636e\u4e1a\u52a1\u5355\u636e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getHaveDoneRelativeId())) {
            throw new BaseBusinessException("8888", "\u6279\u91cf\u6dfb\u52a0\u5df2\u529e\u5386\u53f2\u6570\u636e\u5df2\u529e\u9879\u5173\u8054id\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private void validQryHaveDoneData(BkUmcQryHaveDoneReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u5df2\u529e\u5386\u53f2\u6570\u636e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getHaveDoneRelativeId())) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u5df2\u529e\u5386\u53f2\u6570\u636e\u5df2\u529e\u9879\u5173\u8054id\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getHaveDoneRelativeClass()) && ObjectUtil.isEmpty((Object)reqBO.getHaveDoneItemRelativeClass())) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u5df2\u529e\u5386\u53f2\u6570\u636e\u5173\u8054\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a");
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getHaveDoneRelativeClass()) && !ObjectUtil.isEmpty((Object)reqBO.getHaveDoneItemRelativeClass())) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u5df2\u529e\u5386\u53f2\u6570\u636e\u5173\u8054\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a");
        }
    }
}

