/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.extension.api.BkUmcUserModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryUserInfoModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcUserSummaryInfoDO;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.extension.api.BkUmcUserService;
import com.tydic.dyc.umc.service.extension.bo.BatchQueryInnerUserPartTimeJobReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryInnerUserPartTimeJobInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserIdentityListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserIdentityListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchUpdateCustTempOrgCodeReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchUpdateCustTempOrgCodeRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcIdentityInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcInnerUserPartTimeJobInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcInnerUserSummaryInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPartTimeJobInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserIdentityInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserInfoPartReqBo;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserInfoPartRspBo;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserSummaryInfoBO;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcUserService"})
public class BkUmcUserServiceImpl
implements BkUmcUserService {
    private static final Logger log = LoggerFactory.getLogger(BkUmcUserServiceImpl.class);
    @Autowired
    private BkUmcUserModel bkUmcUserModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    @PostMapping(value={"batchQueryUserInfo"})
    public BkUmcBatchQueryUserInfoRspBO batchQueryUserInfo(@RequestBody BkUmcBatchQueryUserInfoReqBO reqBO) {
        List<BkUmcUserSummaryInfoDO> userInfos;
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUserCodes()) && ObjectUtil.isEmpty((Object)reqBO.getUserIds())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryUserInfoRspBO rspBO = UmcRu.success(BkUmcBatchQueryUserInfoRspBO.class);
        BkUmcBatchQueryUserInfoModelReqBO modelReqBO = new BkUmcBatchQueryUserInfoModelReqBO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getUserIds())) {
            modelReqBO.setUserIds(reqBO.getUserIds());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getUserCodes())) {
            modelReqBO.setUserCodes(reqBO.getUserCodes());
        }
        if (CollectionUtils.isEmpty(userInfos = this.bkUmcUserModel.batchQueryUserInfo(modelReqBO))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        List collect = userInfos.stream().map(bkUmcUserSummaryInfoDO -> {
            BkUmcUserSummaryInfoBO bkUmcUserSummaryInfoBO = new BkUmcUserSummaryInfoBO();
            BeanUtils.copyProperties((Object)bkUmcUserSummaryInfoDO, (Object)bkUmcUserSummaryInfoBO);
            return bkUmcUserSummaryInfoBO;
        }).collect(Collectors.toList());
        rspBO.setUserInfos(collect);
        return rspBO;
    }

    @PostMapping(value={"batchQueryUserIdentityList"})
    public BkUmcBatchQueryUserIdentityListRspBO batchQueryUserIdentityList(@RequestBody BkUmcBatchQueryUserIdentityListReqBO reqBO) {
        List<BkUmcUserSummaryInfoDO> bkUmcUserSummaryInfoDOS;
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u7528\u6237\u8eab\u4efd\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUserIds())) {
            throw new BaseBusinessException("200001", "\u7528\u6237\u8eab\u4efd\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryUserIdentityListRspBO rspBO = UmcRu.success(BkUmcBatchQueryUserIdentityListRspBO.class);
        BkUmcBatchQueryUserInfoReqBO modelReqBO = new BkUmcBatchQueryUserInfoReqBO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getUserIds())) {
            modelReqBO.setUserIds(reqBO.getUserIds());
        }
        if (CollectionUtils.isEmpty(bkUmcUserSummaryInfoDOS = this.bkUmcUserModel.batchQueryUserIdentityList(modelReqBO))) {
            rspBO.setRespDesc("\u7528\u6237\u8eab\u4efd\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        ArrayList<BkUmcUserIdentityInfoBO> list = new ArrayList<BkUmcUserIdentityInfoBO>();
        for (BkUmcUserSummaryInfoDO bkUmcUserSummaryInfoDO : bkUmcUserSummaryInfoDOS) {
            BkUmcUserIdentityInfoBO bkUmcUserIdentityInfoBO = new BkUmcUserIdentityInfoBO();
            bkUmcUserIdentityInfoBO.setUserId(bkUmcUserSummaryInfoDO.getUserId());
            if (!CollectionUtils.isEmpty(bkUmcUserSummaryInfoDO.getIdentityTags())) {
                List collect = bkUmcUserSummaryInfoDO.getIdentityTags().stream().map(identityTag -> {
                    BkUmcIdentityInfoBO bkUmcIdentityInfoBO = new BkUmcIdentityInfoBO();
                    bkUmcIdentityInfoBO.setIdentityTag(identityTag);
                    if (identityTag.equals("0")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u8fd0\u8425");
                    } else if (identityTag.equals("1")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u91c7\u8d2d");
                    } else if (identityTag.equals("2")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u9500\u552e");
                    } else {
                        throw new BaseBusinessException("200100", "\u4e0d\u5b58\u5728\u6b64\u8eab\u4efd\u63cf\u8ff0");
                    }
                    return bkUmcIdentityInfoBO;
                }).collect(Collectors.toList());
                bkUmcUserIdentityInfoBO.setIdentityInfos(collect);
            }
            list.add(bkUmcUserIdentityInfoBO);
        }
        rspBO.setUserIdentityInfos(list);
        return rspBO;
    }

    @PostMapping(value={"batchQueryInnerUserPartTimeJobInfo"})
    public BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO batchQueryInnerUserPartTimeJobInfo(@RequestBody BkUmcBatchQueryInnerUserPartTimeJobInfoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5185\u90e8\u7528\u6237\u517c\u804c\u4fe1\u606f\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCustIds())) {
            throw new BaseBusinessException("200001", "\u5185\u90e8\u7528\u6237\u517c\u804c\u4fe1\u606f\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO rspBO = UmcRu.success(BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO.class);
        List custIds = reqBO.getCustIds().stream().map(BkUmcInnerUserSummaryInfoBO::getCustId).collect(Collectors.toList());
        Map mainCustMap = reqBO.getCustIds().stream().collect(Collectors.toMap(BkUmcInnerUserSummaryInfoBO::getCustId, Function.identity()));
        BatchQueryInnerUserPartTimeJobReqBO batchQueryInnerUserPartTimeJobReqBO = new BatchQueryInnerUserPartTimeJobReqBO();
        batchQueryInnerUserPartTimeJobReqBO.setCustIds(custIds);
        batchQueryInnerUserPartTimeJobReqBO.setOrgIdWeb(reqBO.getOrgIdWeb());
        batchQueryInnerUserPartTimeJobReqBO.setOrgName(reqBO.getOrgName());
        List<BkUmcUserSummaryInfoDO> bkUmcUserSummaryInfoDOS = this.bkUmcUserModel.batchQueryInnerUserPartTimeJobInfo(batchQueryInnerUserPartTimeJobReqBO);
        if (ObjectUtil.isEmpty(bkUmcUserSummaryInfoDOS)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5185\u90e8\u7528\u6237\u517c\u804c\u4fe1\u606f");
            return rspBO;
        }
        List<Long> orgIds = bkUmcUserSummaryInfoDOS.stream().map(BkUmcUserSummaryInfoDO::getOrgId).distinct().collect(Collectors.toList());
        Map<String, String> stopStatusMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "MEM_STOP_STATUS")).getMap();
        Map<String, String> userTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "USER_TYPE")).getMap();
        UmcEnterpriseInfoDo pathReqDo = new UmcEnterpriseInfoDo();
        pathReqDo.setOrgIds(orgIds);
        Map<Long, String> orgFullNameMap = this.iUmcEnterpriseInfoModel.getOrgFullNameByOrgIds(pathReqDo).getOrgFullNameByOrgIds();
        ArrayList<BkUmcPartTimeJobInfoBO> list = new ArrayList<BkUmcPartTimeJobInfoBO>();
        for (BkUmcUserSummaryInfoDO bkUmcUserSummaryInfoDO : bkUmcUserSummaryInfoDOS) {
            BkUmcPartTimeJobInfoBO infoBO = UmcRu.js(bkUmcUserSummaryInfoDO, BkUmcPartTimeJobInfoBO.class);
            if (stopStatusMap != null && stopStatusMap.containsKey(infoBO.getStopStatus())) {
                infoBO.setStopStatusStr(stopStatusMap.get(infoBO.getStopStatus()));
            }
            if (userTypeMap != null && userTypeMap.containsKey(infoBO.getUserType())) {
                infoBO.setUserTypeStr(userTypeMap.get(infoBO.getUserType()));
            }
            if (orgFullNameMap != null && orgFullNameMap.containsKey(infoBO.getOrgId())) {
                infoBO.setOrgFullName(orgFullNameMap.get(infoBO.getOrgId()).replaceFirst("root-", ""));
            }
            infoBO.setRegEmail(((BkUmcInnerUserSummaryInfoBO)mainCustMap.get(infoBO.getMainCustId())).getRegEmail());
            infoBO.setRegMobile(((BkUmcInnerUserSummaryInfoBO)mainCustMap.get(infoBO.getMainCustId())).getRegMobile());
            infoBO.setCustName(((BkUmcInnerUserSummaryInfoBO)mainCustMap.get(infoBO.getMainCustId())).getCustName());
            list.add(infoBO);
        }
        Map<Long, List<BkUmcPartTimeJobInfoBO>> listMap = list.stream().collect(Collectors.groupingBy(BkUmcPartTimeJobInfoBO::getMainCustId));
        Iterator<Long> mainCustIds = listMap.keySet().iterator();
        ArrayList<BkUmcInnerUserPartTimeJobInfoBO> rows = new ArrayList<BkUmcInnerUserPartTimeJobInfoBO>();
        while (mainCustIds.hasNext()) {
            Long mainCustId = mainCustIds.next();
            BkUmcInnerUserPartTimeJobInfoBO bkUmcInnerUserPartTimeJobInfoBO = new BkUmcInnerUserPartTimeJobInfoBO();
            bkUmcInnerUserPartTimeJobInfoBO.setCustId(mainCustId);
            bkUmcInnerUserPartTimeJobInfoBO.setPartTimeJobInfos(listMap.get(mainCustId));
            rows.add(bkUmcInnerUserPartTimeJobInfoBO);
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    @PostMapping(value={"partUserInfo"})
    public BkUmcUserInfoPartRspBo partUserInfo(@RequestBody BkUmcUserInfoPartReqBo reqBo) {
        this.validPartUserInfoData(reqBo);
        BkUmcUserInfoPartRspBo rspBo = UmcRu.success(BkUmcUserInfoPartRspBo.class);
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        userInfoQryBo.setDelFlag("0");
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBo.getNewOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        UmcUserInfoDo umcUserInfoDo = this.buildUserInfo(reqBo, userInfoDo, orgInfo);
        this.iUmcUserInfoModel.createUserInfo(umcUserInfoDo);
        rspBo.setUserInfoBo(UmcRu.js(umcUserInfoDo, UmcUserInfoBo.class));
        return rspBo;
    }

    @PostMapping(value={"updateCustTempOrgCode"})
    public BkUmcBatchUpdateCustTempOrgCodeRspBO updateCustTempOrgCode(@RequestBody BkUmcBatchUpdateCustTempOrgCodeReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u7528\u6237\u4e34\u65f6\u8868\u673a\u6784\u7f16\u7801\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBkUmcCustTempOrgCodeBOS())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u7528\u6237\u4e34\u65f6\u8868\u673a\u6784\u7f16\u7801\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchUpdateCustTempOrgCodeRspBO rspBO = UmcRu.success(BkUmcBatchUpdateCustTempOrgCodeRspBO.class);
        List<BkUmcUserSummaryInfoDO> modelReqBOS = UmcRu.jsl(reqBO.getBkUmcCustTempOrgCodeBOS(), BkUmcUserSummaryInfoDO.class);
        this.bkUmcUserModel.updateCustTempOrgCode(modelReqBOS);
        return rspBO;
    }

    private UmcUserInfoDo buildUserInfo(BkUmcUserInfoPartReqBo reqBo, UmcUserInfoDo userInfoDo, UmcOrgInfo orgInfo) {
        UmcUserInfoDo umcUserInfoDo = UmcRu.js(userInfoDo, UmcUserInfoDo.class);
        umcUserInfoDo.setUserId(reqBo.getNewUserId());
        umcUserInfoDo.setOrgId(reqBo.getNewOrgId());
        umcUserInfoDo.setCustInfo(null);
        umcUserInfoDo.setUserExtMapList(null);
        umcUserInfoDo.setExtField1(reqBo.getRemark());
        umcUserInfoDo.setCreateOperId(reqBo.getCreateOperId());
        umcUserInfoDo.setCreateOperName(reqBo.getCreateOperName());
        umcUserInfoDo.setCreateTime(reqBo.getCreateTime());
        umcUserInfoDo.setUpdateOperId(reqBo.getUpdateOperId());
        umcUserInfoDo.setUpdateOperName(reqBo.getUpdateOperName());
        umcUserInfoDo.setUpdateTime(reqBo.getUpdateTime());
        umcUserInfoDo.setIsMain("0");
        ArrayList<UmcUserTagRel> userTagRelList = new ArrayList<UmcUserTagRel>();
        if (CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            UmcUserTagRel userTagRel = new UmcUserTagRel();
            userTagRel.setRelId(IdUtil.nextId());
            userTagRel.setUserId(reqBo.getNewUserId());
            userTagRel.setTagId("1");
            userTagRel.setCreateTime(reqBo.getCreateTime());
            userTagRel.setCreateOperId(reqBo.getCreateOperId());
            userTagRel.setCreateOperName(reqBo.getCreateOperName());
            userTagRel.setIsDefalt("1");
            userTagRel.setDelFlag("0");
            userTagRel.setTenantId(10000L);
            userTagRelList.add(userTagRel);
        } else {
            for (UmcUserTagRelBo bo : reqBo.getUserTagRelList()) {
                UmcUserTagRel userTagRel = new UmcUserTagRel();
                userTagRel.setRelId(IdUtil.nextId());
                userTagRel.setUserId(reqBo.getNewUserId());
                userTagRel.setTagId(bo.getTagId());
                userTagRel.setIsDefalt(bo.getIsDefalt());
                userTagRel.setDelFlag("0");
                userTagRel.setTenantId(10000L);
                userTagRel.setCreateTime(reqBo.getCreateTime());
                userTagRel.setCreateOperId(reqBo.getCreateOperId());
                userTagRel.setCreateOperName(reqBo.getCreateOperName());
                userTagRelList.add(userTagRel);
            }
        }
        umcUserInfoDo.setUserTagRelList(userTagRelList);
        ArrayList<UmcUserRoleRel> userRoleRelList = new ArrayList<UmcUserRoleRel>();
        if (CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelBoList())) {
            UmcUserRoleRel userRoleRel = new UmcUserRoleRel();
            userRoleRel.setRelId(IdUtil.nextId());
            userRoleRel.setUserId(reqBo.getNewUserId());
            userRoleRel.setTagId("1");
            userRoleRel.setCreateTime(reqBo.getCreateTime());
            userRoleRel.setCreateOperId(reqBo.getCreateOperId());
            userRoleRel.setCreateOperName(reqBo.getCreateOperName());
            userRoleRel.setDelFlag("0");
            userRoleRel.setRoleId(2L);
            userRoleRel.setTenantId(10000L);
            userRoleRelList.add(userRoleRel);
        } else {
            for (UmcUserRoleRelBo bo : reqBo.getUserRoleRelBoList()) {
                UmcUserRoleRel userRoleRel = new UmcUserRoleRel();
                userRoleRel.setRelId(IdUtil.nextId());
                userRoleRel.setUserId(reqBo.getNewUserId());
                userRoleRel.setTagId(bo.getTagId());
                userRoleRel.setDelFlag("0");
                userRoleRel.setRoleId(bo.getRoleId());
                userRoleRel.setTenantId(10000L);
                userRoleRel.setRoleName(bo.getRoleName());
                userRoleRel.setCreateTime(reqBo.getCreateTime());
                userRoleRel.setCreateOperId(reqBo.getCreateOperId());
                userRoleRel.setCreateOperName(reqBo.getCreateOperName());
                userRoleRelList.add(userRoleRel);
            }
        }
        umcUserInfoDo.setUserRoleRelList(userRoleRelList);
        umcUserInfoDo.setOrgTreePath(orgInfo.getOrgTreePath());
        umcUserInfoDo.setCompanyId(orgInfo.getCompanyId());
        return umcUserInfoDo;
    }

    private void validPartUserInfoData(BkUmcUserInfoPartReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[newUserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewOrgId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[NewOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

