/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.ManageOrgInfo.IUmcManageOrgInfoModel;
import com.tydic.dyc.umc.model.ManageOrgInfo.UmcManageOrgInfoDo;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfoSyncTmp;
import com.tydic.dyc.umc.service.enterprise.UmcManageOrgInfoSyncTempAddService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcManageOrgInfoSyncTempAddReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcManageOrgInfoSyncTempAddRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcManageOrgInfoSyncTempBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcManageOrgInfoSyncTempAddService"})
public class UmcManageOrgInfoSyncTempAddServiceImpl
implements UmcManageOrgInfoSyncTempAddService {
    private static final Logger log = LoggerFactory.getLogger(UmcManageOrgInfoSyncTempAddServiceImpl.class);
    public static final String BK_ORG_CLASS_ORG = "1";
    public static final String BK_ORG_CLASS_DEPART = "2";
    @Autowired
    private IUmcManageOrgInfoModel iUmcManageOrgInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"syncManageOrgInfo"})
    public UmcManageOrgInfoSyncTempAddRspBo syncManageOrgInfo(@RequestBody UmcManageOrgInfoSyncTempAddReqBo reqBo) {
        if (CollectionUtil.isEmpty((Collection)reqBo.getUmcManageOrgInfoSyncTempBos())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[umcManageOrgInfoSyncTempBos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
        ArrayList<UmcOrgInfoSyncTmp> orgInfoSyncTmpList = new ArrayList<UmcOrgInfoSyncTmp>();
        ArrayList<UmcManageOrgInfoDo> umcManageOrgInfoDos = new ArrayList<UmcManageOrgInfoDo>();
        for (UmcManageOrgInfoSyncTempBo each : reqBo.getUmcManageOrgInfoSyncTempBos()) {
            UmcOrgInfoSyncTmp umcOrgInfoSyncTmp = UmcRu.js(each, UmcOrgInfoSyncTmp.class);
            if (BK_ORG_CLASS_ORG.equals(each.getOrgClass())) {
                umcOrgInfoSyncTmp.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
            } else if (BK_ORG_CLASS_DEPART.equals(each.getOrgClass())) {
                umcOrgInfoSyncTmp.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_DEPARTMENT);
            }
            umcOrgInfoSyncTmp.setOrgCode(each.getManageOrgCode());
            umcOrgInfoSyncTmp.setExtOrgCode(each.getPkManageOrg());
            umcOrgInfoSyncTmp.setParentCode(each.getPkFatherManageOrg());
            if (!StringUtils.isBlank((CharSequence)each.getManageOrgLevel())) {
                umcOrgInfoSyncTmp.setDeep(Integer.valueOf(each.getManageOrgLevel()));
            }
            umcOrgInfoSyncTmp.setOrgName(each.getManageOrgName());
            umcOrgInfoSyncTmp.setOrgAlias(each.getManageOrgShortName());
            if ("true".equals(each.getVirtualOrgFlag())) {
                umcOrgInfoSyncTmp.setIsVirtual("0");
            } else if ("false".equals(each.getVirtualOrgFlag())) {
                umcOrgInfoSyncTmp.setIsVirtual(BK_ORG_CLASS_ORG);
            }
            if (BK_ORG_CLASS_ORG.equals(each.getManageOrgStatus())) {
                umcOrgInfoSyncTmp.setOrgStatus(BK_ORG_CLASS_ORG);
            } else if ("0".equals(each.getManageOrgStatus())) {
                umcOrgInfoSyncTmp.setOrgStatus("0");
            }
            if ("true".equals(each.getDeleteFlag())) {
                umcOrgInfoSyncTmp.setDelFlag(BK_ORG_CLASS_ORG);
            } else if ("false".equals(each.getDeleteFlag())) {
                umcOrgInfoSyncTmp.setDelFlag("0");
            }
            umcOrgInfoSyncTmp.setOrgSource(UmcCommConstant.OrgSource.MANAGE);
            umcOrgInfoSyncTmp.setIsMerchant(BK_ORG_CLASS_ORG);
            umcOrgInfoSyncTmp.setIsProfess(BK_ORG_CLASS_ORG);
            umcOrgInfoSyncTmp.setIsShopOrg("0");
            umcOrgInfoSyncTmp.setIsCreateDefaultAccount(UmcStatusConstant.IsCreateDefaultAccount.NO);
            umcOrgInfoSyncTmp.setOrgClass("4");
            this.val(umcOrgInfoSyncTmp);
            orgInfoSyncTmpList.add(umcOrgInfoSyncTmp);
            UmcManageOrgInfoDo umcManageOrgInfoDo = UmcRu.js(each, UmcManageOrgInfoDo.class);
            if ("true".equals(each.getDeleteFlag())) {
                umcManageOrgInfoDo.setDelFlag(BK_ORG_CLASS_ORG);
            } else if ("false".equals(each.getDeleteFlag())) {
                umcManageOrgInfoDo.setDelFlag("0");
            }
            umcManageOrgInfoDos.add(umcManageOrgInfoDo);
        }
        umcEnterpriseInfoDo.setOrgInfoSyncTmpList(orgInfoSyncTmpList);
        try {
            this.iUmcEnterpriseInfoModel.addOrgInfoSyncTemp(umcEnterpriseInfoDo);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4fdd\u5b58\u673a\u6784\u4e34\u65f6\u8868\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("8888", "\u8c03\u7528\u4fdd\u5b58\u673a\u6784\u4e34\u65f6\u8868\u5931\u8d25");
        }
        try {
            this.iUmcManageOrgInfoModel.insertOrUpdateManageOrgInfoList(umcManageOrgInfoDos);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7ba1\u7406\u7ec4\u7ec7\u65b0\u589e\u6216\u4fee\u6539\u63a5\u53e3\u5931\u8d25");
            throw new BaseBusinessException("8888", "\u8c03\u7528\u7ba1\u7406\u7ec4\u7ec7\u65b0\u589e\u6216\u4fee\u6539\u63a5\u53e3\u5931\u8d25");
        }
        return new UmcManageOrgInfoSyncTempAddRspBo();
    }

    private void val(UmcOrgInfoSyncTmp umcOrgInfoSyncTempBo) {
        if (null == umcOrgInfoSyncTempBo.getOrgType()) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u673a\u6784\u7c7b\u578b \u5165\u53c2\u4e3a\u7a7a\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        if (null == umcOrgInfoSyncTempBo.getIsCreateDefaultAccount()) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u662f\u5426\u9700\u8981\u521b\u5efa\u9ed8\u8ba4\u8d26\u5957 \u5165\u53c2\u4e3a\u7a7a\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)umcOrgInfoSyncTempBo.getOrgCode())) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u673a\u6784\u7f16\u7801 \u5165\u53c2\u4e3a\u7a7a\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)umcOrgInfoSyncTempBo.getParentCode())) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u4e0a\u7ea7\u673a\u6784\u7f16\u7801 \u5165\u53c2\u4e3a\u7a7a\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)umcOrgInfoSyncTempBo.getOrgName())) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u673a\u6784\u540d\u79f0 \u5165\u53c2\u4e3a\u7a7a\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)umcOrgInfoSyncTempBo.getIsProfess())) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u8eab\u4efd \u5165\u53c2\u4e3a\u7a7a\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        if (umcOrgInfoSyncTempBo.getIsProfess().length() > 3) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u8eab\u4efd \u5165\u53c2\u5b57\u6bb5\u957f\u5ea6\u6700\u5927\u4e3a3\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        for (char c : umcOrgInfoSyncTempBo.getIsProfess().toCharArray()) {
            if (Arrays.asList("0", BK_ORG_CLASS_ORG, BK_ORG_CLASS_DEPART).contains(String.valueOf(c))) continue;
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u8eab\u4efd \u5165\u53c2\u5b57\u6bb5\u503c\u9519\u8bef\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)umcOrgInfoSyncTempBo.getOrgClass())) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u4f01\u4e1a\u7c7b\u522b \u5165\u53c2\u4e3a\u7a7a\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
        } else if (!Arrays.asList(BK_ORG_CLASS_ORG, "4", BK_ORG_CLASS_DEPART).contains(umcOrgInfoSyncTempBo.getOrgClass())) {
            umcOrgInfoSyncTempBo.setDealResult(UmcStatusConstant.SyncDealResult.ERROR_DATA);
            umcOrgInfoSyncTempBo.setDealRemark(StrUtil.format((CharSequence)"\u9519\u8bef\u63cf\u8ff0:{} \u539f\u59cbJSON\u6570\u636e:{}", (Object[])new Object[]{"\u4f01\u4e1a\u7c7b\u522b \u5165\u53c2\u5b57\u6bb5\u503c\u9519\u8bef\uff01", JSON.toJSONString((Object)umcOrgInfoSyncTempBo)}));
        }
    }
}

