/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.projectInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.projectInfo.IUmcProjectInfoModel;
import com.tydic.dyc.umc.model.projectInfo.qrybo.UmcProjectAcceptanceConfigQryBo;
import com.tydic.dyc.umc.model.projectInfo.sub.UmcProjectAcceptanceConfigSubBo;
import com.tydic.dyc.umc.service.projectInfo.UmcBatchAddProjectAcceptanceConfigListService;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcBatchAddProjectAcceptanceConfigListReqBo;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcBatchAddProjectAcceptanceConfigListRspBo;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcProjectAcceptanceConfigBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.projectInfo.UmcBatchAddProjectAcceptanceConfigListService"})
public class UmcBatchAddProjectAcceptanceConfigListServiceImpl
implements UmcBatchAddProjectAcceptanceConfigListService {
    public static final Integer OPER_TYPE_ADD = 1;
    public static final Integer OPER_TYPE_UPDATE = 2;
    public static final Integer OPER_TYPE_DEL = 3;
    @Autowired
    private IUmcProjectInfoModel iUmcProjectInfoModel;

    @PostMapping(value={"batchAddProjectAcceptanceConfigList"})
    public UmcBatchAddProjectAcceptanceConfigListRspBo batchAddProjectAcceptanceConfigList(@RequestBody UmcBatchAddProjectAcceptanceConfigListReqBo reqBo) {
        this.validateParam(reqBo);
        this.delProjectAcceptanceConfig(reqBo);
        List<UmcProjectAcceptanceConfigBo> umcProjectAcceptanceConfigBos = reqBo.getBkUmcProjectAcceptanceConfigBos().stream().filter(e -> !OPER_TYPE_DEL.equals(e.getOperType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(umcProjectAcceptanceConfigBos)) {
            this.isCheckRepeat(umcProjectAcceptanceConfigBos, reqBo);
            ArrayList<UmcProjectAcceptanceConfigSubBo> umcProjectAcceptanceConfigSubBos = new ArrayList<UmcProjectAcceptanceConfigSubBo>();
            for (UmcProjectAcceptanceConfigBo each : umcProjectAcceptanceConfigBos) {
                if (OPER_TYPE_ADD.equals(each.getOperType())) {
                    UmcProjectAcceptanceConfigSubBo addUmcProjectAcceptanceConfigSubBo = UmcRu.js(each, UmcProjectAcceptanceConfigSubBo.class);
                    addUmcProjectAcceptanceConfigSubBo.setProjectId(reqBo.getProjectId());
                    addUmcProjectAcceptanceConfigSubBo.setAcceptanceConfigId(IdUtil.nextId());
                    addUmcProjectAcceptanceConfigSubBo.setUpdateTime(new Date());
                    addUmcProjectAcceptanceConfigSubBo.setUpdateOperId(reqBo.getUserId());
                    addUmcProjectAcceptanceConfigSubBo.setUpdateOperName(reqBo.getName());
                    addUmcProjectAcceptanceConfigSubBo.setCreateTime(new Date());
                    addUmcProjectAcceptanceConfigSubBo.setCreateOperId(reqBo.getUserId());
                    addUmcProjectAcceptanceConfigSubBo.setCreateOperName(reqBo.getName());
                    addUmcProjectAcceptanceConfigSubBo.setDelFlag("0");
                    umcProjectAcceptanceConfigSubBos.add(addUmcProjectAcceptanceConfigSubBo);
                    continue;
                }
                if (!OPER_TYPE_UPDATE.equals(each.getOperType())) continue;
                UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBoWhere = new UmcProjectAcceptanceConfigSubBo();
                umcProjectAcceptanceConfigSubBoWhere.setAcceptanceConfigId(each.getAcceptanceConfigId());
                umcProjectAcceptanceConfigSubBoWhere.setProjectId(each.getProjectId());
                UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBoSet = new UmcProjectAcceptanceConfigSubBo();
                umcProjectAcceptanceConfigSubBoSet.setConfigSystem(each.getConfigSystem());
                umcProjectAcceptanceConfigSubBoSet.setOrderTypeCode(each.getOrderTypeCode());
                umcProjectAcceptanceConfigSubBoSet.setUpdateTime(new Date());
                umcProjectAcceptanceConfigSubBoSet.setUpdateOperId(reqBo.getUserId());
                umcProjectAcceptanceConfigSubBoSet.setUpdateOperName(reqBo.getName());
                umcProjectAcceptanceConfigSubBoSet.setProjectId(reqBo.getProjectId());
                this.iUmcProjectInfoModel.updateProjectAcceptanceConfig(umcProjectAcceptanceConfigSubBoSet, umcProjectAcceptanceConfigSubBoWhere);
            }
            if (!CollectionUtils.isEmpty(umcProjectAcceptanceConfigSubBos)) {
                this.iUmcProjectInfoModel.insertBatchProjectAcceptanceConfigList(umcProjectAcceptanceConfigSubBos);
            }
        }
        return new UmcBatchAddProjectAcceptanceConfigListRspBo();
    }

    private void isCheckRepeat(List<UmcProjectAcceptanceConfigBo> umcProjectAcceptanceConfigBos, UmcBatchAddProjectAcceptanceConfigListReqBo reqBo) {
        Map<String, List<UmcProjectAcceptanceConfigBo>> map = umcProjectAcceptanceConfigBos.stream().collect(Collectors.groupingBy(UmcProjectAcceptanceConfigBo::getOrderTypeCode));
        for (Map.Entry<String, List<UmcProjectAcceptanceConfigBo>> entry : map.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u8ba2\u5355\u7c7b\u578b]\u91cd\u590d");
        }
        UmcProjectAcceptanceConfigQryBo qryUmcProjectAcceptanceConfigQryBo = new UmcProjectAcceptanceConfigQryBo();
        qryUmcProjectAcceptanceConfigQryBo.setProjectId(reqBo.getProjectId());
        List<UmcProjectAcceptanceConfigSubBo> umcProjectAcceptanceConfigQryBos = this.iUmcProjectInfoModel.qryProjectAcceptanceConfigList(qryUmcProjectAcceptanceConfigQryBo);
        List<Object> acceptanceConfigIds = new ArrayList(umcProjectAcceptanceConfigQryBos.size());
        Map<Object, Object> umcProjectAcceptanceConfigSubBoMap = new HashMap(umcProjectAcceptanceConfigQryBos.size());
        if (!CollectionUtils.isEmpty(umcProjectAcceptanceConfigQryBos)) {
            umcProjectAcceptanceConfigSubBoMap = umcProjectAcceptanceConfigQryBos.stream().collect(Collectors.groupingBy(UmcProjectAcceptanceConfigSubBo::getOrderTypeCode, Collectors.collectingAndThen(Collectors.toList(), list -> {
                AtomicReference first = new AtomicReference();
                if (!list.isEmpty()) {
                    first.set(list.get(0));
                }
                return (UmcProjectAcceptanceConfigSubBo)first.get();
            })));
            acceptanceConfigIds = umcProjectAcceptanceConfigQryBos.stream().map(UmcProjectAcceptanceConfigSubBo::getAcceptanceConfigId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(umcProjectAcceptanceConfigSubBoMap) && !CollectionUtils.isEmpty(acceptanceConfigIds)) {
            for (UmcProjectAcceptanceConfigBo each : umcProjectAcceptanceConfigBos) {
                UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBo;
                Set<Object> orderTypeCodeSet = umcProjectAcceptanceConfigSubBoMap.keySet();
                if (OPER_TYPE_ADD.equals(each.getOperType())) {
                    if (!orderTypeCodeSet.contains(each.getOrderTypeCode())) continue;
                    throw new BaseBusinessException("8888", "\u65b0\u589e\u5931\u8d25\u8ba2\u5355\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728");
                }
                if (!OPER_TYPE_UPDATE.equals(each.getOperType())) continue;
                if (!acceptanceConfigIds.contains(each.getAcceptanceConfigId())) {
                    throw new BaseBusinessException("8888", "\u4fee\u6539\u5931\u8d25\uff0c\u9879\u76ee\u9a8c\u6536\u914d\u7f6eid\u4e3a\uff1a" + each.getAcceptanceConfigId() + "\u4e0d\u5b58\u5728");
                }
                if (!orderTypeCodeSet.contains(each.getOrderTypeCode()) || (umcProjectAcceptanceConfigSubBo = (UmcProjectAcceptanceConfigSubBo)umcProjectAcceptanceConfigSubBoMap.get(each.getOrderTypeCode())).getAcceptanceConfigId().equals(each.getAcceptanceConfigId())) continue;
                throw new BaseBusinessException("8888", "\u4fee\u6539\u5931\u8d25\u8ba2\u5355\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728");
            }
        }
    }

    private void delProjectAcceptanceConfig(UmcBatchAddProjectAcceptanceConfigListReqBo reqBo) {
        List<Long> delAcceptanceConfigIds = reqBo.getBkUmcProjectAcceptanceConfigBos().stream().filter(e -> OPER_TYPE_DEL.equals(e.getOperType())).map(UmcProjectAcceptanceConfigBo::getAcceptanceConfigId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(delAcceptanceConfigIds)) {
            UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBoWhere = new UmcProjectAcceptanceConfigSubBo();
            umcProjectAcceptanceConfigSubBoWhere.setProjectId(reqBo.getProjectId());
            umcProjectAcceptanceConfigSubBoWhere.setAcceptanceConfigIds(delAcceptanceConfigIds);
            UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBoSet = new UmcProjectAcceptanceConfigSubBo();
            umcProjectAcceptanceConfigSubBoSet.setUpdateTime(new Date());
            umcProjectAcceptanceConfigSubBoSet.setUpdateOperId(reqBo.getUserId());
            umcProjectAcceptanceConfigSubBoSet.setUpdateOperName(reqBo.getName());
            umcProjectAcceptanceConfigSubBoSet.setProjectId(reqBo.getProjectId());
            umcProjectAcceptanceConfigSubBoSet.setDelFlag("1");
            this.iUmcProjectInfoModel.updateProjectAcceptanceConfig(umcProjectAcceptanceConfigSubBoSet, umcProjectAcceptanceConfigSubBoWhere);
        }
    }

    private void validateParam(UmcBatchAddProjectAcceptanceConfigListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getProjectId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u9879\u76eeid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getBkUmcProjectAcceptanceConfigBos())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u9879\u76ee\u9a8c\u6536\u7cfb\u7edf\u914d\u7f6e]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcProjectAcceptanceConfigBo bkUmcProjectAcceptanceConfigBo : reqBo.getBkUmcProjectAcceptanceConfigBos()) {
            if (!OPER_TYPE_DEL.equals(bkUmcProjectAcceptanceConfigBo.getOperType())) {
                if (StringUtils.isBlank((CharSequence)bkUmcProjectAcceptanceConfigBo.getOrderTypeCode())) {
                    throw new BaseBusinessException("200001", "\u5165\u53c2[\u8ba2\u5355\u7c7b\u578bcode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bkUmcProjectAcceptanceConfigBo.getConfigSystem() == null) {
                    throw new BaseBusinessException("200001", "\u5165\u53c2[\u914d\u7f6e\u7cfb\u7edf]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!OPER_TYPE_DEL.equals(bkUmcProjectAcceptanceConfigBo.getOperType()) && !OPER_TYPE_UPDATE.equals(bkUmcProjectAcceptanceConfigBo.getOperType()) || bkUmcProjectAcceptanceConfigBo.getAcceptanceConfigId() != null) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u9879\u76ee\u9a8c\u6536\u914d\u7f6eid]\u4e0d\u5b58\u5728");
        }
    }
}

