/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.projectInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.projectInfo.IUmcProjectInfoModel;
import com.tydic.dyc.umc.model.projectInfo.qrybo.UmcProjectAcceptanceConfigQryBo;
import com.tydic.dyc.umc.model.projectInfo.sub.UmcProjectAcceptanceConfigSubBo;
import com.tydic.dyc.umc.service.projectInfo.UmcBatchUpdateProjectAcceptanceConfigService;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcBatchUpdateProjectAcceptanceConfigReqBo;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcBatchUpdateProjectAcceptanceConfigRspBo;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcProjectAcceptanceConfigBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.projectInfo.UmcBatchUpdateProjectAcceptanceConfigService"})
public class UmcBatchUpdateProjectAcceptanceConfigServiceImpl
implements UmcBatchUpdateProjectAcceptanceConfigService {
    public static final String ORDER_TYPE_CODE_DEFAULT = "1";
    @Autowired
    private IUmcProjectInfoModel iUmcProjectInfoModel;

    @PostMapping(value={"batchUpdateProjectAcceptanceConfig"})
    public UmcBatchUpdateProjectAcceptanceConfigRspBo batchUpdateProjectAcceptanceConfig(@RequestBody UmcBatchUpdateProjectAcceptanceConfigReqBo reqBo) {
        this.validateParam(reqBo);
        List umcProjectAcceptanceConfigBos = reqBo.getBkUmcProjectAcceptanceConfigBos();
        ArrayList<UmcProjectAcceptanceConfigSubBo> umcProjectAcceptanceConfigSubBos = new ArrayList<UmcProjectAcceptanceConfigSubBo>();
        if (!CollectionUtils.isEmpty((Collection)umcProjectAcceptanceConfigBos)) {
            for (UmcProjectAcceptanceConfigBo each : umcProjectAcceptanceConfigBos) {
                UmcProjectAcceptanceConfigQryBo umcProjectAcceptanceConfigQryBo = new UmcProjectAcceptanceConfigQryBo();
                umcProjectAcceptanceConfigQryBo.setProjectId(each.getProjectId());
                umcProjectAcceptanceConfigQryBo.setOrderTypeCode(each.getOrderTypeCode());
                UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBo = this.iUmcProjectInfoModel.qryProjectAcceptanceConfig(umcProjectAcceptanceConfigQryBo);
                if (umcProjectAcceptanceConfigSubBo != null) {
                    UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBoWhere = new UmcProjectAcceptanceConfigSubBo();
                    umcProjectAcceptanceConfigSubBoWhere.setAcceptanceConfigId(umcProjectAcceptanceConfigSubBo.getAcceptanceConfigId());
                    umcProjectAcceptanceConfigSubBoWhere.setOrderTypeCode(each.getOrderTypeCode());
                    UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBoSet = new UmcProjectAcceptanceConfigSubBo();
                    umcProjectAcceptanceConfigSubBoSet.setConfigSystem(each.getConfigSystem());
                    umcProjectAcceptanceConfigSubBoSet.setUpdateTime(new Date());
                    umcProjectAcceptanceConfigSubBoSet.setUpdateOperId(reqBo.getUserId());
                    umcProjectAcceptanceConfigSubBoSet.setUpdateOperName(reqBo.getName());
                    umcProjectAcceptanceConfigSubBoSet.setProjectId(each.getProjectId());
                    this.iUmcProjectInfoModel.updateProjectAcceptanceConfig(umcProjectAcceptanceConfigSubBoSet, umcProjectAcceptanceConfigSubBoWhere);
                    continue;
                }
                if (ORDER_TYPE_CODE_DEFAULT.equals(each.getOrderTypeCode())) {
                    UmcProjectAcceptanceConfigSubBo addUmcProjectAcceptanceConfigSubBo = UmcRu.js(each, UmcProjectAcceptanceConfigSubBo.class);
                    addUmcProjectAcceptanceConfigSubBo.setAcceptanceConfigId(IdUtil.nextId());
                    addUmcProjectAcceptanceConfigSubBo.setUpdateTime(new Date());
                    addUmcProjectAcceptanceConfigSubBo.setUpdateOperId(reqBo.getUserId());
                    addUmcProjectAcceptanceConfigSubBo.setUpdateOperName(reqBo.getName());
                    addUmcProjectAcceptanceConfigSubBo.setCreateTime(new Date());
                    addUmcProjectAcceptanceConfigSubBo.setCreateOperId(reqBo.getUserId());
                    addUmcProjectAcceptanceConfigSubBo.setCreateOperName(reqBo.getName());
                    addUmcProjectAcceptanceConfigSubBo.setDelFlag("0");
                    umcProjectAcceptanceConfigSubBos.add(addUmcProjectAcceptanceConfigSubBo);
                    continue;
                }
                throw new BaseBusinessException("8888", "\u914d\u7f6e\u5931\u8d25\uff0c\u8ba2\u5355\u7c7b\u578bcode\u4e3a\uff1a" + each.getOrderTypeCode() + "\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            }
        }
        if (!CollectionUtils.isEmpty(umcProjectAcceptanceConfigSubBos)) {
            this.iUmcProjectInfoModel.insertBatchProjectAcceptanceConfigList(umcProjectAcceptanceConfigSubBos);
        }
        return new UmcBatchUpdateProjectAcceptanceConfigRspBo();
    }

    private void validateParam(UmcBatchUpdateProjectAcceptanceConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getBkUmcProjectAcceptanceConfigBos())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[bkUmcProjectAcceptanceConfigBos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcProjectAcceptanceConfigBo bkUmcProjectAcceptanceConfigBo : reqBo.getBkUmcProjectAcceptanceConfigBos()) {
            if (StringUtils.isBlank((CharSequence)bkUmcProjectAcceptanceConfigBo.getOrderTypeCode())) {
                throw new BaseBusinessException("200001", "\u5165\u53c2[\u8ba2\u5355\u7c7b\u578bcode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bkUmcProjectAcceptanceConfigBo.getConfigSystem() == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2[\u914d\u7f6e\u7cfb\u7edf]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bkUmcProjectAcceptanceConfigBo.getProjectId() != null) continue;
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u9879\u76eeid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

