/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.projectInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.projectInfo.IUmcProjectInfoModel;
import com.tydic.dyc.umc.model.projectInfo.UmcProjectInfoDo;
import com.tydic.dyc.umc.model.projectInfo.qrybo.UmcProjectInfoQryBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.projectInfo.UmcQryCostBearingDepartmentListService;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcQryCostBearingDepartmentListReqBo;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcQryCostBearingDepartmentListRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.projectInfo.UmcQryCostBearingDepartmentListService"})
public class UmcQryCostBearingDepartmentListServiceImpl
implements UmcQryCostBearingDepartmentListService {
    @Autowired
    private IUmcProjectInfoModel iUmcProjectInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"qryCostBearingDepartmentList"})
    public UmcQryCostBearingDepartmentListRspBo qryCostBearingDepartmentList(@RequestBody UmcQryCostBearingDepartmentListReqBo reqBo) {
        this.validateParam(reqBo);
        UmcProjectInfoDo umcProjectInfoDo = this.getUmcProjectInfoDo(reqBo);
        UmcOrgInfo orgInfo = this.getUmcOrgInfo(umcProjectInfoDo);
        List<UmcOrgInfoBo> umcOrgInfoBos = this.getUmcOrgInfoBos(reqBo, orgInfo);
        UmcQryCostBearingDepartmentListRspBo rspBo = new UmcQryCostBearingDepartmentListRspBo();
        rspBo.setUmcOrgInfoBos(umcOrgInfoBos);
        return rspBo;
    }

    private List<UmcOrgInfoBo> getUmcOrgInfoBos(UmcQryCostBearingDepartmentListReqBo reqBo, UmcOrgInfo orgInfo) {
        UmcOrgInfoQryBo qryBo = new UmcOrgInfoQryBo();
        qryBo.setCostBearingDepartmentOrgId(orgInfo.getOrgId());
        qryBo.setOrgName(reqBo.getOrgNameWeb());
        qryBo.setOrgStatus(reqBo.getOrgStatus());
        qryBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_DEPARTMENT);
        StrUtil.noNullStringAttr(qryBo);
        UmcOrgInfoRspBo orgInfoList = this.iUmcEnterpriseInfoModel.getOrgInfoList(qryBo);
        List<UmcOrgInfoBo> umcOrgInfoBos = new ArrayList<UmcOrgInfoBo>();
        if (!CollectionUtils.isEmpty((Collection)orgInfoList.getRows())) {
            umcOrgInfoBos = UmcRu.jsl(orgInfoList.getRows(), UmcOrgInfoBo.class);
        }
        return umcOrgInfoBos;
    }

    @NotNull
    private UmcOrgInfo getUmcOrgInfo(UmcProjectInfoDo umcProjectInfoDo) {
        UmcOrgInfoQryBo qryBo = new UmcOrgInfoQryBo();
        StrUtil.noNullStringAttr(qryBo);
        qryBo.setExtOrgCode(umcProjectInfoDo.getPkManageOrgCode());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(qryBo);
        if (orgInfo == null) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u6240\u5c5e\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        return orgInfo;
    }

    @NotNull
    private UmcProjectInfoDo getUmcProjectInfoDo(UmcQryCostBearingDepartmentListReqBo reqBo) {
        UmcProjectInfoQryBo umcProjectInfoQryBo = new UmcProjectInfoQryBo();
        umcProjectInfoQryBo.setId(reqBo.getProjectId());
        umcProjectInfoQryBo.setProjectCode(reqBo.getProjectCode());
        UmcProjectInfoDo umcProjectInfoDo = this.iUmcProjectInfoModel.qryProjectInfo(umcProjectInfoQryBo);
        if (umcProjectInfoDo == null) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)umcProjectInfoDo.getPkManageOrgCode())) {
            throw new BaseBusinessException("200001", "\u9879\u76ee\u6240\u5c5e\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        return umcProjectInfoDo;
    }

    private void validateParam(UmcQryCostBearingDepartmentListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getProjectCode()) && reqBo.getProjectId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u9879\u76eeid]\u548c[\u9879\u76ee\u7f16\u7801]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

