/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.projectInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.projectInfo.IUmcProjectInfoModel;
import com.tydic.dyc.umc.model.projectInfo.qrybo.UmcProjectAcceptanceConfigQryBo;
import com.tydic.dyc.umc.model.projectInfo.sub.UmcProjectAcceptanceConfigSubBo;
import com.tydic.dyc.umc.service.projectInfo.UmcQryProjectAcceptanceConfigInfoListOrderService;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcProjectAcceptanceConfigBo;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcQryProjectAcceptanceConfigInfoListOrderReqBo;
import com.tydic.dyc.umc.service.projectInfo.bo.UmcQryProjectAcceptanceConfigInfoListOrderRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.projectInfo.UmcQryProjectAcceptanceConfigInfoListOrderService"})
public class UmcQryProjectAcceptanceConfigInfoServiceImpl
implements UmcQryProjectAcceptanceConfigInfoListOrderService {
    @Autowired
    private IUmcProjectInfoModel iUmcProjectInfoModel;

    @PostMapping(value={"qryProjectAcceptanceConfigListOrder"})
    public UmcQryProjectAcceptanceConfigInfoListOrderRspBo qryProjectAcceptanceConfigListOrder(@RequestBody UmcQryProjectAcceptanceConfigInfoListOrderReqBo reqBo) {
        this.validateParam(reqBo);
        UmcProjectAcceptanceConfigQryBo umcProjectAcceptanceConfigQryBo = new UmcProjectAcceptanceConfigQryBo();
        umcProjectAcceptanceConfigQryBo.setProjectId(reqBo.getProjectId());
        umcProjectAcceptanceConfigQryBo.setProjectCode(reqBo.getProjectCode());
        ArrayList<String> orderTypeCodeList = new ArrayList<String>();
        orderTypeCodeList.add("1");
        orderTypeCodeList.addAll(reqBo.getOrderTypeCodeList());
        umcProjectAcceptanceConfigQryBo.setOrderTypeCodeList(orderTypeCodeList);
        List<UmcProjectAcceptanceConfigSubBo> umcProjectAcceptanceConfigSubBos = this.iUmcProjectInfoModel.qryProjectAcceptanceRelationProjectList(umcProjectAcceptanceConfigQryBo);
        if (CollectionUtils.isEmpty(umcProjectAcceptanceConfigSubBos)) {
            throw new BaseBusinessException("200001", "\u672a\u914d\u7f6e\u9879\u76ee\u9a8c\u6536\u7cfb\u7edf");
        }
        HashMap<String, Integer> umcProjectAcceptanceConfigMap = new HashMap<String, Integer>(reqBo.getOrderTypeCodeList().size());
        ArrayList<UmcProjectAcceptanceConfigBo> umcProjectAcceptanceConfigBos = new ArrayList<UmcProjectAcceptanceConfigBo>(reqBo.getOrderTypeCodeList().size());
        Map<String, List<UmcProjectAcceptanceConfigSubBo>> umcProjectAcceptanceConfigSubBoMap = umcProjectAcceptanceConfigSubBos.stream().collect(Collectors.groupingBy(UmcProjectAcceptanceConfigSubBo::getOrderTypeCode));
        for (String orderTypeCode : reqBo.getOrderTypeCodeList()) {
            List<UmcProjectAcceptanceConfigSubBo> projectAcceptanceConfigSubBos = umcProjectAcceptanceConfigSubBoMap.get(orderTypeCode);
            UmcProjectAcceptanceConfigBo umcProjectAcceptanceConfigBo = new UmcProjectAcceptanceConfigBo();
            if (CollectionUtils.isEmpty(projectAcceptanceConfigSubBos)) {
                List<UmcProjectAcceptanceConfigSubBo> defaultUmcProjectAcceptanceConfigSubBo = umcProjectAcceptanceConfigSubBoMap.get("1");
                if (CollectionUtils.isEmpty(defaultUmcProjectAcceptanceConfigSubBo)) {
                    throw new BaseBusinessException("200001", "\u672a\u914d\u7f6e\u9ed8\u8ba4\u9879\u76ee\u9a8c\u6536\u7cfb\u7edf");
                }
                umcProjectAcceptanceConfigMap.put(orderTypeCode, defaultUmcProjectAcceptanceConfigSubBo.get(0).getConfigSystem());
                umcProjectAcceptanceConfigBo.setConfigSystem(defaultUmcProjectAcceptanceConfigSubBo.get(0).getConfigSystem());
                umcProjectAcceptanceConfigBo.setOrderTypeName(orderTypeCode);
            } else {
                UmcProjectAcceptanceConfigSubBo umcProjectAcceptanceConfigSubBo = projectAcceptanceConfigSubBos.get(0);
                umcProjectAcceptanceConfigBo = UmcRu.js(umcProjectAcceptanceConfigSubBo, UmcProjectAcceptanceConfigBo.class);
                umcProjectAcceptanceConfigMap.put(orderTypeCode, umcProjectAcceptanceConfigSubBo.getConfigSystem());
            }
            umcProjectAcceptanceConfigBos.add(umcProjectAcceptanceConfigBo);
        }
        UmcQryProjectAcceptanceConfigInfoListOrderRspBo rspBo = new UmcQryProjectAcceptanceConfigInfoListOrderRspBo();
        rspBo.setUmcProjectAcceptanceConfigBos(umcProjectAcceptanceConfigBos);
        rspBo.setUmcProjectAcceptanceConfigMap(umcProjectAcceptanceConfigMap);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateParam(UmcQryProjectAcceptanceConfigInfoListOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getProjectId() == null && StringUtils.isBlank((CharSequence)reqBo.getProjectCode())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u9879\u76eeid]\u6216[\u9879\u76eecode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getOrderTypeCodeList())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2[\u8ba2\u5355\u7c7b\u578bcode\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

