/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectAuthorityInfoDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectDistributeConfigDo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectDistributeConfigListRspBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcProjectDistributeConfigQryBo;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcProjectAuthorityInfoMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcProjectDistributeConfigMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcProjectDistributeConfigRepository;
import com.tydic.dyc.umc.repository.po.extension.BkUmcProjectAuthorityInfoPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcProjectDistributeConfigPO;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUmcProjectDistributeConfigRepositoryImpl
implements BkUmcProjectDistributeConfigRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcProjectDistributeConfigRepositoryImpl.class);
    @Autowired
    private BkUmcProjectDistributeConfigMapper bkUmcProjectDistributeConfigMapper;
    @Autowired
    private BkUmcProjectAuthorityInfoMapper bkUmcProjectAuthorityInfoMapper;
    @Value(value="${configSystem:3}")
    private Integer configSystem;

    public BkUmcProjectDistributeConfigListRspBO queryProjectDistributeConfigList(BkUmcProjectDistributeConfigQryBo qryBo) {
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        BkUmcProjectDistributeConfigPO bkUmcProjectDistributeConfigPO = (BkUmcProjectDistributeConfigPO)UmcRu.js((Object)qryBo, BkUmcProjectDistributeConfigPO.class);
        List<BkUmcProjectDistributeConfigPO> bkUmcProjectDistributeConfigPOS = qryBo.getPageNo() == -1 ? this.bkUmcProjectDistributeConfigMapper.queryProjectDistributeConfigList(bkUmcProjectDistributeConfigPO) : this.bkUmcProjectDistributeConfigMapper.queryProjectDistributeConfigListPage(bkUmcProjectDistributeConfigPO, (Page<BkUmcProjectDistributeConfigPO>)page);
        BkUmcProjectDistributeConfigListRspBO rspBO = new BkUmcProjectDistributeConfigListRspBO();
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bkUmcProjectDistributeConfigPOS) ? UmcRu.jsl(bkUmcProjectDistributeConfigPOS, BkUmcProjectDistributeConfigDo.class) : new ArrayList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void configProjectDistribute(BkUmcProjectDistributeConfigDo modelReqBO) {
        BkUmcProjectDistributeConfigPO updatePO = new BkUmcProjectDistributeConfigPO();
        updatePO.setId(modelReqBO.getId());
        updatePO.setConfigSystem(modelReqBO.getConfigSystem());
        updatePO.setUpdateTime(modelReqBO.getUpdateTime());
        updatePO.setUpdateUserId(modelReqBO.getUpdateUserId());
        updatePO.setUpdateUserName(modelReqBO.getUpdateUserName());
        int i = this.bkUmcProjectDistributeConfigMapper.updateById(updatePO);
        if (i < 1) {
            throw new BaseBusinessException("200100", "\u9879\u76ee\u5206\u914d\uff08\u5355\u4e2a\uff09\u5931\u8d25");
        }
    }

    public void batchConfigProjectDistribute(BkUmcProjectDistributeConfigDo modelReqBO) {
        BkUmcProjectDistributeConfigPO updatePO = new BkUmcProjectDistributeConfigPO();
        updatePO.setIds(modelReqBO.getIds());
        updatePO.setConfigSystem(modelReqBO.getConfigSystem());
        updatePO.setUpdateTime(modelReqBO.getUpdateTime());
        updatePO.setUpdateUserId(modelReqBO.getUpdateUserId());
        updatePO.setUpdateUserName(modelReqBO.getUpdateUserName());
        int i = this.bkUmcProjectDistributeConfigMapper.updateByIds(updatePO);
        if (i < 1) {
            throw new BaseBusinessException("200100", "\u9879\u76ee\u5206\u914d\uff08\u6279\u91cf\uff09\u5931\u8d25");
        }
    }

    public void batchAddProject(List<BkUmcProjectDistributeConfigDo> modelReqBOS) {
        ArrayList<BkUmcProjectDistributeConfigDo> insertProject = new ArrayList<BkUmcProjectDistributeConfigDo>();
        for (BkUmcProjectDistributeConfigDo each : modelReqBOS) {
            BkUmcProjectDistributeConfigPO qryBkUmcProjectDistributeConfigPo = new BkUmcProjectDistributeConfigPO();
            qryBkUmcProjectDistributeConfigPo.setProjectCode(each.getProjectCode());
            BkUmcProjectDistributeConfigPO modelBy = this.bkUmcProjectDistributeConfigMapper.getModelBy(qryBkUmcProjectDistributeConfigPo);
            if (modelBy != null) {
                log.debug("\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u6709\u91cd\u590d\u9879\u76ee\u7f16\u7801\u7684\u6570\u636e\uff1a{}", (Object)modelBy.getProjectCode());
                BkUmcProjectDistributeConfigPO BkUmcProjectDistributeConfigPoWhere = new BkUmcProjectDistributeConfigPO();
                BkUmcProjectDistributeConfigPoWhere.setProjectCode(each.getProjectCode());
                BkUmcProjectDistributeConfigPO BkUmcProjectDistributeConfigPoSet = (BkUmcProjectDistributeConfigPO)UmcRu.js((Object)each, BkUmcProjectDistributeConfigPO.class);
                try {
                    this.bkUmcProjectDistributeConfigMapper.updateBy(BkUmcProjectDistributeConfigPoSet, BkUmcProjectDistributeConfigPoWhere);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u4fee\u6539\u9879\u76ee\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage());
                    throw new BaseBusinessException("200100", "\u4fee\u6539\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
                }
            }
            insertProject.add(each);
        }
        try {
            if (!CollectionUtils.isEmpty(insertProject)) {
                this.batchInsertMethod(insertProject);
            }
        }
        catch (Exception e) {
            log.error("\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5931\u8d25:{}", (Object)e.getMessage());
            throw new BaseBusinessException("200100", "\u9879\u76ee\u65b0\u589e\uff08\u6279\u91cf\uff09\u5931\u8d25");
        }
    }

    public BkUmcProjectDistributeConfigDo queryProjectDistributeConfigDetails(BkUmcProjectDistributeConfigQryBo qryBo) {
        BkUmcProjectDistributeConfigPO bkUmcProjectDistributeConfigPO = (BkUmcProjectDistributeConfigPO)UmcRu.js((Object)qryBo, BkUmcProjectDistributeConfigPO.class);
        BkUmcProjectDistributeConfigPO result = this.bkUmcProjectDistributeConfigMapper.queryProjectDistributeConfigDetails(bkUmcProjectDistributeConfigPO);
        BkUmcProjectDistributeConfigDo bkUmcProjectDistributeConfigDo = new BkUmcProjectDistributeConfigDo();
        if (ObjectUtil.isNotEmpty((Object)result)) {
            BeanUtils.copyProperties((Object)result, (Object)bkUmcProjectDistributeConfigDo);
        }
        return bkUmcProjectDistributeConfigDo;
    }

    public void batchUpdateProject(List<BkUmcProjectDistributeConfigDo> bkUmcProjectDistributeConfigDos) {
        Map<Integer, List<BkUmcProjectDistributeConfigDo>> projectDOMap = bkUmcProjectDistributeConfigDos.stream().collect(Collectors.groupingBy(BkUmcProjectDistributeConfigDo::getChangeType));
        List<BkUmcProjectDistributeConfigDo> insertDOS = projectDOMap.get(BkUmcStatusConstant.changeType.INSERT);
        List<BkUmcProjectDistributeConfigDo> updateDOS = projectDOMap.get(BkUmcStatusConstant.changeType.UPDATE);
        if (ObjectUtil.isNotEmpty(updateDOS)) {
            this.batctUpdateProject(updateDOS);
        }
        if (!CollectionUtils.isEmpty(insertDOS)) {
            this.batchInsertMethod(insertDOS);
            try {
                this.batchInsertMethod(insertDOS);
            }
            catch (Exception e) {
                throw new BaseBusinessException("200100", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u65b0\u589e\u7c7b\u578b\u5931\u8d25");
            }
        }
    }

    private void batctUpdateProject(List<BkUmcProjectDistributeConfigDo> updateDOS) {
        Map<String, List<BkUmcProjectDistributeConfigDo>> updateProjectSourceMap = updateDOS.stream().collect(Collectors.groupingBy(BkUmcProjectDistributeConfigDo::getProjectSource));
        List<BkUmcProjectDistributeConfigDo> updateProjectOriDO = updateProjectSourceMap.get("01");
        List<BkUmcProjectDistributeConfigDo> updateProjectRepDO = updateProjectSourceMap.get("02");
        if (ObjectUtil.isNotEmpty(updateProjectOriDO)) {
            Map<String, List<BkUmcProjectDistributeConfigDo>> projectCodeMap = updateProjectOriDO.stream().collect(Collectors.groupingBy(BkUmcProjectDistributeConfigDo::getProjectCode));
            List<String> projectCodes = updateProjectOriDO.stream().map(BkUmcProjectDistributeConfigDo::getProjectCode).collect(Collectors.toList());
            BkUmcProjectDistributeConfigPO qryPO = new BkUmcProjectDistributeConfigPO();
            qryPO.setProjectCodes(projectCodes);
            List<BkUmcProjectDistributeConfigPO> projectDistributeConfigList = this.bkUmcProjectDistributeConfigMapper.queryProjectDistributeConfigList(qryPO);
            if (ObjectUtil.isNotEmpty(projectDistributeConfigList)) {
                for (BkUmcProjectDistributeConfigPO sourcePO : projectDistributeConfigList) {
                    if (!"01".equals(sourcePO.getProjectSource())) continue;
                    List<BkUmcProjectDistributeConfigDo> bkUmcProjectDistributeConfigDos = projectCodeMap.get(sourcePO.getProjectCode());
                    BkUmcProjectDistributeConfigPO updatePO = (BkUmcProjectDistributeConfigPO)UmcRu.js((Object)bkUmcProjectDistributeConfigDos.get(0), BkUmcProjectDistributeConfigPO.class);
                    updatePO.setId(sourcePO.getId());
                    int i = this.bkUmcProjectDistributeConfigMapper.updateById(updatePO);
                    if (i >= 1) continue;
                    throw new BaseBusinessException("200100", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u66f4\u65b0\u7c7b\u578b\u5931\u8d25");
                }
            }
        }
        if (ObjectUtil.isNotEmpty(updateProjectRepDO)) {
            updateProjectRepDO.forEach(updateDO -> {
                BkUmcProjectDistributeConfigPO updatePO = new BkUmcProjectDistributeConfigPO();
                BeanUtils.copyProperties((Object)updateDO, (Object)updatePO);
                int i = this.bkUmcProjectDistributeConfigMapper.updateByProjectCode(updatePO);
                if (i < 1) {
                    throw new BaseBusinessException("200100", "\u9879\u76ee\u66f4\u65b0\uff08\u6279\u91cf\uff09\u66f4\u65b0\u7c7b\u578b\u5931\u8d25");
                }
            });
        }
    }

    public List<BkUmcProjectDistributeConfigDo> queryAllProjectDistributeConfig(BkUmcProjectDistributeConfigDo modelReqBO) {
        BkUmcProjectDistributeConfigPO bkUmcProjectDistributeConfigPO = (BkUmcProjectDistributeConfigPO)UmcRu.js((Object)modelReqBO, BkUmcProjectDistributeConfigPO.class);
        List<BkUmcProjectDistributeConfigPO> bkUmcProjectDistributeConfigPOS = this.bkUmcProjectDistributeConfigMapper.queryProjectDistributeConfigList(bkUmcProjectDistributeConfigPO);
        return ObjectUtil.isNotEmpty(bkUmcProjectDistributeConfigPOS) ? UmcRu.jsl(bkUmcProjectDistributeConfigPOS, BkUmcProjectDistributeConfigDo.class) : new ArrayList();
    }

    public List<BkUmcProjectDistributeConfigDo> queryProjectStatusDescDropDownList() {
        List<BkUmcProjectDistributeConfigPO> bkUmcProjectDistributeConfigPOS = this.bkUmcProjectDistributeConfigMapper.queryProjectStatusDescDropDownList();
        return ObjectUtil.isNotEmpty(bkUmcProjectDistributeConfigPOS) ? UmcRu.jsl(bkUmcProjectDistributeConfigPOS, BkUmcProjectDistributeConfigDo.class) : new ArrayList();
    }

    public void batchAddProjectAuthority(BkUmcProjectDistributeConfigDo modelReqDO) {
        this.insertNewProjectAuthority(modelReqDO);
    }

    public void batchUpdateProjectAuthority(BkUmcProjectDistributeConfigDo modelReqDO) {
        this.insertNewProjectAuthority(modelReqDO);
    }

    private void insertNewProjectAuthority(BkUmcProjectDistributeConfigDo modelReqDO) {
        int i;
        ArrayList<BkUmcProjectAuthorityInfoPO> insertPOS = new ArrayList<BkUmcProjectAuthorityInfoPO>();
        for (BkUmcProjectAuthorityInfoDO infoDO : modelReqDO.getProjectAuthorityInfos()) {
            BkUmcProjectAuthorityInfoPO qryPO = new BkUmcProjectAuthorityInfoPO();
            qryPO.setProjectCode(infoDO.getProjectCode());
            qryPO.setMasterOrgId(infoDO.getMasterOrgId());
            List<BkUmcProjectAuthorityInfoPO> oldQryPOS = this.bkUmcProjectAuthorityInfoMapper.queryProjectAuthList(qryPO);
            if (!ObjectUtil.isEmpty(oldQryPOS)) continue;
            BkUmcProjectAuthorityInfoPO insterPO = (BkUmcProjectAuthorityInfoPO)UmcRu.js((Object)infoDO, BkUmcProjectAuthorityInfoPO.class);
            insterPO.setId(IdUtil.nextId());
            insertPOS.add(insterPO);
        }
        if (ObjectUtil.isNotEmpty(insertPOS) && (i = this.bkUmcProjectAuthorityInfoMapper.batchInsert(insertPOS)) < 1) {
            throw new BaseBusinessException("200100", "\u65b0\u589e\u9879\u76ee\u6743\u9650\u5931\u8d25");
        }
    }

    public BasePageRspBo<BkUmcProjectDistributeConfigDo> queryProjectAuthorityList(BkUmcProjectDistributeConfigQryBo qryBo) {
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        BkUmcProjectDistributeConfigPO bkUmcProjectDistributeConfigPO = (BkUmcProjectDistributeConfigPO)UmcRu.js((Object)qryBo, BkUmcProjectDistributeConfigPO.class);
        List<BkUmcProjectDistributeConfigPO> bkUmcProjectDistributeConfigPOS = qryBo.getPageNo() == -1 ? this.bkUmcProjectDistributeConfigMapper.queryProjectAuthorityList(bkUmcProjectDistributeConfigPO) : this.bkUmcProjectDistributeConfigMapper.queryProjectAuthorityListPage(bkUmcProjectDistributeConfigPO, (Page<BkUmcProjectDistributeConfigPO>)page);
        BkUmcProjectDistributeConfigListRspBO rspBO = new BkUmcProjectDistributeConfigListRspBO();
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bkUmcProjectDistributeConfigPOS) ? UmcRu.jsl(bkUmcProjectDistributeConfigPOS, BkUmcProjectDistributeConfigDo.class) : new ArrayList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void batchInsertMethod(List<BkUmcProjectDistributeConfigDo> modelReqBOS) {
        List<BkUmcProjectDistributeConfigPO> insertPOS = modelReqBOS.stream().map(modelReqBO -> {
            BkUmcProjectDistributeConfigPO insertPO = new BkUmcProjectDistributeConfigPO();
            BeanUtils.copyProperties((Object)modelReqBO, (Object)insertPO);
            insertPO.setId(IdUtil.nextId());
            return insertPO;
        }).collect(Collectors.toList());
        this.bkUmcProjectDistributeConfigMapper.insertBatch(insertPOS);
    }
}

