/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.baseBo.UmcRspPageBO;
import com.tydic.dyc.umc.repository.dao.UmcDicDictionaryMapper;
import com.tydic.dyc.umc.repository.po.DicDictionaryPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.enterprise.bo.DicDictionaryBO;
import com.tydic.dyc.umc.service.enterprise.bo.DictionaryBusiReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDicDictionaryReqBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="dictionaryBusiService")
public class DictionaryBusiServiceImpl
implements DictionaryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SYS_CODE_DEFAULT = "*";
    private static final Integer DIC_ORDER_ID = 1;
    @Autowired
    private UmcDicDictionaryMapper dicDictionaryMapper;

    public List<DicDictionaryBO> queryBypCodeBackPo(String pCode) {
        return this.queryBypCodeBackPo(null, pCode);
    }

    public List<DicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode) {
        ArrayList<DicDictionaryBO> dicDictionaryBOS = new ArrayList<DicDictionaryBO>();
        List<DicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(this.getDicDictionaryPO(sysCode, pCode));
        if (dicDictionaryPOS != null) {
            for (DicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    public UmcRspPageBO<DicDictionaryBO> queryBypCodeBackPoPage(DictionaryBusiReqBO dictionaryBusiReqBO) {
        DicDictionaryPO dicDictionary = new DicDictionaryPO();
        ArrayList<DicDictionaryBO> rows = new ArrayList<DicDictionaryBO>();
        dicDictionary.setSysCode(dictionaryBusiReqBO.getSysCode());
        dicDictionary.setPCode(dictionaryBusiReqBO.getPcode());
        dicDictionary.setTitle(dictionaryBusiReqBO.getTitle());
        Page page = new Page(dictionaryBusiReqBO.getPageNo().intValue(), dictionaryBusiReqBO.getPageSize().intValue());
        UmcRspPageBO dicDictionaryBOS = new UmcRspPageBO();
        List<DicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListPageByCondition(dicDictionary, page);
        if (dicDictionaryPOS != null) {
            for (DicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                rows.add(dicDictionaryBO);
            }
        }
        dicDictionaryBOS.setRespCode("0000");
        dicDictionaryBOS.setRespDesc("\u67e5\u8be2\u6210\u529f");
        dicDictionaryBOS.setRows(rows);
        dicDictionaryBOS.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        dicDictionaryBOS.setTotal(Integer.valueOf(page.getTotalPages()));
        dicDictionaryBOS.setPageNo(Integer.valueOf(page.getPageNo()));
        return dicDictionaryBOS;
    }

    public List<DicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode, String title) {
        DicDictionaryPO dicDictionary = new DicDictionaryPO();
        dicDictionary.setSysCode(sysCode);
        dicDictionary.setPCode(pCode);
        dicDictionary.setTitle(title);
        if (StringUtils.isEmpty((Object)dicDictionary.getOrderBy())) {
            dicDictionary.setOrderBy("ORDER_ID");
        }
        ArrayList<DicDictionaryBO> dicDictionaryBOS = new ArrayList<DicDictionaryBO>();
        List<DicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(dicDictionary);
        if (dicDictionaryPOS != null) {
            for (DicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    public Map<String, String> queryBypCodeBackMap(String pCode) {
        return this.queryBypCodeBackMap(null, pCode);
    }

    public Map<String, String> queryBypCodeBackMap(String sysCode, String pCode) {
        List<DicDictionaryPO> listPo = this.dicDictionaryMapper.getListByCondition(this.getDicDictionaryPO(sysCode, pCode));
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DicDictionaryPO po : listPo) {
            map.put(po.getCode(), po.getTitle());
        }
        return map;
    }

    public DicDictionaryBO getDictionaryByBO(DicDictionaryBO dicDictionaryBO) {
        DicDictionaryBO dictionaryBO = new DicDictionaryBO();
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)dicDictionaryBO, (Object)dicDictionaryModel);
        DicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dicDictionaryModel);
        if (null != dicDictionaryPO) {
            BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dictionaryBO);
        }
        return dictionaryBO;
    }

    public DicDictionaryPO getDicDictionaryPO(String sysCode, String pCode) {
        DicDictionaryPO queryDictionaryPO = new DicDictionaryPO();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        return queryDictionaryPO;
    }

    public int updateDicDictionary(UmcDicDictionaryReqBO dicDictionaryBO) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    public int addDicDictionary(UmcDicDictionaryReqBO dicDictionaryBO) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(DIC_ORDER_ID);
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.insert(dicDictionaryModel);
    }

    public int deleteDicDictionary(UmcDicDictionaryReqBO dicDictionaryBO) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.deleteByCondition(dicDictionaryModel);
    }

    public int checkDicBy(String code, String pCode) {
        DicDictionaryPO dicDictionaryModel = new DicDictionaryPO();
        dicDictionaryModel.setPCode(pCode);
        dicDictionaryModel.setCode(code);
        return this.dicDictionaryMapper.getCheckBy(dicDictionaryModel);
    }
}

