/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.extension.bo.BkUmcMasterJobDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcMasterJobListQryRspBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcMasterJobQryBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcUserSummaryInfoDO;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoSyncTempMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcMasterJobMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcUserMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcMasterJobRepository;
import com.tydic.dyc.umc.repository.po.UmcCustInfoSyncTempPO;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.extension.BkUmcMasterJobPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcUserSummaryInfoPO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUmcMasterJobRepositoryImpl
implements BkUmcMasterJobRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcMasterJobRepositoryImpl.class);
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private BkUmcUserMapper bkUmcUserMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private UmcCustInfoSyncTempMapper umcCustInfoSyncTempMapper;
    @Autowired
    private BkUmcMasterJobMapper bkUmcMasterJobMapper;

    public List<BkUmcUserSummaryInfoDO> batchAddMasterJob(List<BkUmcMasterJobDO> modelReqBOS) {
        ArrayList<BkUmcMasterJobPO> list = new ArrayList<BkUmcMasterJobPO>();
        ArrayList<BkUmcUserSummaryInfoDO> addList = new ArrayList<BkUmcUserSummaryInfoDO>();
        for (BkUmcMasterJobDO bkUmcMasterJobDO : modelReqBOS) {
            if ("N".equals(bkUmcMasterJobDO.getIsMainJob()) || "false".equals(bkUmcMasterJobDO.getStdDelete()) || ObjectUtil.isNotEmpty((Object)bkUmcMasterJobDO.getEndDate())) continue;
            BkUmcMasterJobPO insertPO = (BkUmcMasterJobPO)UmcRu.js((Object)bkUmcMasterJobDO, BkUmcMasterJobPO.class);
            insertPO.setId(IdUtil.nextId());
            BkUmcUserSummaryInfoPO qryPO = new BkUmcUserSummaryInfoPO();
            qryPO.setExtUserCode(bkUmcMasterJobDO.getMainUserId());
            BkUmcUserSummaryInfoPO umcUserSummaryInfoPO = this.bkUmcUserMapper.queryUserInfoByExtUserCode(qryPO);
            if (ObjectUtil.isNotEmpty((Object)umcUserSummaryInfoPO)) {
                this.updateUseInfo(addList, bkUmcMasterJobDO, insertPO, umcUserSummaryInfoPO);
            }
            list.add(this.updateCustSync(bkUmcMasterJobDO, insertPO));
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.bkUmcMasterJobMapper.insertBatch(list);
        }
        return addList;
    }

    public BkUmcMasterJobListQryRspBO queryMasterJobList(BkUmcMasterJobQryBO qryBO) {
        Page page = new Page();
        BkUmcMasterJobPO qryPO = (BkUmcMasterJobPO)UmcRu.js((Object)qryBO, BkUmcMasterJobPO.class);
        List<BkUmcMasterJobPO> bkUmcMasterJobPOS = this.bkUmcMasterJobMapper.getListPage(qryPO, (Page<BkUmcMasterJobPO>)page);
        BkUmcMasterJobListQryRspBO rspBO = new BkUmcMasterJobListQryRspBO();
        rspBO.setRows(ObjectUtil.isNotEmpty(bkUmcMasterJobPOS) ? UmcRu.jsl(bkUmcMasterJobPOS, BkUmcMasterJobDO.class) : new ArrayList());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    public void dealMasterJob(List<BkUmcMasterJobDO> modelReqBOS) {
        List<Long> ids = modelReqBOS.stream().map(BkUmcMasterJobDO::getId).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(ids)) {
            BkUmcMasterJobPO updatePO = new BkUmcMasterJobPO();
            updatePO.setIds(ids);
            updatePO.setDealResult("PROCESSING");
        }
        for (BkUmcMasterJobDO bkUmcMasterJobDO : modelReqBOS) {
            BkUmcMasterJobPO setPO = new BkUmcMasterJobPO();
            this.updateCustSync(bkUmcMasterJobDO, setPO);
            BkUmcMasterJobPO wherePO = new BkUmcMasterJobPO();
            wherePO.setId(bkUmcMasterJobDO.getId());
            this.bkUmcMasterJobMapper.updateBy(setPO, wherePO);
        }
    }

    public void updateDealResult() {
        BkUmcMasterJobPO setPO = new BkUmcMasterJobPO();
        setPO.setDealResult("PENDING");
        BkUmcMasterJobPO wherePO = new BkUmcMasterJobPO();
        wherePO.setDealResult("NEXT");
        this.bkUmcMasterJobMapper.updateBy(setPO, wherePO);
    }

    private BkUmcMasterJobPO updateCustSync(BkUmcMasterJobDO bkUmcMasterJobDO, BkUmcMasterJobPO insertPO) {
        List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = this.bkUmcUserMapper.queryCustTempListByExtUserCode(bkUmcMasterJobDO.getMainUserId());
        if (ObjectUtil.isNotEmpty(umcCustInfoSyncTempPOS)) {
            List infoSyncTempPOS = umcCustInfoSyncTempPOS.stream().filter(e -> ObjectUtil.isEmpty((Object)e.getOrgCode()) || !bkUmcMasterJobDO.getDeptCode().equals(e.getOrgCode())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(infoSyncTempPOS)) {
                for (UmcCustInfoSyncTempPO umcCustInfoSyncTempPO : infoSyncTempPOS) {
                    UmcCustInfoSyncTempPO updatePO = new UmcCustInfoSyncTempPO();
                    updatePO.setId(umcCustInfoSyncTempPO.getId());
                    updatePO.setOrgCode(bkUmcMasterJobDO.getDeptCode());
                    updatePO.setDealResult(UmcStatusConstant.SyncDealResult.TO_DEAL);
                    int i = this.umcCustInfoSyncTempMapper.updateById(updatePO);
                    if (i >= 1) continue;
                    throw new BaseBusinessException("200100", "\u4fee\u6539\u7528\u6237\u4e34\u65f6\u8868\u673a\u6784\u7f16\u7801\u5931\u8d25");
                }
            }
            insertPO.setDealResult("PROCESSED");
        } else {
            insertPO.setDealResult("NEXT");
        }
        return insertPO;
    }

    private BkUmcMasterJobPO updateUseInfo(List<BkUmcUserSummaryInfoDO> addList, BkUmcMasterJobDO bkUmcMasterJobDO, BkUmcMasterJobPO insertPO, BkUmcUserSummaryInfoPO umcUserSummaryInfoPO) {
        if (!insertPO.getDeptCode().equals(umcUserSummaryInfoPO.getOrgCode())) {
            UmcOrgInfoPo qryOrgPO = new UmcOrgInfoPo();
            qryOrgPO.setOrgCode(bkUmcMasterJobDO.getDeptCode());
            qryOrgPO.setOrgName(bkUmcMasterJobDO.getDeptName());
            UmcOrgInfoPo orgInfoPO = this.umcOrgInfoMapper.getModelBy(qryOrgPO);
            if (ObjectUtil.isNotEmpty((Object)orgInfoPO)) {
                UmcUserInfoPo updatePO = new UmcUserInfoPo();
                updatePO.setUserId(umcUserSummaryInfoPO.getUserId());
                updatePO.setOrgId(orgInfoPO.getOrgId());
                updatePO.setOrgTreePath(orgInfoPO.getOrgTreePath());
                updatePO.setCompanyId(orgInfoPO.getCompanyId());
                this.umcUserInfoMapper.updateById(updatePO);
                addList.add((BkUmcUserSummaryInfoDO)UmcRu.js((Object)updatePO, BkUmcUserSummaryInfoDO.class));
                insertPO.setDealResult("PROCESSED");
            } else {
                insertPO.setDealResult("PENDING");
            }
        } else {
            insertPO.setDealResult("PROCESSED");
        }
        return insertPO;
    }
}

