/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcProjectCostBearingDepartmentMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcProjectDistributeConfigMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcProjectCostBearingDepartmentRepository;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcProjectCostBearingDepartmentPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcProjectDistributeConfigPO;
import com.tydic.dyc.umc.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUmcProjectCostBearingDepartmentRepositoryImpl
implements BkUmcProjectCostBearingDepartmentRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcProjectCostBearingDepartmentRepositoryImpl.class);
    @Autowired
    private BkUmcProjectDistributeConfigMapper bkUmcProjectDistributeConfigMapper;
    @Autowired
    private UmcProjectCostBearingDepartmentMapper umcProjectCostBearingDepartmentMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();

    public void dealProjectCostBearingDepartment() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(CPU + 1, CPU * 2 + 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        int pageNo = 1;
        while (true) {
            BkUmcProjectDistributeConfigPO qryBkUmcProjectDistributeConfigPo = new BkUmcProjectDistributeConfigPO();
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(500);
            List<BkUmcProjectDistributeConfigPO> bkUmcProjectDistributeConfigPos = this.bkUmcProjectDistributeConfigMapper.getListPage(qryBkUmcProjectDistributeConfigPo, (Page<BkUmcProjectDistributeConfigPO>)page);
            if (CollectionUtils.isEmpty(bkUmcProjectDistributeConfigPos)) break;
            int finalPageNo = pageNo++;
            fixedThreadPool.execute(() -> {
                try {
                    ArrayList<UmcProjectCostBearingDepartmentPO> umcProjectCostBearingDepartmentPos = new ArrayList<UmcProjectCostBearingDepartmentPO>();
                    for (BkUmcProjectDistributeConfigPO each : bkUmcProjectDistributeConfigPos) {
                        if (!StringUtils.isNotBlank((CharSequence)each.getPkManageOrgCode())) continue;
                        UmcOrgInfoPo qryUmcOrgInfoPo = new UmcOrgInfoPo();
                        qryUmcOrgInfoPo.setExtOrgCode(each.getPkManageOrgCode());
                        UmcOrgInfoPo umcOrgInfoPo = this.umcOrgInfoMapper.getModelBy(qryUmcOrgInfoPo);
                        if (umcOrgInfoPo == null) {
                            log.error("\u6839\u636e\u9879\u76ee\u6240\u5c5e\u7ba1\u7406\u7ec4\u7ec7\uff0c\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9879\u76ee\u7f16\u7801\u4e3a\uff1a{}", (Object)each.getProjectCode());
                            continue;
                        }
                        UmcOrgInfoPo qryBo = new UmcOrgInfoPo();
                        qryBo.setCostBearingDepartmentOrgId(umcOrgInfoPo.getOrgId());
                        qryBo.setOrgStatus("1");
                        qryBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_DEPARTMENT);
                        qryBo.setOrderBy("o.deep asc limit 100");
                        StrUtil.noNullStringAttr((Object)qryBo);
                        List<UmcOrgInfoPo> umcOrgInfoPoList = this.umcOrgInfoMapper.getAssociationManageOrgInfoList(qryBo);
                        if (CollectionUtils.isEmpty(umcOrgInfoPoList)) {
                            log.error("\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u67e5\u8be2\u4e3a\u7a7a\uff0c\u9879\u76ee\u7f16\u7801\u4e3a\uff1a{}", (Object)each.getProjectCode());
                            continue;
                        }
                        UmcProjectCostBearingDepartmentPO umcProjectCostBearingDepartmentPO = new UmcProjectCostBearingDepartmentPO();
                        umcProjectCostBearingDepartmentPO.setProjectId(each.getId());
                        umcProjectCostBearingDepartmentPO.setProjectCode(each.getProjectCode());
                        umcProjectCostBearingDepartmentPO.setSort(0);
                        for (UmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
                            if (!"2".equals(orgInfoPo.getDepartmentType())) continue;
                            umcProjectCostBearingDepartmentPO.setOrgId(orgInfoPo.getOrgId());
                            umcProjectCostBearingDepartmentPO.setOrgCode(orgInfoPo.getOrgCode());
                            umcProjectCostBearingDepartmentPO.setOrgName(orgInfoPo.getOrgName());
                            umcProjectCostBearingDepartmentPO.setExtOrgCode(orgInfoPo.getExtOrgCode());
                            umcProjectCostBearingDepartmentPO.setDepartmentType(orgInfoPo.getDepartmentType());
                            break;
                        }
                        if (StringUtils.isBlank((CharSequence)umcProjectCostBearingDepartmentPO.getOrgCode())) {
                            for (UmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
                                if (!"1".equals(orgInfoPo.getDepartmentType())) continue;
                                umcProjectCostBearingDepartmentPO.setOrgId(orgInfoPo.getOrgId());
                                umcProjectCostBearingDepartmentPO.setOrgCode(orgInfoPo.getOrgCode());
                                umcProjectCostBearingDepartmentPO.setOrgName(orgInfoPo.getOrgName());
                                umcProjectCostBearingDepartmentPO.setExtOrgCode(orgInfoPo.getExtOrgCode());
                                umcProjectCostBearingDepartmentPO.setDepartmentType(orgInfoPo.getDepartmentType());
                                break;
                            }
                        }
                        if (StringUtils.isBlank((CharSequence)umcProjectCostBearingDepartmentPO.getOrgCode())) {
                            for (UmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
                                if (!"4".equals(orgInfoPo.getDepartmentType())) continue;
                                umcProjectCostBearingDepartmentPO.setOrgId(orgInfoPo.getOrgId());
                                umcProjectCostBearingDepartmentPO.setOrgCode(orgInfoPo.getOrgCode());
                                umcProjectCostBearingDepartmentPO.setOrgName(orgInfoPo.getOrgName());
                                umcProjectCostBearingDepartmentPO.setExtOrgCode(orgInfoPo.getExtOrgCode());
                                umcProjectCostBearingDepartmentPO.setDepartmentType(orgInfoPo.getDepartmentType());
                                break;
                            }
                        }
                        if (StringUtils.isBlank((CharSequence)umcProjectCostBearingDepartmentPO.getOrgCode())) {
                            for (UmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
                                if (!"5".equals(orgInfoPo.getDepartmentType())) continue;
                                umcProjectCostBearingDepartmentPO.setOrgId(orgInfoPo.getOrgId());
                                umcProjectCostBearingDepartmentPO.setOrgCode(orgInfoPo.getOrgCode());
                                umcProjectCostBearingDepartmentPO.setOrgName(orgInfoPo.getOrgName());
                                umcProjectCostBearingDepartmentPO.setExtOrgCode(orgInfoPo.getExtOrgCode());
                                umcProjectCostBearingDepartmentPO.setDepartmentType(orgInfoPo.getDepartmentType());
                                break;
                            }
                        }
                        if (StringUtils.isBlank((CharSequence)umcProjectCostBearingDepartmentPO.getOrgCode())) {
                            for (UmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
                                if (!"3".equals(orgInfoPo.getDepartmentType())) continue;
                                umcProjectCostBearingDepartmentPO.setOrgId(orgInfoPo.getOrgId());
                                umcProjectCostBearingDepartmentPO.setOrgCode(orgInfoPo.getOrgCode());
                                umcProjectCostBearingDepartmentPO.setOrgName(orgInfoPo.getOrgName());
                                umcProjectCostBearingDepartmentPO.setExtOrgCode(orgInfoPo.getExtOrgCode());
                                umcProjectCostBearingDepartmentPO.setDepartmentType(orgInfoPo.getDepartmentType());
                                break;
                            }
                        }
                        if (StringUtils.isBlank((CharSequence)umcProjectCostBearingDepartmentPO.getOrgCode())) {
                            umcProjectCostBearingDepartmentPO.setOrgId(umcOrgInfoPoList.get(0).getOrgId());
                            umcProjectCostBearingDepartmentPO.setOrgCode(umcOrgInfoPoList.get(0).getOrgCode());
                            umcProjectCostBearingDepartmentPO.setOrgName(umcOrgInfoPoList.get(0).getOrgName());
                            umcProjectCostBearingDepartmentPO.setExtOrgCode(umcOrgInfoPoList.get(0).getExtOrgCode());
                            umcProjectCostBearingDepartmentPO.setDepartmentType(umcOrgInfoPoList.get(0).getDepartmentType());
                        }
                        umcProjectCostBearingDepartmentPos.add(umcProjectCostBearingDepartmentPO);
                    }
                    this.umcProjectCostBearingDepartmentMapper.insertBatch(umcProjectCostBearingDepartmentPos);
                }
                catch (Exception e) {
                    log.error("pageNo:{}\u7ec4\u88c5\u5931\u8d25\uff1a{}", (Object)finalPageNo, (Object)e.getMessage());
                }
            });
        }
        fixedThreadPool.shutdown();
    }
}

