/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchAddHaveDoneItemDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchAddHaveDoneMainDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchAddHaveDoneReqDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcQryHaveDoneReqDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcQryHaveDoneRspDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoDo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoListRspBo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoQryBo;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcTodoMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcTodoRepository;
import com.tydic.dyc.umc.repository.po.extension.BkUmcHaveDoneItemPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcHaveDoneMainPO;
import com.tydic.dyc.umc.repository.po.extension.BkUmcTodoPO;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushTodoResultInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQryHaveDoneResultBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUmcTodoRepositoryImpl
implements BkUmcTodoRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcTodoRepositoryImpl.class);
    @Autowired
    private BkUmcTodoMapper bkUmcTodoMapper;
    private static final Integer DEFAULT_DEAL_RESULT = 0;

    public BkUmcTodoListRspBo queryTodoOrDoneList(BkUmcTodoQryBo qryBo) {
        BkUmcTodoListRspBo rspBO = new BkUmcTodoListRspBo();
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        BkUmcTodoPO bkUmcTodoPO = (BkUmcTodoPO)UmcRu.js((Object)qryBo, BkUmcTodoPO.class);
        List<BkUmcTodoPO> bkUmcTodoPOS = this.bkUmcTodoMapper.queryTodoListPage(bkUmcTodoPO, (Page<BkUmcTodoPO>)page);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bkUmcTodoPOS) ? UmcRu.jsl(bkUmcTodoPOS, BkUmcTodoDo.class) : new ArrayList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public List<BkUmcPushTodoResultInfoBO> batchPushTodo(List<BkUmcTodoDo> pushTodoDOS) {
        Date date = new Date();
        List<BkUmcTodoPO> insertPOS = pushTodoDOS.stream().map(bkUmcTodoDo -> {
            BkUmcTodoPO insertPO = new BkUmcTodoPO();
            BeanUtils.copyProperties((Object)bkUmcTodoDo, (Object)insertPO);
            insertPO.setId(IdUtil.nextId());
            insertPO.setTodoStatus(BkUmcStatusConstant.TodoOrDoneStatus.TODO);
            if (null == bkUmcTodoDo.getCreateTime()) {
                insertPO.setCreateTime(date);
            } else {
                insertPO.setCreateTime(bkUmcTodoDo.getCreateTime());
            }
            return insertPO;
        }).collect(Collectors.toList());
        int i = this.bkUmcTodoMapper.batchInsert(insertPOS);
        if (i < 1) {
            throw new BaseBusinessException("200100", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5931\u8d25");
        }
        return insertPOS.stream().map(bkUmcTodoPO -> {
            BkUmcPushTodoResultInfoBO resultInfoBO = new BkUmcPushTodoResultInfoBO();
            resultInfoBO.setTodoId(bkUmcTodoPO.getId());
            resultInfoBO.setCreateUserId(bkUmcTodoPO.getCreateUserId());
            resultInfoBO.setPendingUserId(bkUmcTodoPO.getPendingUserId());
            return resultInfoBO;
        }).collect(Collectors.toList());
    }

    public List<BkUmcTodoDo> pushDone(BkUmcTodoDo modelReqBO) {
        ArrayList<BkUmcTodoDo> list = new ArrayList<BkUmcTodoDo>();
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getBusiId()) && ObjectUtil.isEmpty((Object)modelReqBO.getId())) {
            BkUmcTodoPO qrySource = new BkUmcTodoPO();
            qrySource.setBusiId(modelReqBO.getBusiId());
            qrySource.setTodoStatus(BkUmcStatusConstant.TodoOrDoneStatus.TODO);
            List<BkUmcTodoPO> bkUmcTodoPOS = this.bkUmcTodoMapper.queryTodoList(qrySource);
            if (!CollectionUtils.isEmpty(bkUmcTodoPOS)) {
                List pendingPOS = bkUmcTodoPOS.stream().filter(e -> modelReqBO.getDealUserId().equals(e.getPendingUserId())).collect(Collectors.toList());
                List otherPendingPOS = bkUmcTodoPOS.stream().filter(e -> !modelReqBO.getDealUserId().equals(e.getPendingUserId())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(pendingPOS) && ((BkUmcTodoPO)pendingPOS.get(0)).getCreateTime() != null && ObjectUtil.isNotEmpty(otherPendingPOS)) {
                    otherPendingPOS = otherPendingPOS.stream().filter(e -> ((BkUmcTodoPO)pendingPOS.get(0)).getCreateTime().equals(e.getCreateTime())).collect(Collectors.toList());
                }
                if (ObjectUtil.isNotEmpty(pendingPOS)) {
                    List<Long> todoIds = pendingPOS.stream().map(BkUmcTodoPO::getId).collect(Collectors.toList());
                    BkUmcTodoPO setSource = this.getSetSource(modelReqBO);
                    setSource.setIds(todoIds);
                    int i = this.bkUmcTodoMapper.updateByIds(setSource);
                    if (i < 1) {
                        throw new BaseBusinessException("200100", "\u63a8\u9001\u5df2\u529e\u5931\u8d25");
                    }
                }
                if (ObjectUtil.isNotEmpty(otherPendingPOS)) {
                    List<Long> ids = otherPendingPOS.stream().map(BkUmcTodoPO::getId).collect(Collectors.toList());
                    BkUmcTodoPO dealPO = new BkUmcTodoPO();
                    dealPO.setTodoStatus(BkUmcStatusConstant.TodoOrDoneStatus.CANCEL);
                    dealPO.setIds(ids);
                    int m = this.bkUmcTodoMapper.updateByIds(dealPO);
                    if (m < 1) {
                        throw new BaseBusinessException("200100", "\u63a8\u9001\u5df2\u529e\u5931\u8d25");
                    }
                }
            } else {
                throw new BaseBusinessException("200100", "\u8be5\u4e1a\u52a1\u6d41\u6c34\u4e0b\u4e0d\u5b58\u5728\u5f85\u529e\u4e8b\u52a1");
            }
            BkUmcTodoPO queryPO = new BkUmcTodoPO();
            queryPO.setBusiId(modelReqBO.getBusiId());
            List<BkUmcTodoPO> bkUmcDonePOS = this.bkUmcTodoMapper.queryTodoList(queryPO);
            List bkUmcDoneDOS = UmcRu.jsl(bkUmcDonePOS, BkUmcTodoDo.class);
            list.addAll(bkUmcDoneDOS);
        } else if (ObjectUtil.isNotEmpty((Object)modelReqBO.getId()) && ObjectUtil.isEmpty((Object)modelReqBO.getBusiId())) {
            this.pushDoneById(modelReqBO, list);
        } else if (ObjectUtil.isNotEmpty((Object)modelReqBO.getId()) && ObjectUtil.isNotEmpty((Object)modelReqBO.getBusiId())) {
            this.pushDoneById(modelReqBO, list);
        } else {
            throw new BaseBusinessException("200100", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e0d\u5bf9");
        }
        return list;
    }

    private void pushDoneById(BkUmcTodoDo modelReqBO, List<BkUmcTodoDo> list) {
        BkUmcTodoPO setSource = this.getSetSource(modelReqBO);
        setSource.setId(modelReqBO.getId());
        int i = this.bkUmcTodoMapper.updateById(setSource);
        if (i < 1) {
            throw new BaseBusinessException("200100", "\u63a8\u9001\u5df2\u529e\u5931\u8d25");
        }
        BkUmcTodoPO queryPO = new BkUmcTodoPO();
        queryPO.setId(modelReqBO.getId());
        BkUmcTodoPO bkUmcTodoPOS = this.bkUmcTodoMapper.getModelBy(queryPO);
        if (ObjectUtil.isNotEmpty((Object)bkUmcTodoPOS)) {
            BkUmcTodoDo bkUmcTodoDo = (BkUmcTodoDo)UmcRu.js((Object)bkUmcTodoPOS, BkUmcTodoDo.class);
            list.add(bkUmcTodoDo);
        }
    }

    private BkUmcTodoPO getSetSource(BkUmcTodoDo modelReqBO) {
        BkUmcTodoPO setSource = new BkUmcTodoPO();
        setSource.setDealUserId(modelReqBO.getDealUserId());
        setSource.setDealUserName(modelReqBO.getDealUserName());
        setSource.setDealOrgId(modelReqBO.getDealOrgId());
        setSource.setDealOrgName(modelReqBO.getDealOrgName());
        setSource.setDealCompanyId(modelReqBO.getDealCompanyId());
        setSource.setDealCompanyName(modelReqBO.getDealCompanyName());
        setSource.setDealTime(new Date());
        setSource.setTodoStatus(BkUmcStatusConstant.TodoOrDoneStatus.DONE);
        setSource.setLinkUrl(modelReqBO.getLinkUrl());
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getDealResult())) {
            setSource.setDealResult(modelReqBO.getDealResult());
        } else {
            setSource.setDealResult(DEFAULT_DEAL_RESULT);
        }
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getDealOpinion())) {
            setSource.setDealOpinion(modelReqBO.getDealOpinion());
        }
        return setSource;
    }

    public void batchAddHaveDone(BkUmcBatchAddHaveDoneReqDO reqDO) {
        Serializable po;
        ArrayList<BkUmcHaveDoneMainPO> list;
        String businessId = reqDO.getBusinessId();
        Long haveDoneRelativeId = reqDO.getHaveDoneRelativeId();
        if (!CollectionUtils.isEmpty((Collection)reqDO.getBkUmcBatchAddHaveDoneMainList())) {
            list = new ArrayList<BkUmcHaveDoneMainPO>();
            for (BkUmcBatchAddHaveDoneMainDO doneMainDO : reqDO.getBkUmcBatchAddHaveDoneMainList()) {
                po = new BkUmcHaveDoneMainPO();
                BeanUtils.copyProperties((Object)doneMainDO, (Object)po);
                list.add((BkUmcHaveDoneMainPO)po);
            }
            this.bkUmcTodoMapper.batchInsertHaveDoneMain(list);
        }
        if (!CollectionUtils.isEmpty((Collection)reqDO.getBkUmcBatchAddHaveDoneItemList())) {
            list = new ArrayList();
            for (BkUmcBatchAddHaveDoneItemDO doneItemDO : reqDO.getBkUmcBatchAddHaveDoneItemList()) {
                po = new BkUmcHaveDoneItemPO();
                BeanUtils.copyProperties((Object)doneItemDO, (Object)po);
                list.add((BkUmcHaveDoneMainPO)po);
            }
            this.bkUmcTodoMapper.batchInsertHaveDoneItem(list);
        }
        this.bkUmcTodoMapper.updateHaveDoneRelativeIdByBusinessId(businessId, haveDoneRelativeId);
    }

    public BkUmcQryHaveDoneRspDO qryHaveDoneList(BkUmcQryHaveDoneReqDO reqDO) {
        BkUmcQryHaveDoneRspDO rspDO = new BkUmcQryHaveDoneRspDO();
        List rows = null;
        if (!Objects.isNull(reqDO.getHaveDoneRelativeClass())) {
            BkUmcHaveDoneMainPO po = new BkUmcHaveDoneMainPO();
            po.setHaveDoneRelativeId(reqDO.getHaveDoneRelativeId());
            po.setHaveDoneRelativeClass(reqDO.getHaveDoneRelativeClass());
            po.setObjType(reqDO.getObjType());
            po.setHaveDoneType(reqDO.getHaveDoneType());
            List<BkUmcHaveDoneMainPO> bkUmcHaveDoneMainList = this.bkUmcTodoMapper.qryHaveDoneMainList(po);
            List list = rows = CollectionUtils.isEmpty(bkUmcHaveDoneMainList) ? new ArrayList() : UmcRu.jsl(bkUmcHaveDoneMainList, BkUmcQryHaveDoneResultBO.class);
        }
        if (!Objects.isNull(reqDO.getHaveDoneItemRelativeClass())) {
            Page page = new Page(reqDO.getPageNo().intValue(), reqDO.getPageSize().intValue());
            BkUmcHaveDoneItemPO po = new BkUmcHaveDoneItemPO();
            po.setHaveDoneRelativeId(reqDO.getHaveDoneRelativeId());
            po.setHaveDoneItemRelativeClass(reqDO.getHaveDoneItemRelativeClass());
            po.setObjType(reqDO.getObjType());
            List<BkUmcHaveDoneItemPO> bkUmcHaveDoneItemList = this.bkUmcTodoMapper.qryHaveDoneItemList(po, (Page<BkUmcHaveDoneItemPO>)page);
            rows = CollectionUtils.isEmpty(bkUmcHaveDoneItemList) ? new ArrayList() : UmcRu.jsl(bkUmcHaveDoneItemList, BkUmcQryHaveDoneResultBO.class);
            rspDO.setPageNo(page.getPageNo());
            rspDO.setTotal(page.getTotalPages());
            rspDO.setRecordsTotal(page.getTotalCount());
        }
        rspDO.setRows(rows);
        rspDO.setRespCode("0000");
        rspDO.setRespDesc("\u6210\u529f");
        return rspDO;
    }

    public BkUmcTodoDo queryTodoDetails(BkUmcTodoDo qryBO) {
        BkUmcTodoPO qryPO = (BkUmcTodoPO)UmcRu.js((Object)qryBO, BkUmcTodoPO.class);
        BkUmcTodoPO bkUmcTodoPO = this.bkUmcTodoMapper.getModelBy(qryPO);
        return (BkUmcTodoDo)UmcRu.js((Object)bkUmcTodoPO, BkUmcTodoDo.class);
    }
}

