/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.extension.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryUserInfoModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcUserSummaryInfoDO;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserInfoDos;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoSyncTempMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserExtMapMapper;
import com.tydic.dyc.umc.repository.dao.extension.BkUmcUserMapper;
import com.tydic.dyc.umc.repository.extension.BkUmcUserRepository;
import com.tydic.dyc.umc.repository.po.UmcCustInfoSyncTempPO;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.extension.BkUmcUserSummaryInfoPO;
import com.tydic.dyc.umc.service.extension.bo.BatchQueryInnerUserPartTimeJobReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoReqBO;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUmcUserRepositoryImpl
implements BkUmcUserRepository {
    private static final Logger log = LoggerFactory.getLogger(BkUmcUserRepositoryImpl.class);
    @Autowired
    private BkUmcUserMapper bkUmcUserMapper;
    @Autowired
    private UmcUserExtMapMapper umcUserExtMapMapper;
    @Autowired
    private UmcCustInfoSyncTempMapper umcCustInfoSyncTempMapper;

    public List<BkUmcUserSummaryInfoDO> batchQueryUserInfo(BkUmcBatchQueryUserInfoModelReqBO modelReqBO) {
        List<BkUmcUserSummaryInfoPO> bkUmcUserSummaryInfoPOS = new ArrayList<BkUmcUserSummaryInfoPO>();
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getUserIds())) {
            bkUmcUserSummaryInfoPOS.addAll(this.bkUmcUserMapper.batchQueryUserInfoByUserId(modelReqBO.getUserIds()));
        }
        if (ObjectUtil.isNotEmpty((Object)modelReqBO.getUserCodes())) {
            bkUmcUserSummaryInfoPOS.addAll(this.bkUmcUserMapper.batchQueryUserInfoByUserCode(modelReqBO.getUserCodes()));
        }
        if (ObjectUtil.isNotEmpty(bkUmcUserSummaryInfoPOS)) {
            bkUmcUserSummaryInfoPOS = bkUmcUserSummaryInfoPOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BkUmcUserSummaryInfoPO>(Comparator.comparing(BkUmcUserSummaryInfoPO::getUserId))), ArrayList::new));
        }
        return bkUmcUserSummaryInfoPOS.stream().map(bkUmcUserSummaryInfoPO -> {
            BkUmcUserSummaryInfoDO bkUmcUserSummaryInfoDO = new BkUmcUserSummaryInfoDO();
            BeanUtils.copyProperties((Object)bkUmcUserSummaryInfoPO, (Object)bkUmcUserSummaryInfoDO);
            BkUmcUserSummaryInfoPO qryPO = new BkUmcUserSummaryInfoPO();
            qryPO.setMainCustId(bkUmcUserSummaryInfoPO.getMainCustId());
            BkUmcUserSummaryInfoPO modelBy = this.bkUmcUserMapper.qryExtUserCode(qryPO);
            if (ObjectUtil.isNotEmpty((Object)modelBy)) {
                bkUmcUserSummaryInfoDO.setExtUserCode(modelBy.getExtUserCode());
            }
            return bkUmcUserSummaryInfoDO;
        }).collect(Collectors.toList());
    }

    public List<BkUmcUserSummaryInfoDO> batchQueryUserIdentityList(BkUmcBatchQueryUserInfoReqBO modelReqBO) {
        List<BkUmcUserSummaryInfoPO> bkUmcUserSummaryInfoPOS = this.bkUmcUserMapper.batchQueryUserIdentityList(modelReqBO.getUserIds());
        return ObjectUtil.isNotEmpty(bkUmcUserSummaryInfoPOS) ? UmcRu.jsl(bkUmcUserSummaryInfoPOS, BkUmcUserSummaryInfoDO.class) : new ArrayList();
    }

    public List<BkUmcUserSummaryInfoDO> batchQueryInnerUserPartTimeJobInfo(BatchQueryInnerUserPartTimeJobReqBO reqBO) {
        List<BkUmcUserSummaryInfoPO> bkUmcUserSummaryInfoPOS = this.bkUmcUserMapper.batchQueryInnerUserPartTimeJobInfo(reqBO.getCustIds(), reqBO.getOrgIdWeb(), reqBO.getOrgName());
        return ObjectUtil.isNotEmpty(bkUmcUserSummaryInfoPOS) ? UmcRu.jsl(bkUmcUserSummaryInfoPOS, BkUmcUserSummaryInfoDO.class) : new ArrayList();
    }

    public void updateCustTempOrgCode(List<BkUmcUserSummaryInfoDO> modelReqBOS) {
        for (BkUmcUserSummaryInfoDO bkUmcUserSummaryInfoDO : modelReqBOS) {
            List infoSyncTempPOS;
            List<UmcCustInfoSyncTempPO> umcCustInfoSyncTempPOS = this.bkUmcUserMapper.queryCustTempListByExtUserCode(bkUmcUserSummaryInfoDO.getExtUserCode());
            if (!ObjectUtil.isNotEmpty(umcCustInfoSyncTempPOS) || !ObjectUtil.isNotEmpty(infoSyncTempPOS = umcCustInfoSyncTempPOS.stream().filter(e -> ObjectUtil.isEmpty((Object)e.getOrgCode()) || !bkUmcUserSummaryInfoDO.getOrgCode().equals(e.getOrgCode())).collect(Collectors.toList()))) continue;
            for (UmcCustInfoSyncTempPO umcCustInfoSyncTempPO : infoSyncTempPOS) {
                UmcCustInfoSyncTempPO updatePO = new UmcCustInfoSyncTempPO();
                updatePO.setId(umcCustInfoSyncTempPO.getId());
                updatePO.setOrgCode(bkUmcUserSummaryInfoDO.getOrgCode());
                updatePO.setDealResult(UmcStatusConstant.SyncDealResult.TO_DEAL);
                int i = this.umcCustInfoSyncTempMapper.updateById(updatePO);
                if (i >= 1) continue;
                throw new BaseBusinessException("200100", "\u4fee\u6539\u7528\u6237\u4e34\u65f6\u8868\u673a\u6784\u7f16\u7801\u5931\u8d25");
            }
        }
    }

    public UmcUserInfoDos getUserInfoPageList(UmcUserInfoQryBo qryBo) {
        UmcUserInfoPo umcUserInfoPo = (UmcUserInfoPo)UmcRu.js((Object)qryBo, UmcUserInfoPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        if (null != qryBo.getCustInfo()) {
            umcUserInfoPo.setRegAccount(qryBo.getCustInfo().getRegAccount());
            umcUserInfoPo.setRegMobile(qryBo.getCustInfo().getRegMobile());
            umcUserInfoPo.setCustName(qryBo.getCustInfo().getCustName());
            umcUserInfoPo.setCustExtField10(qryBo.getCustInfo().getCustType());
        }
        StrUtil.noNullStringAttr((Object)umcUserInfoPo);
        List<UmcUserInfoDo> umcUserInfoDoList = this.bkUmcUserMapper.getUserListPage(umcUserInfoPo, (Page<UmcUserInfoPo>)page);
        if (!CollectionUtils.isEmpty(umcUserInfoDoList)) {
            List<Long> notMainList = umcUserInfoDoList.stream().filter(a -> "0".equals(a.getIsMain())).map(UmcUserInfoDo::getCustId).collect(Collectors.toList());
            List<Object> custList = new ArrayList();
            if (CollectionUtil.isNotEmpty(notMainList)) {
                custList = this.bkUmcUserMapper.getCustList(notMainList);
            }
            for (UmcUserInfoDo row : umcUserInfoDoList) {
                if (CollectionUtil.isNotEmpty(custList)) {
                    for (UmcUserInfoDo umcUserInfoDo : custList) {
                        if (!row.getCustId().equals(umcUserInfoDo.getCustId())) continue;
                        row.setUserId(umcUserInfoDo.getUserId());
                        row.setOrgId(umcUserInfoDo.getOrgId());
                        row.setOrgTreePath(umcUserInfoDo.getOrgTreePath());
                        row.setIsMain(umcUserInfoDo.getIsMain());
                        row.setUserType(umcUserInfoDo.getUserType());
                        row.setStopStatus(umcUserInfoDo.getStopStatus());
                        row.setOrgName(umcUserInfoDo.getOrgName());
                        row.setUserTagRel(umcUserInfoPo.getUserTagRel());
                        row.setOrgTagRel(umcUserInfoDo.getOrgTagRel());
                    }
                }
                if (StringUtils.isEmpty((CharSequence)row.getUserTagRel())) continue;
                List<String> userTagRels = Arrays.asList(row.getUserTagRel().split(","));
                List list = userTagRels.stream().map(item -> {
                    UmcUserTagRel userTagRel = new UmcUserTagRel();
                    userTagRel.setUserId(row.getUserId());
                    userTagRel.setTagId(item);
                    return userTagRel;
                }).collect(Collectors.toList());
                row.setUserTagRelList(list);
            }
        }
        UmcUserInfoDos rspBo = new UmcUserInfoDos();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(umcUserInfoDoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

