/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.extension.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpRequest;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.common.extension.api.BkBatchPushTodoFunction;
import com.tydic.dyc.atom.common.extension.bo.BkBatchPushTodoReqBO;
import com.tydic.dyc.atom.common.extension.bo.BkBatchPushTodoRspBO;
import com.tydic.dyc.atom.common.extension.bo.BkPushTodoResultInfoBO;
import com.tydic.dyc.atom.common.extension.bo.NotifyBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.api.BkUmcTodoService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushTodoInfoBO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class BkBatchPushTodoFunctionImpl
implements BkBatchPushTodoFunction {
    private static final Logger log = LoggerFactory.getLogger(BkBatchPushTodoFunctionImpl.class);
    @Value(value="${toDo.sendUrl:http://101.201.150.239:8001/ws/uptodoinfo?v1}")
    private String sendUrl;
    @Value(value="${toDo.sysCode:T0059}")
    private String sysCode;
    @Value(value="${toDo.status:true}")
    private Boolean status;
    @Autowired
    private BkUmcTodoService bkUmcTodoService;

    @Override
    public BkBatchPushTodoRspBO batchPushTodo(BkBatchPushTodoReqBO reqBO) {
        this.verifyParam(reqBO);
        List bkUmcPushTodoInfoBOS = reqBO.getTodoInfos().stream().map(bkPushTodoInfoBO -> {
            BkUmcPushTodoInfoBO bkUmcPushTodoInfoBO = new BkUmcPushTodoInfoBO();
            BeanUtils.copyProperties((Object)bkPushTodoInfoBO, (Object)bkUmcPushTodoInfoBO);
            return bkUmcPushTodoInfoBO;
        }).collect(Collectors.toList());
        BkUmcBatchPushTodoReqBO abilityReqBO = new BkUmcBatchPushTodoReqBO();
        abilityReqBO.setTodoInfos(bkUmcPushTodoInfoBOS);
        BkUmcBatchPushTodoRspBO abilityRspBO = this.bkUmcTodoService.batchPushTodo(abilityReqBO);
        if ("0000".equals(abilityRspBO.getRespCode())) {
            BkBatchPushTodoRspBO rspBO = new BkBatchPushTodoRspBO();
            List<BkPushTodoResultInfoBO> resultInfo = abilityRspBO.getResultInfo().stream().map(bkUmcPushTodoResultInfoBO -> {
                BkPushTodoResultInfoBO bkPushTodoResultInfoBO = new BkPushTodoResultInfoBO();
                BeanUtils.copyProperties((Object)bkUmcPushTodoResultInfoBO, (Object)bkPushTodoResultInfoBO);
                return bkPushTodoResultInfoBO;
            }).collect(Collectors.toList());
            if (this.status.booleanValue()) {
                Map<String, Long> PendingUserIdAndTodoIdMap = resultInfo.stream().collect(Collectors.toMap(BkPushTodoResultInfoBO::getPendingUserId, BkPushTodoResultInfoBO::getTodoId));
                List<Map<String, String>> mapList = reqBO.getTodoInfos().stream().map(bkPushTodoInfoBO -> {
                    NotifyBO notifyBO = new NotifyBO();
                    notifyBO.setUniid(((Long)PendingUserIdAndTodoIdMap.get(bkPushTodoInfoBO.getPendingUserId())).toString());
                    notifyBO.setTitle(bkPushTodoInfoBO.getTodoEvent());
                    notifyBO.setUrl(bkPushTodoInfoBO.getLinkUrl());
                    notifyBO.setOwner(bkPushTodoInfoBO.getPendingUserId());
                    notifyBO.setCreated(DateUtils.dateToStrLong((Date)new Date()));
                    notifyBO.setType(BkUmcStatusConstant.TodoOrDoneStatus.TODO.toString());
                    notifyBO.setStatus(BkUmcStatusConstant.TodoOrDoneStatus.TODO.toString());
                    HashMap map = new HashMap();
                    BeanUtil.copyProperties((Object)notifyBO, map);
                    return map;
                }).collect(Collectors.toList());
                String xml = this.formatDataToXml(mapList);
                log.info("\u5f85\u529e\u8c03\u7528\u5730\u5740\uff1a{}", (Object)this.sendUrl);
                log.info("\u5f85\u529e\u7ec4\u88c5\u5165\u53c2\uff1a{}", (Object)xml);
                try {
                    String body = HttpRequest.post((String)this.sendUrl).body(xml).timeout(10000).execute().body();
                    log.info("\u8c03\u7528\u5f85\u529e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)body);
                    Document document = XmlUtil.parseXml((String)body);
                    NodeList success = document.getElementsByTagName("code");
                    Node item = success.item(0);
                    String textContent = item.getTextContent();
                    if (!"0".equals(textContent)) {
                        log.error("\u53d1\u9001\u5f85\u529e\u6d88\u606f\u5931\u8d25");
                    }
                }
                catch (Exception exception) {
                    log.error("\u53d1\u9001\u5f85\u529e\u6d88\u606f\u5931\u8d25" + exception.getMessage());
                }
            }
            rspBO.setResultInfo(resultInfo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new ZTBusinessException("\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + abilityRspBO.getRespCode() + "\u3011," + abilityRspBO.getRespDesc());
    }

    private void verifyParam(BkBatchPushTodoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getTodoInfos())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        reqBO.getTodoInfos().forEach(bkPushTodoInfoBO -> {
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoType())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoType]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getBelongModule())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[belongModule]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoEvent())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoEvent]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getLinkUrl())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[linkUrl]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateUserId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createUserId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateUserName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateUserPhone())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createUserPhone]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateOrgId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createOrgId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateOrgId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createOrgName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateCompanyId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createCompanyId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateCompanyId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createCompanyName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingCompanyId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingCompanyId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingCompanyId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingCompanyName]\u4e3a\u7a7a");
            }
        });
    }

    public String formatDataToXml(List<Map<String, String>> mapList) {
        StringBuilder xml = new StringBuilder();
        xml.append("<todo_list>");
        xml.append("<header>");
        xml.append("<syscode>");
        xml.append(this.sysCode);
        xml.append("</syscode>");
        xml.append("</header>");
        for (Map<String, String> mapdData : mapList) {
            xml.append("<todo_info>");
            if (mapdData != null) {
                Set<Map.Entry<String, String>> set = mapdData.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    if (null == entry.getValue()) continue;
                    xml.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
                }
            }
            xml.append("</todo_info>");
        }
        xml.append("</todo_list>");
        return xml.toString();
    }
}

