/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.extension.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpRequest;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.common.extension.api.BkPushDoneFunction;
import com.tydic.dyc.atom.common.extension.bo.BkPushDoneReqBO;
import com.tydic.dyc.atom.common.extension.bo.BkPushDoneRspBO;
import com.tydic.dyc.atom.common.extension.bo.NotifyBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.api.BkUmcTodoService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneRspBO;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class BkPushDoneFunctionImpl
implements BkPushDoneFunction {
    private static final Logger log = LoggerFactory.getLogger(BkPushDoneFunctionImpl.class);
    @Value(value="${toDo.sendUrl:http://101.201.150.239:8001/ws/uptodoinfo?v1}")
    private String sendUrl;
    @Value(value="${toDo.sysCode:T0059}")
    private String sysCode;
    @Value(value="${toDo.status:true}")
    private Boolean status;
    @Autowired
    private BkUmcTodoService bkUmcTodoService;

    @Override
    public BkPushDoneRspBO pushDone(BkPushDoneReqBO reqBO) {
        this.verifyParam(reqBO);
        BkUmcPushDoneReqBO abilityReqBO = new BkUmcPushDoneReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)abilityReqBO);
        BkUmcPushDoneRspBO abilityRspBO = this.bkUmcTodoService.pushDone(abilityReqBO);
        if ("0000".equals(abilityRspBO.getRespCode())) {
            if (this.status.booleanValue()) {
                List<Map<String, String>> mapList = abilityRspBO.getTodoInfos().stream().map(bkUmcPushDoneInfoBO -> {
                    NotifyBO notifyBO = new NotifyBO();
                    notifyBO.setUniid(bkUmcPushDoneInfoBO.getId().toString());
                    notifyBO.setTitle(bkUmcPushDoneInfoBO.getTodoEvent());
                    notifyBO.setUrl(bkUmcPushDoneInfoBO.getLinkUrl());
                    notifyBO.setOwner(bkUmcPushDoneInfoBO.getPendingUserId());
                    notifyBO.setCreated(DateUtils.dateToStrLong((Date)new Date()));
                    notifyBO.setType(BkUmcStatusConstant.TodoOrDoneStatus.DONE.toString());
                    notifyBO.setStatus(BkUmcStatusConstant.TodoOrDoneStatus.DONE.toString());
                    HashMap map = new HashMap();
                    BeanUtil.copyProperties((Object)notifyBO, map);
                    return map;
                }).collect(Collectors.toList());
                String xml = this.formatDataToXml(mapList);
                log.info("\u5df2\u529e\u8c03\u7528\u5730\u5740\uff1a{}", (Object)this.sendUrl);
                log.info("\u5df2\u529e\u7ec4\u88c5\u5165\u53c2\uff1a{}", (Object)xml);
                try {
                    String body = HttpRequest.post((String)this.sendUrl).body(xml).timeout(10000).execute().body();
                    log.info("\u8c03\u7528\u5df2\u529e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)body);
                    Document document = XmlUtil.parseXml((String)body);
                    NodeList success = document.getElementsByTagName("code");
                    Node item = success.item(0);
                    String textContent = item.getTextContent();
                    if (!"0".equals(textContent)) {
                        log.error("\u53d1\u9001\u5df2\u529e\u6d88\u606f\u5931\u8d25");
                    }
                }
                catch (Exception exception) {
                    log.error("\u53d1\u9001\u5df2\u529e\u6d88\u606f\u5931\u8d25" + Arrays.toString(exception.getStackTrace()));
                }
            }
            BkPushDoneRspBO rspBO = new BkPushDoneRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new ZTBusinessException("\u63a8\u9001\u5df2\u529e\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + abilityRspBO.getRespCode() + "\u3011," + abilityRspBO.getRespDesc());
    }

    private void verifyParam(BkPushDoneReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId()) && ObjectUtil.isEmpty((Object)reqBO.getBusiId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealUserId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2[dealUserId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealUserName())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2[dealUserName]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealOrgId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2[dealOrgId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealOrgName())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2[dealOrgName]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealCompanyId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2[dealCompanyId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getDealCompanyName())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2[dealCompanyName]\u4e3a\u7a7a");
        }
    }

    public String formatDataToXml(List<Map<String, String>> mapList) {
        StringBuilder xml = new StringBuilder();
        xml.append("<todo_list>");
        xml.append("<header>");
        xml.append("<syscode>");
        xml.append(this.sysCode);
        xml.append("</syscode>");
        xml.append("</header>");
        for (Map<String, String> mapdData : mapList) {
            xml.append("<todo_info>");
            if (mapdData != null) {
                Set<Map.Entry<String, String>> set = mapdData.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    if (null == entry.getValue()) continue;
                    xml.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
                }
            }
            xml.append("</todo_info>");
        }
        xml.append("</todo_list>");
        return xml.toString();
    }
}

