/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.shopcart;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.shopcart.bo.UmcExportImportResultsReqBO;
import com.tydic.dyc.umc.service.shopcart.bo.UmcExportImportResultsRspBO;
import com.tydic.dyc.umc.service.shopcart.service.UmcExportImportResultService;
import com.tydic.dyc.umc.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.shopcart.service.UmcExportImportResultService"})
public class UscExportImportResultsServiceImpl
implements UmcExportImportResultService {
    private static final Logger log = LoggerFactory.getLogger(UscExportImportResultsServiceImpl.class);
    @Value(value="${plugin.file.type:OSS}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${oss.accessUrl:http://liando-mall-uat.oss-cn-beijing.aliyuncs.com/}")
    private String preFilePath;
    @Value(value="${oss.fileUrl:http://10.0.11.61:8060/downloadFile/}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:8888}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:10.31.145.177:22122}")
    private String fastdfsTrackerSeurlrvers;
    @Value(value="${export.file.public.url:http://service-download-spring-boot:8080}")
    private String exportFilePublicUrl;

    @PostMapping(value={"importExportLog"})
    public UmcExportImportResultsRspBO importExportLog(@RequestBody UmcExportImportResultsReqBO reqBO) {
        UmcExportImportResultsRspBO rspBO = new UmcExportImportResultsRspBO();
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        ArrayList Data = new ArrayList();
        int index = 0;
        for (Map map : reqBO.getImportDataMaps()) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", ++index);
            item.put("\u5546\u54c1\u7f16\u7801", map.get("skuCode") != null ? map.get("skuCode") : "");
            item.put("\u5546\u54c1\u6570\u91cf", map.get("productAmount") != null ? map.get("productAmount") : "");
            Integer impResult = (Integer)map.get("impResult");
            if (impResult != null) {
                if ("0".equals(impResult.toString())) {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                    item.put("\u5931\u8d25\u539f\u56e0", "");
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                    item.put("\u5931\u8d25\u539f\u56e0", map.get("impRemark") != null ? map.get("impRemark") : "");
                    exportData.add(item);
                }
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
                exportData.add(item);
            }
            LinkedHashMap copyItem = new LinkedHashMap(item);
            Data.add(copyItem);
        }
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = this.preFilePath + rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setExportData(Data);
        rspBO.setFullFilePath(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efaexcel \u6570\u636e\u6210\u529f!");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, UmcExportImportResultsRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createImportWorkbook(data, "\u8054\u4e1c\u5546\u54c1\u5bfc\u5165");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "usc";
        String fileName = UUID.randomUUID() + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BaseBusinessException("200100", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

