/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.api.BkUmcAddressModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcAddressDO;
import com.tydic.dyc.umc.service.extension.api.BkUmcAddressService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcVerifyAddressInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcVerifyProvinceCityAddressReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcVerifyProvinceCityAddressRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcAddressService"})
public class BkUmcAddressServiceImpl
implements BkUmcAddressService {
    @Autowired
    private BkUmcAddressModel bkUmcAddressModel;

    @PostMapping(value={"verifyProvinceCityAddress"})
    public BkUmcVerifyProvinceCityAddressRspBO verifyProvinceCityAddress(@RequestBody BkUmcVerifyProvinceCityAddressReqBO reqBO) {
        this.validVerifyProvinceCityAddressData(reqBO);
        BkUmcVerifyProvinceCityAddressRspBO rspBO = (BkUmcVerifyProvinceCityAddressRspBO)UmcRu.success(BkUmcVerifyProvinceCityAddressRspBO.class);
        List<BkUmcAddressDO> bkUmcAddressDOS = reqBO.getAddressList().stream().map(address -> {
            BkUmcAddressDO bkUmcAddressDO = new BkUmcAddressDO();
            bkUmcAddressDO.setProvinceName(address.getProvinceName());
            bkUmcAddressDO.setCityName(address.getCityName());
            return bkUmcAddressDO;
        }).collect(Collectors.toList());
        List<BkUmcAddressDO> resultList = this.bkUmcAddressModel.verifyProvinceCityAddress(bkUmcAddressDOS);
        List bkUmcVerifyAddressInfoBO = UmcRu.jsl(resultList, BkUmcVerifyAddressInfoBO.class);
        rspBO.setResult(bkUmcVerifyAddressInfoBO);
        return rspBO;
    }

    private void validVerifyProvinceCityAddressData(BkUmcVerifyProvinceCityAddressReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAddressList())) {
            throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        reqBO.getAddressList().forEach(address -> {
            if (ObjectUtil.isEmpty((Object)address.getProvinceName())) {
                throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2[ProvinceName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)address.getCityName())) {
                throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2[CityName]\u4e3a\u7a7a");
            }
        });
    }
}

