/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.api.BkUmcAddressModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcAddressDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcAddressInfoDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryProvinceCityAreaCountyModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryProvinceCityAreaCountyModelRspBO;
import com.tydic.dyc.umc.service.extension.api.BkUmcAddressService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcAddressInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryProvinceCityAreaCountyReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryProvinceCityAreaCountyRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAddressTreeReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAddressTreeRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcVerifyAddressInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcVerifyProvinceCityAddressReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcVerifyProvinceCityAddressRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcAddressService"})
public class BkUmcAddressServiceImpl
implements BkUmcAddressService {
    @Autowired
    private BkUmcAddressModel bkUmcAddressModel;

    @PostMapping(value={"verifyProvinceCityAddress"})
    public BkUmcVerifyProvinceCityAddressRspBO verifyProvinceCityAddress(@RequestBody BkUmcVerifyProvinceCityAddressReqBO reqBO) {
        this.validVerifyProvinceCityAddressData(reqBO);
        BkUmcVerifyProvinceCityAddressRspBO rspBO = (BkUmcVerifyProvinceCityAddressRspBO)UmcRu.success(BkUmcVerifyProvinceCityAddressRspBO.class);
        List<BkUmcAddressDO> bkUmcAddressDOS = reqBO.getAddressList().stream().map(address -> {
            BkUmcAddressDO bkUmcAddressDO = new BkUmcAddressDO();
            bkUmcAddressDO.setProvinceName(address.getProvinceName());
            bkUmcAddressDO.setCityName(address.getCityName());
            return bkUmcAddressDO;
        }).collect(Collectors.toList());
        List<BkUmcAddressDO> resultList = this.bkUmcAddressModel.verifyProvinceCityAddress(bkUmcAddressDOS);
        List bkUmcVerifyAddressInfoBO = UmcRu.jsl(resultList, BkUmcVerifyAddressInfoBO.class);
        rspBO.setResult(bkUmcVerifyAddressInfoBO);
        return rspBO;
    }

    @PostMapping(value={"batchQueryProvinceCityAreaCounty"})
    public BkUmcBatchQueryProvinceCityAreaCountyRspBO batchQueryProvinceCityAreaCounty(@RequestBody BkUmcBatchQueryProvinceCityAreaCountyReqBO reqBO) {
        BkUmcBatchQueryProvinceCityAreaCountyModelRspBO modelRspBO;
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u7701\u5e02\u533a\u53bf\u5730\u5740\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProvinceList()) && ObjectUtil.isEmpty((Object)reqBO.getCityList()) && ObjectUtil.isEmpty((Object)reqBO.getAreaList()) && ObjectUtil.isEmpty((Object)reqBO.getTownList())) {
            throw new BaseBusinessException("200001", "\u7701\u5e02\u533a\u53bf\u5730\u5740\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryProvinceCityAreaCountyRspBO rspBO = (BkUmcBatchQueryProvinceCityAreaCountyRspBO)UmcRu.success(BkUmcBatchQueryProvinceCityAreaCountyRspBO.class);
        BkUmcBatchQueryProvinceCityAreaCountyModelReqBO modelReqBO = new BkUmcBatchQueryProvinceCityAreaCountyModelReqBO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getProvinceList())) {
            modelReqBO.setProvinceList(UmcRu.jsl((List)reqBO.getProvinceList(), BkUmcAddressInfoDO.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCityList())) {
            modelReqBO.setCityList(UmcRu.jsl((List)reqBO.getCityList(), BkUmcAddressInfoDO.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAreaList())) {
            modelReqBO.setAreaList(UmcRu.jsl((List)reqBO.getAreaList(), BkUmcAddressInfoDO.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getTownList())) {
            modelReqBO.setTownList(UmcRu.jsl((List)reqBO.getTownList(), BkUmcAddressInfoDO.class));
        }
        if (ObjectUtil.isNotEmpty((modelRspBO = this.bkUmcAddressModel.batchQueryProvinceCityAreaCounty(modelReqBO)).getProvinceList())) {
            rspBO.setProvinceList(UmcRu.jsl(modelRspBO.getProvinceList(), BkUmcAddressInfoBO.class));
        }
        if (ObjectUtil.isNotEmpty(modelRspBO.getCityList())) {
            rspBO.setCityList(UmcRu.jsl(modelRspBO.getCityList(), BkUmcAddressInfoBO.class));
        }
        if (ObjectUtil.isNotEmpty(modelRspBO.getAreaList())) {
            rspBO.setAreaList(UmcRu.jsl(modelRspBO.getAreaList(), BkUmcAddressInfoBO.class));
        }
        if (ObjectUtil.isNotEmpty(modelRspBO.getTownList())) {
            rspBO.setTownList(UmcRu.jsl(modelRspBO.getTownList(), BkUmcAddressInfoBO.class));
        }
        return rspBO;
    }

    @PostMapping(value={"queryAddressTree"})
    public BkUmcQueryAddressTreeRspBO queryAddressTree(@RequestBody BkUmcQueryAddressTreeReqBO reqBO) {
        List<BkUmcAddressInfoDO> bkUmcAddressInfoDOS;
        this.validQueryAddressTreeData(reqBO);
        BkUmcQueryAddressTreeRspBO rspBO = (BkUmcQueryAddressTreeRspBO)UmcRu.success(BkUmcQueryAddressTreeRspBO.class);
        BkUmcAddressDO modelReqBO = new BkUmcAddressDO();
        modelReqBO.setQueryRange(reqBO.getQueryRange());
        if (!"province".equals(reqBO.getQueryRange())) {
            modelReqBO.setParentCode(reqBO.getParentCode());
        }
        if (ObjectUtil.isEmpty(bkUmcAddressInfoDOS = this.bkUmcAddressModel.queryAddressTree(modelReqBO))) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        List rows = UmcRu.jsl(bkUmcAddressInfoDOS, BkUmcAddressInfoBO.class);
        rspBO.setRows(rows);
        return rspBO;
    }

    private void validQueryAddressTreeData(BkUmcQueryAddressTreeReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5730\u5740\u67e5\u8be2\uff08\u6811\u5f62\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getQueryRange())) {
            throw new BaseBusinessException("200001", "\u5730\u5740\u67e5\u8be2\uff08\u6811\u5f62\uff09[QueryRange]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (!"province".equals(reqBO.getQueryRange()) && ObjectUtil.isEmpty((Object)reqBO.getParentCode())) {
            throw new BaseBusinessException("200001", "\u5730\u5740\u67e5\u8be2\uff08\u6811\u5f62\uff09[ParentCode]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private void validVerifyProvinceCityAddressData(BkUmcVerifyProvinceCityAddressReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAddressList())) {
            throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        reqBO.getAddressList().forEach(address -> {
            if (ObjectUtil.isEmpty((Object)address.getProvinceName())) {
                throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2[ProvinceName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)address.getCityName())) {
                throw new BaseBusinessException("200001", "\u7701\u5e02\u5730\u5740\u6821\u9a8c\uff08\u6279\u91cf\uff09\u5165\u53c2[CityName]\u4e3a\u7a7a");
            }
        });
    }
}

