/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.extension.api.BkUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.service.extension.api.BkUmcInvoiceAddressService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcAddInvoiceAddressReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcAddInvoiceAddressRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcDeleteInvoiceAddressReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcDeleteInvoiceAddressRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcSetMainInvoiceAddressReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcSetMainInvoiceAddressRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUpdateInvoiceAddressReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUpdateInvoiceAddressRspBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcInvoiceAddressService"})
public class BkUmcInvoiceAddressServiceImpl
implements BkUmcInvoiceAddressService {
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private BkUmcInvoiceAddressModel bkUmcInvoiceAddressModel;

    @PostMapping(value={"addInvoiceAddress"})
    public BkUmcAddInvoiceAddressRspBO addInvoiceAddress(@RequestBody BkUmcAddInvoiceAddressReqBO reqBO) {
        BkUmcAddInvoiceAddressRspBO rspBO = (BkUmcAddInvoiceAddressRspBO)UmcRu.success(BkUmcAddInvoiceAddressRspBO.class);
        this.checkSameAddr(reqBO);
        UmcInvoiceAddressDo invoiceAddressDo = (UmcInvoiceAddressDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqBO, UmcInvoiceAddressDo.class));
        List<UmcInvoiceAddressDo> invoiceAddressDoList = this.bkUmcInvoiceAddressModel.qryMainFlagAddrByCompanyId(reqBO.getCompanyId());
        if (CollectionUtils.isEmpty(invoiceAddressDoList)) {
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        } else if (reqBO.getMainFlag().equals(UmcCommConstant.InvAddrMainFlag.YES)) {
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
            this.cancelMainFlagAdder(invoiceAddressDoList);
        } else {
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
        }
        invoiceAddressDo.setCreateTime(new Date());
        invoiceAddressDo.setInvoiceAddrId(Long.valueOf(IdUtil.nextId()));
        invoiceAddressDo.setCompanyName(reqBO.getCompanyNameWeb());
        invoiceAddressDo.setOrgId(reqBO.getOrgIdWeb());
        invoiceAddressDo.setAddrStatus("01");
        invoiceAddressDo.setDelFlag("0");
        invoiceAddressDo.setName(reqBO.getContactNameWeb());
        invoiceAddressDo.setCreateOperName(reqBO.getCreateUserName());
        invoiceAddressDo.setCreateTime(new Date());
        invoiceAddressDo.setCreateOperId(reqBO.getCreateUserId());
        this.iUmcInvoiceAddressModel.createInvoiceAddress(invoiceAddressDo);
        return rspBO;
    }

    @PostMapping(value={"setMainInvoiceAddress"})
    public BkUmcSetMainInvoiceAddressRspBO setMainInvoiceAddress(@RequestBody BkUmcSetMainInvoiceAddressReqBO reqBO) {
        this.validSetMainInvoiceAddressData(reqBO);
        BkUmcSetMainInvoiceAddressRspBO rspBO = (BkUmcSetMainInvoiceAddressRspBO)UmcRu.success(BkUmcSetMainInvoiceAddressRspBO.class);
        List<UmcInvoiceAddressDo> invoiceAddressDoList = this.bkUmcInvoiceAddressModel.qryMainFlagAddrByCompanyId(reqBO.getCompanyId());
        if (!CollectionUtils.isEmpty(invoiceAddressDoList)) {
            this.cancelMainFlagAdder(invoiceAddressDoList);
        }
        for (Long invoiceAddId : reqBO.getInvoiceAddrIdList()) {
            UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
            qryBo.setInvoiceAddrId(invoiceAddId);
            UmcInvoiceAddressDo invoiceAddressDo = this.iUmcInvoiceAddressModel.getInvoiceAddress(qryBo);
            if (null == invoiceAddressDo) {
                throw new BaseBusinessException("201004", "\u4e0d\u5b58\u5728id=" + invoiceAddId + "\u7684\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fe1\u606f\uff01");
            }
            UmcInvoiceAddressDo invoiceAddressDo1 = new UmcInvoiceAddressDo();
            invoiceAddressDo1.setInvoiceAddrId(invoiceAddId);
            invoiceAddressDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
            invoiceAddressDo1.setUpdateTime(new Date());
            invoiceAddressDo1.setUpdateOperId(reqBO.getUpdateUserId());
            invoiceAddressDo1.setUpdateOperName(reqBO.getUpdateUserName());
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo1);
        }
        return rspBO;
    }

    @PostMapping(value={"updateInvoiceAddress"})
    public BkUmcUpdateInvoiceAddressRspBO updateInvoiceAddress(@RequestBody BkUmcUpdateInvoiceAddressReqBO reqBO) {
        List<UmcInvoiceAddressDo> invoiceAddressDoList;
        this.validUpdateInvoiceAddressData(reqBO);
        BkUmcUpdateInvoiceAddressRspBO rspBO = (BkUmcUpdateInvoiceAddressRspBO)UmcRu.success(BkUmcUpdateInvoiceAddressRspBO.class);
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setInvoiceAddrId(reqBO.getInvoiceAddrId());
        UmcInvoiceAddressDo invoiceAddressCheck = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        int checkIdValue = invoiceAddressCheck.getCount();
        if (checkIdValue < 1) {
            throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u5730\u5740ID[" + reqBO.getInvoiceAddrId() + "]\u4e0d\u5b58\u5728");
        }
        UmcOrgInfoQryBo orgInfoCheckReqBo = new UmcOrgInfoQryBo();
        orgInfoCheckReqBo.setOrgId(reqBO.getOrgIdWeb());
        Integer checkOrgInfo = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(orgInfoCheckReqBo).getNumber();
        if (checkOrgInfo == null) {
            throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + reqBO.getOrgIdWeb() + "]\u4e0d\u5b58\u5728");
        }
        if (checkOrgInfo < 1) {
            throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + reqBO.getOrgIdWeb() + "]\u4e0d\u5b58\u5728");
        }
        if (reqBO.getMainFlag().equals(UmcCommConstant.InvAddrMainFlag.YES) && !CollectionUtils.isEmpty(invoiceAddressDoList = this.bkUmcInvoiceAddressModel.qryMainFlagAddrByCompanyId(reqBO.getCompanyId()))) {
            this.cancelMainFlagAdder(invoiceAddressDoList);
        }
        UmcInvoiceAddressDo invoiceAddressDo = (UmcInvoiceAddressDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqBO, UmcInvoiceAddressDo.class));
        invoiceAddressDo.setCompanyName(reqBO.getCompanyNameWeb());
        invoiceAddressDo.setName(reqBO.getContactNameWeb());
        invoiceAddressDo.setAreaCode(reqBO.getAreaCode());
        invoiceAddressDo.setAreaName(reqBO.getAreaName());
        invoiceAddressDo.setAddrDesc(reqBO.getAddrDesc());
        invoiceAddressDo.setTel(reqBO.getTel());
        invoiceAddressDo.setSpecialPlane(reqBO.getSpecialPlane());
        invoiceAddressDo.setRemark(reqBO.getRemark());
        invoiceAddressDo.setPostCode(reqBO.getPostCode());
        invoiceAddressDo.setCountyId(reqBO.getCountyId());
        invoiceAddressDo.setCountryName(reqBO.getCountryName());
        invoiceAddressDo.setProvinceId(reqBO.getProvinceId());
        invoiceAddressDo.setProvinceName(reqBO.getProvinceName());
        invoiceAddressDo.setCityId(reqBO.getCityId());
        invoiceAddressDo.setCityName(reqBO.getCityName());
        invoiceAddressDo.setCountyId(reqBO.getCountyId());
        invoiceAddressDo.setCountyName(reqBO.getCountyName());
        invoiceAddressDo.setTownId(reqBO.getTownId());
        invoiceAddressDo.setTownName(reqBO.getTownName());
        invoiceAddressDo.setElcInvoiceEmail(reqBO.getElcInvoiceEmail());
        invoiceAddressDo.setElcInvoiceMobile(reqBO.getElcInvoiceMobile());
        invoiceAddressDo.setEmail(reqBO.getEmail());
        invoiceAddressDo.setAddrStatus("01");
        invoiceAddressDo.setUpdateTime(new Date());
        invoiceAddressDo.setUpdateOperName(reqBO.getUpdateUserName());
        invoiceAddressDo.setUpdateOperId(reqBO.getUpdateUserId());
        this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        return rspBO;
    }

    @PostMapping(value={"deleteInvoiceAddress"})
    public BkUmcDeleteInvoiceAddressRspBO deleteInvoiceAddress(@RequestBody BkUmcDeleteInvoiceAddressReqBO reqBO) {
        BkUmcDeleteInvoiceAddressRspBO rspBo = (BkUmcDeleteInvoiceAddressRspBO)UmcRu.success(BkUmcDeleteInvoiceAddressRspBO.class);
        for (Long invoiceAddId : reqBO.getInvoiceAddrIdList()) {
            UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
            qryBo.setInvoiceAddrId(invoiceAddId);
            UmcInvoiceAddressDo invoiceAddressDo = this.iUmcInvoiceAddressModel.getInvoiceAddress(qryBo);
            if (null == invoiceAddressDo) {
                throw new BaseBusinessException("201004", "\u4e0d\u5b58\u5728id=" + invoiceAddId + "\u7684\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fe1\u606f\uff01");
            }
            if (UmcCommConstant.InvAddrMainFlag.YES.equals(invoiceAddressDo.getMainFlag())) {
                throw new BaseBusinessException("201004", "\u4e0d\u80fd\u5220\u9664\u9ed8\u8ba4\u53d1\u7968\u90ae\u5bc4\u5730\u5740\uff01");
            }
            UmcInvoiceAddressDo invoiceAddressDo1 = new UmcInvoiceAddressDo();
            invoiceAddressDo1.setInvoiceAddrId(invoiceAddId);
            invoiceAddressDo1.setAddrStatus("01");
            invoiceAddressDo1.setDelFlag("1");
            invoiceAddressDo1.setUpdateTime(new Date());
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo1);
        }
        return rspBo;
    }

    private void validUpdateInvoiceAddressData(BkUmcUpdateInvoiceAddressReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInvoiceAddrId())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5165\u53c2[InvoiceAddrId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUpdateUserId())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5165\u53c2[UpdateUserId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUpdateUserName())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5165\u53c2[UpdateUserName]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCompanyId())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5165\u53c2[CompanyId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getMainFlag())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5165\u53c2[MainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.InvAddrMainFlag.YES.equals(reqBO.getMainFlag()) && !UmcCommConstant.InvAddrMainFlag.NO.equals(reqBO.getMainFlag())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u53ea\u80fd\u4e3a0\u62161");
        }
    }

    private void checkSameAddr(BkUmcAddInvoiceAddressReqBO reqBo) {
        UmcInvoiceAddressQryBo qryBo = (UmcInvoiceAddressQryBo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqBo, UmcInvoiceAddressQryBo.class));
        qryBo.setCompanyName(reqBo.getCompanyNameWeb());
        qryBo.setOrgId(reqBo.getOrgIdWeb());
        qryBo.setName(reqBo.getContactNameWeb());
        qryBo.setCreateOperId(reqBo.getCreateUserId());
        UmcInvoiceAddressDo invoiceAddressCheck = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        if (invoiceAddressCheck.getCount() > 0) {
            throw new BaseBusinessException("201003", "\u5df2\u6709\u76f8\u540c\u7684\u5730\u5740\u4fe1\u606f");
        }
    }

    private void cancelMainFlagAdder(List<UmcInvoiceAddressDo> invoiceAddressDoList) {
        for (UmcInvoiceAddressDo addressDo : invoiceAddressDoList) {
            UmcInvoiceAddressDo invoiceAddressDo = new UmcInvoiceAddressDo();
            invoiceAddressDo.setInvoiceAddrId(addressDo.getInvoiceAddrId());
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        }
    }

    private void validSetMainInvoiceAddressData(BkUmcSetMainInvoiceAddressReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u8bbe\u7f6e\u9ed8\u8ba4\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInvoiceAddrIdList())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u8bbe\u7f6e\u9ed8\u8ba4\u5165\u53c2[InvoiceAddrIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCompanyId())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u8bbe\u7f6e\u9ed8\u8ba4\u5165\u53c2[CompanyId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUpdateUserId())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u8bbe\u7f6e\u9ed8\u8ba4\u5165\u53c2[UpdateUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUpdateUserName())) {
            throw new BaseBusinessException("200001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u8bbe\u7f6e\u9ed8\u8ba4\u5165\u53c2[UpdateUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

