/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgExtMap;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.extension.api.BkUmcOrgModel;
import com.tydic.dyc.umc.model.extension.api.BkUmcOrgProjectRelModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcBatchQueryOrgInfoModelReqBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcOrgProjectRelDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcOrgProjectRelListRspBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcOrgProjectRelQryBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcOrgSummaryInfoDO;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.extension.api.BkUmcOrgService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddOrgProjectRelationReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchAddOrgProjectRelationRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchDeleteOrgProjectRelationReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchDeleteOrgProjectRelationRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryOrgIdentityListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryOrgIdentityListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryOrgInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryOrgInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcChangeCapitalTransReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcChangeCapitalTransRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcIdentityInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcJudgeOrgExistOrNotReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcJudgeOrgExistOrNotRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcJudgeOrgResultBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcOrgAlreadyRelProjectInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcOrgIdentityInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcOrgNotRelProjectInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcOrgSummaryInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryOrgAlreadyRelProjectListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryOrgAlreadyRelProjectListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryOrgNotRelProjectListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryOrgNotRelProjectListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUpdateOrgIdentityReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUpdateOrgIdentityRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcOrgService"})
public class BkUmcOrgServiceImpl
implements BkUmcOrgService {
    @Autowired
    private BkUmcOrgModel bkUmcOrgModel;
    @Autowired
    private BkUmcOrgProjectRelModel bkUmcOrgProjectRelModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"batchQueryOrgInfo"})
    public BkUmcBatchQueryOrgInfoRspBO batchQueryOrgInfo(@RequestBody BkUmcBatchQueryOrgInfoReqBO reqBO) {
        List<BkUmcOrgSummaryInfoDO> bkUmcOrgSummaryInfoDOS;
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgIds()) && ObjectUtil.isEmpty((Object)reqBO.getExtOrgCodes())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryOrgInfoRspBO rspBO = (BkUmcBatchQueryOrgInfoRspBO)UmcRu.success(BkUmcBatchQueryOrgInfoRspBO.class);
        BkUmcBatchQueryOrgInfoModelReqBO modelReqBO = new BkUmcBatchQueryOrgInfoModelReqBO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getOrgIds())) {
            modelReqBO.setOrgIds(reqBO.getOrgIds());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getExtOrgCodes())) {
            modelReqBO.setExtOrgCodes(reqBO.getExtOrgCodes());
        }
        if (ObjectUtil.isEmpty(bkUmcOrgSummaryInfoDOS = this.bkUmcOrgModel.batchQueryOrgInfo(modelReqBO))) {
            rspBO.setRespDesc("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        Map capitalTransflagMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "IS_CAPITAL_TRANSF_FLAG")).getMap();
        ArrayList<BkUmcOrgSummaryInfoBO> orgInfos = new ArrayList<BkUmcOrgSummaryInfoBO>();
        for (BkUmcOrgSummaryInfoDO bkUmcOrgSummaryInfoDO : bkUmcOrgSummaryInfoDOS) {
            BkUmcOrgSummaryInfoBO resultBO = (BkUmcOrgSummaryInfoBO)UmcRu.js((Object)bkUmcOrgSummaryInfoDO, BkUmcOrgSummaryInfoBO.class);
            if (capitalTransflagMap != null && capitalTransflagMap.containsKey(resultBO.getCapitalTransflag())) {
                resultBO.setCapitalTransflagStr((String)capitalTransflagMap.get(resultBO.getCapitalTransflag()));
            }
            orgInfos.add(resultBO);
        }
        rspBO.setOrgInfos(orgInfos);
        return rspBO;
    }

    @PostMapping(value={"batchQueryOrgIdentityList"})
    public BkUmcBatchQueryOrgIdentityListRspBO batchQueryOrgIdentityList(@RequestBody BkUmcBatchQueryOrgIdentityListReqBO reqBO) {
        List<BkUmcOrgSummaryInfoDO> bkUmcOrgSummaryInfoDOS;
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u673a\u6784\u8eab\u4efd\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgIds())) {
            throw new BaseBusinessException("200001", "\u673a\u6784\u8eab\u4efd\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryOrgIdentityListRspBO rspBO = (BkUmcBatchQueryOrgIdentityListRspBO)UmcRu.success(BkUmcBatchQueryOrgIdentityListRspBO.class);
        BkUmcBatchQueryOrgInfoModelReqBO modelReqBO = new BkUmcBatchQueryOrgInfoModelReqBO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getOrgIds())) {
            modelReqBO.setOrgIds(reqBO.getOrgIds());
        }
        if (CollectionUtils.isEmpty(bkUmcOrgSummaryInfoDOS = this.bkUmcOrgModel.batchQueryOrgIdentityList(modelReqBO))) {
            rspBO.setRespDesc("\u673a\u6784\u8eab\u4efd\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<BkUmcOrgIdentityInfoBO> list = new ArrayList<BkUmcOrgIdentityInfoBO>();
        for (BkUmcOrgSummaryInfoDO bkUmcOrgSummaryInfoDO : bkUmcOrgSummaryInfoDOS) {
            BkUmcOrgIdentityInfoBO bkUmcOrgIdentityInfoBO = new BkUmcOrgIdentityInfoBO();
            bkUmcOrgIdentityInfoBO.setOrgId(bkUmcOrgSummaryInfoDO.getOrgId());
            if (!CollectionUtils.isEmpty(bkUmcOrgSummaryInfoDO.getIdentityTags())) {
                List collect = bkUmcOrgSummaryInfoDO.getIdentityTags().stream().map(identityTag -> {
                    BkUmcIdentityInfoBO bkUmcIdentityInfoBO = new BkUmcIdentityInfoBO();
                    bkUmcIdentityInfoBO.setIdentityTag(identityTag);
                    if (identityTag.equals("0")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u8fd0\u8425");
                    } else if (identityTag.equals("1")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u91c7\u8d2d");
                    } else if (identityTag.equals("2")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u9500\u552e");
                    } else {
                        throw new BaseBusinessException("200100", "\u4e0d\u5b58\u5728\u6b64\u8eab\u4efd\u63cf\u8ff0");
                    }
                    return bkUmcIdentityInfoBO;
                }).collect(Collectors.toList());
                bkUmcOrgIdentityInfoBO.setIdentityInfos(collect);
            }
            list.add(bkUmcOrgIdentityInfoBO);
        }
        rspBO.setOrgIdentityInfos(list);
        return rspBO;
    }

    @PostMapping(value={"updateOrgAndUserIdentity"})
    public BkUmcUpdateOrgIdentityRspBO updateOrgAndUserIdentity(@RequestBody BkUmcUpdateOrgIdentityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u673a\u6784\u53ca\u7528\u6237\u8eab\u4efd\u4fee\u6539\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgId())) {
            throw new BaseBusinessException("200001", "\u673a\u6784\u53ca\u7528\u6237\u8eab\u4efd\u4fee\u6539\u5165\u53c2[OrgId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgIdentityInfos())) {
            throw new BaseBusinessException("200001", "\u673a\u6784\u53ca\u7528\u6237\u8eab\u4efd\u4fee\u6539\u5165\u53c2[OrgIdentityInfos]\u4e3a\u7a7a");
        }
        BkUmcUpdateOrgIdentityRspBO rspBO = (BkUmcUpdateOrgIdentityRspBO)UmcRu.success(BkUmcUpdateOrgIdentityRspBO.class);
        BkUmcOrgSummaryInfoDO modelReqBO = new BkUmcOrgSummaryInfoDO();
        List<String> IdentityTag2 = reqBO.getOrgIdentityInfos().stream().map(BkUmcIdentityInfoBO::getIdentityTag).collect(Collectors.toList());
        modelReqBO.setOrgId(reqBO.getOrgId());
        modelReqBO.setIdentityTags(IdentityTag2);
        this.bkUmcOrgModel.updateOrgAndUserIdentity(modelReqBO);
        return rspBO;
    }

    @PostMapping(value={"queryOrgAlreadyRelProjectList"})
    public BkUmcQueryOrgAlreadyRelProjectListRspBO queryOrgAlreadyRelProjectList(@RequestBody BkUmcQueryOrgAlreadyRelProjectListReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u673a\u6784\u5df2\u5173\u8054\u9879\u76ee\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgId())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u673a\u6784\u5df2\u5173\u8054\u9879\u76ee\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2[OrgId]\u4e3a\u7a7a");
        }
        BkUmcQueryOrgAlreadyRelProjectListRspBO rspBO = (BkUmcQueryOrgAlreadyRelProjectListRspBO)UmcRu.success(BkUmcQueryOrgAlreadyRelProjectListRspBO.class);
        ArrayList<BkUmcOrgAlreadyRelProjectInfoBO> list = new ArrayList<BkUmcOrgAlreadyRelProjectInfoBO>();
        BkUmcOrgProjectRelQryBO modelReqBO = (BkUmcOrgProjectRelQryBO)((Object)UmcRu.js((Object)reqBO, BkUmcOrgProjectRelQryBO.class));
        BkUmcOrgProjectRelListRspBO bkUmcOrgProjectRelDOS = this.bkUmcOrgProjectRelModel.queryOrgAlreadyRelProjectList(modelReqBO);
        if (CollectionUtils.isEmpty((Collection)bkUmcOrgProjectRelDOS.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = (BkUmcQueryOrgAlreadyRelProjectListRspBO)UmcRu.js((Object)((Object)bkUmcOrgProjectRelDOS), BkUmcQueryOrgAlreadyRelProjectListRspBO.class);
        Map belongStageMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "BELONG_STAGE")).getMap();
        for (BkUmcOrgProjectRelDO bkUmcOrgProjectRelDO : bkUmcOrgProjectRelDOS.getRows()) {
            BkUmcOrgAlreadyRelProjectInfoBO resultBO = (BkUmcOrgAlreadyRelProjectInfoBO)UmcRu.js((Object)bkUmcOrgProjectRelDO, BkUmcOrgAlreadyRelProjectInfoBO.class);
            if (ObjectUtil.isNotEmpty((Object)resultBO.getBelongStage()) && belongStageMap != null && belongStageMap.containsKey(resultBO.getBelongStage().toString())) {
                resultBO.setBelongStageStr((String)belongStageMap.get(resultBO.getBelongStage().toString()));
            }
            list.add(resultBO);
        }
        rspBO.setRows(list);
        return rspBO;
    }

    @PostMapping(value={"queryOrgNotRelProjectList"})
    public BkUmcQueryOrgNotRelProjectListRspBO queryOrgNotRelProjectList(@RequestBody BkUmcQueryOrgNotRelProjectListReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u673a\u6784\u4e3a\u5173\u8054\u9879\u76ee\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgId())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u673a\u6784\u4e3a\u5173\u8054\u9879\u76ee\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2[OrgId]\u4e3a\u7a7a");
        }
        BkUmcQueryOrgNotRelProjectListRspBO rspBO = (BkUmcQueryOrgNotRelProjectListRspBO)UmcRu.success(BkUmcQueryOrgNotRelProjectListRspBO.class);
        ArrayList<BkUmcOrgNotRelProjectInfoBO> list = new ArrayList<BkUmcOrgNotRelProjectInfoBO>();
        BkUmcOrgProjectRelQryBO modelReqBO = (BkUmcOrgProjectRelQryBO)((Object)UmcRu.js((Object)reqBO, BkUmcOrgProjectRelQryBO.class));
        BkUmcOrgProjectRelListRspBO bkUmcOrgProjectRelDOS = this.bkUmcOrgProjectRelModel.queryOrgNotRelProjectList(modelReqBO);
        if (CollectionUtils.isEmpty((Collection)bkUmcOrgProjectRelDOS.getRows())) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = (BkUmcQueryOrgNotRelProjectListRspBO)UmcRu.js((Object)((Object)bkUmcOrgProjectRelDOS), BkUmcQueryOrgNotRelProjectListRspBO.class);
        Map belongStageMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "BELONG_STAGE")).getMap();
        for (BkUmcOrgProjectRelDO bkUmcOrgProjectRelDO : bkUmcOrgProjectRelDOS.getRows()) {
            BkUmcOrgNotRelProjectInfoBO resultBO = (BkUmcOrgNotRelProjectInfoBO)UmcRu.js((Object)bkUmcOrgProjectRelDO, BkUmcOrgNotRelProjectInfoBO.class);
            if (ObjectUtil.isNotEmpty((Object)resultBO.getBelongStage()) && belongStageMap != null && belongStageMap.containsKey(resultBO.getBelongStage().toString())) {
                resultBO.setBelongStageStr((String)belongStageMap.get(resultBO.getBelongStage().toString()));
            }
            list.add(resultBO);
        }
        rspBO.setRows(list);
        return rspBO;
    }

    @PostMapping(value={"batchDeleteOrgProjectRelation"})
    public BkUmcBatchDeleteOrgProjectRelationRspBO batchDeleteOrgProjectRelation(@RequestBody BkUmcBatchDeleteOrgProjectRelationReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5220\u9664\u673a\u6784\u9879\u76ee\u5173\u8054\u5173\u7cfb\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getIds())) {
            throw new BaseBusinessException("200001", "\u5220\u9664\u673a\u6784\u9879\u76ee\u5173\u8054\u5173\u7cfb\uff08\u6279\u91cf\uff09\u5165\u53c2[Ids]\u4e3a\u7a7a");
        }
        BkUmcBatchDeleteOrgProjectRelationRspBO rspBO = (BkUmcBatchDeleteOrgProjectRelationRspBO)UmcRu.success(BkUmcBatchDeleteOrgProjectRelationRspBO.class);
        this.bkUmcOrgProjectRelModel.batchDeleteOrgProjectRelation(reqBO.getIds());
        return rspBO;
    }

    @PostMapping(value={"batchAddOrgProjectRelation"})
    public BkUmcBatchAddOrgProjectRelationRspBO batchAddOrgProjectRelation(@RequestBody BkUmcBatchAddOrgProjectRelationReqBO reqBO) {
        this.validBatchAddOrgProjectRelationData(reqBO);
        BkUmcBatchAddOrgProjectRelationRspBO rspBO = (BkUmcBatchAddOrgProjectRelationRspBO)UmcRu.success(BkUmcBatchAddOrgProjectRelationRspBO.class);
        BkUmcOrgProjectRelDO modelReqBO = (BkUmcOrgProjectRelDO)UmcRu.js((Object)reqBO, BkUmcOrgProjectRelDO.class);
        this.bkUmcOrgProjectRelModel.batchAddOrgProjectRelation(modelReqBO);
        return rspBO;
    }

    @PostMapping(value={"judgeOrgExistOrNot"})
    public BkUmcJudgeOrgExistOrNotRspBO judgeOrgExistOrNot(@RequestBody BkUmcJudgeOrgExistOrNotReqBO reqBO) {
        this.validJudgeOrgExistOrNotData(reqBO);
        BkUmcJudgeOrgExistOrNotRspBO rspBO = (BkUmcJudgeOrgExistOrNotRspBO)UmcRu.success(BkUmcJudgeOrgExistOrNotRspBO.class);
        List<BkUmcOrgSummaryInfoDO> bkUmcOrgSummaryInfoDOS = this.bkUmcOrgModel.judgeOrgExistOrNot(reqBO.getOrgNames());
        List result = UmcRu.jsl(bkUmcOrgSummaryInfoDOS, BkUmcJudgeOrgResultBO.class);
        rspBO.setResult(result);
        return rspBO;
    }

    @PostMapping(value={"changeCapitalTrans"})
    public BkUmcChangeCapitalTransRspBO changeCapitalTrans(@RequestBody BkUmcChangeCapitalTransReqBO reqBO) {
        this.validChangeCapitalTransData(reqBO);
        BkUmcChangeCapitalTransRspBO rspBO = (BkUmcChangeCapitalTransRspBO)UmcRu.success(BkUmcChangeCapitalTransRspBO.class);
        ArrayList<UmcOrgExtMap> umcOrgExtMaps = new ArrayList<UmcOrgExtMap>();
        UmcOrgExtMap umcOrgExtMap = new UmcOrgExtMap();
        umcOrgExtMap.setOrgId(reqBO.getOrgId().toString());
        umcOrgExtMap.setFieldValue(reqBO.getCapitalTransflag());
        umcOrgExtMap.setUpdateOperId(reqBO.getUpdateUserId());
        umcOrgExtMap.setUpdateOperName(reqBO.getUpdateUserName());
        umcOrgExtMap.setUpdateTime(new Date());
        umcOrgExtMaps.add(umcOrgExtMap);
        UmcOrgInfo umcOrgInfo = new UmcOrgInfo();
        umcOrgInfo.setOrgId(reqBO.getOrgId());
        umcOrgInfo.setOrgExtMapList(umcOrgExtMaps);
        umcOrgInfo.setUpdateOperId(reqBO.getUpdateUserId());
        umcOrgInfo.setUpdateOperName(reqBO.getUpdateUserName());
        umcOrgInfo.setUpdateTime(new Date());
        this.iUmcEnterpriseInfoModel.updateOrgInfo(umcOrgInfo);
        return rspBO;
    }

    private void validChangeCapitalTransData(BkUmcChangeCapitalTransReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u53d8\u66f4\u8d44\u91d1\u5212\u62e8\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgId())) {
            throw new BaseBusinessException("200001", "\u53d8\u66f4\u8d44\u91d1\u5212\u62e8\u5165\u53c2[OrgId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCapitalTransflag())) {
            throw new BaseBusinessException("200001", "\u53d8\u66f4\u8d44\u91d1\u5212\u62e8\u5165\u53c2[CapitalTransflag]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUpdateUserId())) {
            throw new BaseBusinessException("200001", "\u53d8\u66f4\u8d44\u91d1\u5212\u62e8\u5165\u53c2[UpdateUserId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUpdateUserName())) {
            throw new BaseBusinessException("200001", "\u53d8\u66f4\u8d44\u91d1\u5212\u62e8\u5165\u53c2[UpdateUserName]\u4e3a\u7a7a");
        }
    }

    private void validJudgeOrgExistOrNotData(BkUmcJudgeOrgExistOrNotReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5224\u65ad\u673a\u6784\u662f\u5426\u5b58\u5728\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgNames())) {
            throw new BaseBusinessException("200001", "\u5224\u65ad\u673a\u6784\u662f\u5426\u5b58\u5728\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private void validBatchAddOrgProjectRelationData(BkUmcBatchAddOrgProjectRelationReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u65b0\u589e\u673a\u6784\u9879\u76ee\u5173\u8054\u5173\u7cfb\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgId())) {
            throw new BaseBusinessException("200001", "\u65b0\u589e\u673a\u6784\u9879\u76ee\u5173\u8054\u5173\u7cfb\uff08\u6279\u91cf\uff09\u5165\u53c2[OrgId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getProjectCodes())) {
            throw new BaseBusinessException("200001", "\u65b0\u589e\u673a\u6784\u9879\u76ee\u5173\u8054\u5173\u7cfb\uff08\u6279\u91cf\uff09\u5165\u53c2[ProjectCodes]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateUserId())) {
            throw new BaseBusinessException("200001", "\u65b0\u589e\u673a\u6784\u9879\u76ee\u5173\u8054\u5173\u7cfb\uff08\u6279\u91cf\uff09\u5165\u53c2[CreateUserId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateUserName())) {
            throw new BaseBusinessException("200001", "\u65b0\u589e\u673a\u6784\u9879\u76ee\u5173\u8054\u5173\u7cfb\uff08\u6279\u91cf\uff09\u5165\u53c2[CreateUserName]\u4e3a\u7a7a");
        }
    }
}

