/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.api.BkUmcTodoModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoDo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoListRspBo;
import com.tydic.dyc.umc.model.extension.bo.BkUmcTodoQryBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.constant.BkUmcStatusConstant;
import com.tydic.dyc.umc.service.extension.api.BkUmcTodoService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchPushTodoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushDoneRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPushTodoResultInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryTodoOrDoneListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryTodoOrDoneListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcTodoInfoBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcTodoService"})
public class BkUmcTodoServiceImpl
implements BkUmcTodoService {
    private static final Logger log = LoggerFactory.getLogger(BkUmcTodoServiceImpl.class);
    @Autowired
    private BkUmcTodoModel bkUmcTodoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"queryTodoOrDoneList"})
    public BkUmcQueryTodoOrDoneListRspBO queryTodoOrDoneList(@RequestBody BkUmcQueryTodoOrDoneListReqBO reqBO) {
        this.validQueryTodoOrDoneListData(reqBO);
        BkUmcQueryTodoOrDoneListRspBO rspBO = new BkUmcQueryTodoOrDoneListRspBO();
        ArrayList<BkUmcTodoInfoBO> list = new ArrayList<BkUmcTodoInfoBO>();
        BkUmcTodoQryBo qryBo = new BkUmcTodoQryBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)qryBo));
        BkUmcTodoListRspBo bkUmcTodoListRspBo = this.bkUmcTodoModel.queryTodoOrDoneList(qryBo);
        if (CollectionUtils.isEmpty((Collection)bkUmcTodoListRspBo.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO = (BkUmcQueryTodoOrDoneListRspBO)UmcRu.js((Object)((Object)bkUmcTodoListRspBo), BkUmcQueryTodoOrDoneListRspBO.class);
        Map dealResultMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "DEAL_RESULT")).getMap();
        for (BkUmcTodoDo bkUmcTodoDo : bkUmcTodoListRspBo.getRows()) {
            BkUmcTodoInfoBO bkUmcTodoInfoBO = new BkUmcTodoInfoBO();
            BeanUtils.copyProperties((Object)bkUmcTodoDo, (Object)bkUmcTodoInfoBO);
            if (BkUmcStatusConstant.todoType.PENDING_APPROVAL.equals(bkUmcTodoInfoBO.getTodoType()) && BkUmcStatusConstant.TodoOrDoneStatus.DONE.equals(bkUmcTodoInfoBO.getTodoStatus()) && ObjectUtil.isNotEmpty((Object)bkUmcTodoInfoBO.getDealResult()) && dealResultMap != null && dealResultMap.containsKey(bkUmcTodoInfoBO.getDealResult().toString())) {
                bkUmcTodoInfoBO.setDealResultStr((String)dealResultMap.get(bkUmcTodoInfoBO.getDealResult().toString()));
            }
            list.add(bkUmcTodoInfoBO);
        }
        rspBO.setRows(list);
        return rspBO;
    }

    @PostMapping(value={"batchPushTodo"})
    public BkUmcBatchPushTodoRspBO batchPushTodo(@RequestBody BkUmcBatchPushTodoReqBO reqBO) {
        this.validBatchPushTodoData(reqBO);
        BkUmcBatchPushTodoRspBO rspBO = (BkUmcBatchPushTodoRspBO)UmcRu.success(BkUmcBatchPushTodoRspBO.class);
        List<BkUmcTodoDo> pushTodoDOS = reqBO.getTodoInfos().stream().map(bkUmcPushTodoInfoBO -> {
            BkUmcTodoDo bkUmcTodoDo = new BkUmcTodoDo();
            BeanUtils.copyProperties((Object)bkUmcPushTodoInfoBO, (Object)bkUmcTodoDo);
            return bkUmcTodoDo;
        }).collect(Collectors.toList());
        List<BkUmcPushTodoResultInfoBO> resultInfo = this.bkUmcTodoModel.batchPushTodo(pushTodoDOS);
        rspBO.setResultInfo(resultInfo);
        return rspBO;
    }

    @PostMapping(value={"pushDone"})
    public BkUmcPushDoneRspBO pushDone(@RequestBody BkUmcPushDoneReqBO reqBO) {
        this.validPushDoneData(reqBO);
        BkUmcPushDoneRspBO rspBO = (BkUmcPushDoneRspBO)UmcRu.success(BkUmcPushDoneRspBO.class);
        BkUmcTodoDo modelReqBO = (BkUmcTodoDo)UmcRu.js((Object)reqBO, BkUmcTodoDo.class);
        List<BkUmcTodoDo> bkUmcTodoDo = this.bkUmcTodoModel.pushDone(modelReqBO);
        List todoInfos = UmcRu.jsl(bkUmcTodoDo, BkUmcPushDoneInfoBO.class);
        rspBO.setTodoInfos(todoInfos);
        return rspBO;
    }

    private void validPushDoneData(BkUmcPushDoneReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId()) && ObjectUtil.isEmpty((Object)reqBO.getBusiId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private void validBatchPushTodoData(BkUmcBatchPushTodoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTodoInfos())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        reqBO.getTodoInfos().forEach(bkPushTodoInfoBO -> {
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoType())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoType]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getBelongModule())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[belongModule]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getTodoEvent())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[todoEvent]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getLinkUrl())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[linkUrl]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getCreateUserName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[createUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingUserName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingUserName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingOrgName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingOrgName]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingCompanyId())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingCompanyId]\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)bkPushTodoInfoBO.getPendingCompanyName())) {
                throw new BaseBusinessException("200001", "\u63a8\u9001\u5f85\u529e\uff08\u6279\u91cf\uff09\u5165\u53c2[pendingCompanyName]\u4e3a\u7a7a");
            }
        });
    }

    private void validQueryTodoOrDoneListData(BkUmcQueryTodoOrDoneListReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5f85\u529e/\u5df2\u529e\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getTodoType()) && ObjectUtil.isEmpty((Object)reqBO.getTodoStatus())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u5f85\u529e/\u5df2\u529e\u5217\u8868\uff08\u5206\u9875\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
    }
}

