/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.api.BkUmcUserModel;
import com.tydic.dyc.umc.model.extension.bo.BkUmcUserSummaryInfoDO;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.extension.api.BkUmcUserService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryInnerUserPartTimeJobInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserIdentityListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserIdentityListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcBatchQueryUserInfoRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcIdentityInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcInnerUserPartTimeJobInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcInnerUserSummaryInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcPartTimeJobInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserIdentityInfoBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUserSummaryInfoBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcUserService"})
public class BkUmcUserServiceImpl
implements BkUmcUserService {
    private static final Logger log = LoggerFactory.getLogger(BkUmcUserServiceImpl.class);
    @Autowired
    private BkUmcUserModel bkUmcUserModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"batchQueryUserInfo"})
    public BkUmcBatchQueryUserInfoRspBO batchQueryUserInfo(@RequestBody BkUmcBatchQueryUserInfoReqBO reqBO) {
        BkUmcBatchQueryUserInfoRspBO rspBO = (BkUmcBatchQueryUserInfoRspBO)UmcRu.success(BkUmcBatchQueryUserInfoRspBO.class);
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUserIds())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        List<BkUmcUserSummaryInfoDO> userInfos = this.bkUmcUserModel.batchQueryUserInfo(reqBO.getUserIds());
        if (CollectionUtils.isEmpty(userInfos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        List collect = userInfos.stream().map(bkUmcUserSummaryInfoDO -> {
            BkUmcUserSummaryInfoBO bkUmcUserSummaryInfoBO = new BkUmcUserSummaryInfoBO();
            BeanUtils.copyProperties((Object)bkUmcUserSummaryInfoDO, (Object)bkUmcUserSummaryInfoBO);
            return bkUmcUserSummaryInfoBO;
        }).collect(Collectors.toList());
        rspBO.setUserInfos(collect);
        return rspBO;
    }

    @PostMapping(value={"batchQueryUserIdentityList"})
    public BkUmcBatchQueryUserIdentityListRspBO batchQueryUserIdentityList(@RequestBody BkUmcBatchQueryUserIdentityListReqBO reqBO) {
        List<BkUmcUserSummaryInfoDO> bkUmcUserSummaryInfoDOS;
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u7528\u6237\u8eab\u4efd\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getUserIds())) {
            throw new BaseBusinessException("200001", "\u7528\u6237\u8eab\u4efd\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryUserIdentityListRspBO rspBO = (BkUmcBatchQueryUserIdentityListRspBO)UmcRu.success(BkUmcBatchQueryUserIdentityListRspBO.class);
        BkUmcBatchQueryUserInfoReqBO modelReqBO = new BkUmcBatchQueryUserInfoReqBO();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getUserIds())) {
            modelReqBO.setUserIds(reqBO.getUserIds());
        }
        if (CollectionUtils.isEmpty(bkUmcUserSummaryInfoDOS = this.bkUmcUserModel.batchQueryUserIdentityList(modelReqBO))) {
            rspBO.setRespDesc("\u7528\u6237\u8eab\u4efd\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        ArrayList<BkUmcUserIdentityInfoBO> list = new ArrayList<BkUmcUserIdentityInfoBO>();
        for (BkUmcUserSummaryInfoDO bkUmcUserSummaryInfoDO : bkUmcUserSummaryInfoDOS) {
            BkUmcUserIdentityInfoBO bkUmcUserIdentityInfoBO = new BkUmcUserIdentityInfoBO();
            bkUmcUserIdentityInfoBO.setUserId(bkUmcUserSummaryInfoDO.getUserId());
            if (!CollectionUtils.isEmpty(bkUmcUserSummaryInfoDO.getIdentityTags())) {
                List collect = bkUmcUserSummaryInfoDO.getIdentityTags().stream().map(identityTag -> {
                    BkUmcIdentityInfoBO bkUmcIdentityInfoBO = new BkUmcIdentityInfoBO();
                    bkUmcIdentityInfoBO.setIdentityTag(identityTag);
                    if (identityTag.equals("0")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u8fd0\u8425");
                    } else if (identityTag.equals("1")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u91c7\u8d2d");
                    } else if (identityTag.equals("2")) {
                        bkUmcIdentityInfoBO.setIdentityTagStr("\u9500\u552e");
                    } else {
                        throw new BaseBusinessException("200100", "\u4e0d\u5b58\u5728\u6b64\u8eab\u4efd\u63cf\u8ff0");
                    }
                    return bkUmcIdentityInfoBO;
                }).collect(Collectors.toList());
                bkUmcUserIdentityInfoBO.setIdentityInfos(collect);
            }
            list.add(bkUmcUserIdentityInfoBO);
        }
        rspBO.setUserIdentityInfos(list);
        return rspBO;
    }

    @PostMapping(value={"batchQueryInnerUserPartTimeJobInfo"})
    public BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO batchQueryInnerUserPartTimeJobInfo(@RequestBody BkUmcBatchQueryInnerUserPartTimeJobInfoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u5185\u90e8\u7528\u6237\u517c\u804c\u4fe1\u606f\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCustIds())) {
            throw new BaseBusinessException("200001", "\u5185\u90e8\u7528\u6237\u517c\u804c\u4fe1\u606f\u67e5\u8be2\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO rspBO = (BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO)UmcRu.success(BkUmcBatchQueryInnerUserPartTimeJobInfoRspBO.class);
        List<Long> custIds = reqBO.getCustIds().stream().map(BkUmcInnerUserSummaryInfoBO::getCustId).collect(Collectors.toList());
        List<BkUmcUserSummaryInfoDO> bkUmcUserSummaryInfoDOS = this.bkUmcUserModel.batchQueryInnerUserPartTimeJobInfo(custIds);
        if (ObjectUtil.isEmpty(bkUmcUserSummaryInfoDOS)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5185\u90e8\u7528\u6237\u517c\u804c\u4fe1\u606f");
        }
        Map stopStatusMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "MEM_STOP_STATUS")).getMap();
        Map userTypeMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "USER_TYPE")).getMap();
        ArrayList<BkUmcPartTimeJobInfoBO> list = new ArrayList<BkUmcPartTimeJobInfoBO>();
        for (BkUmcUserSummaryInfoDO bkUmcUserSummaryInfoDO : bkUmcUserSummaryInfoDOS) {
            BkUmcPartTimeJobInfoBO infoBO = (BkUmcPartTimeJobInfoBO)UmcRu.js((Object)bkUmcUserSummaryInfoDO, BkUmcPartTimeJobInfoBO.class);
            if (stopStatusMap != null && stopStatusMap.containsKey(infoBO.getStopStatus())) {
                infoBO.setStopStatusStr((String)stopStatusMap.get(infoBO.getStopStatus()));
            }
            if (userTypeMap != null && userTypeMap.containsKey(infoBO.getUserType())) {
                infoBO.setUserTypeStr((String)userTypeMap.get(infoBO.getUserType()));
            }
            list.add(infoBO);
        }
        Map<Long, List<BkUmcPartTimeJobInfoBO>> listMap = list.stream().collect(Collectors.groupingBy(BkUmcPartTimeJobInfoBO::getMainCustId));
        Iterator<Long> mainCustIds = listMap.keySet().iterator();
        ArrayList<BkUmcInnerUserPartTimeJobInfoBO> rows = new ArrayList<BkUmcInnerUserPartTimeJobInfoBO>();
        while (mainCustIds.hasNext()) {
            Long mainCustId = mainCustIds.next();
            BkUmcInnerUserPartTimeJobInfoBO bkUmcInnerUserPartTimeJobInfoBO = new BkUmcInnerUserPartTimeJobInfoBO();
            bkUmcInnerUserPartTimeJobInfoBO.setCustId(mainCustId);
            bkUmcInnerUserPartTimeJobInfoBO.setPartTimeJobInfos(listMap.get(mainCustId));
            rows.add(bkUmcInnerUserPartTimeJobInfoBO);
        }
        rspBO.setRows(rows);
        return rspBO;
    }
}

