/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.extension.api.BkUmcAccountingPeriodSettlementModel;
import com.tydic.dyc.umc.model.extension.bo.BkAccountingPeriodSettlementDO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcAccountingPeriodSettlementQryBO;
import com.tydic.dyc.umc.model.extension.bo.BkUmcAccountingPeriodSettlementRspBO;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.extension.api.BkUmcAccountingPeriodSettlementService;
import com.tydic.dyc.umc.service.extension.bo.BkUmcAccountingPeriodSettlementBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAccountingPeriodSettlementDetailReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAccountingPeriodSettlementDetailRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAccountingPeriodSettlementListReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcQueryAccountingPeriodSettlementListRspBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUpdateAccountingPeriodSettlementReqBO;
import com.tydic.dyc.umc.service.extension.bo.BkUmcUpdateAccountingPeriodSettlementRspBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.extension.api.BkUmcAccountingPeriodSettlementService"})
public class BkUmcAccountingPeriodSettlementServiceImpl
implements BkUmcAccountingPeriodSettlementService {
    @Autowired
    private BkUmcAccountingPeriodSettlementModel bkUmcAccountingPeriodSettlementModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;
    private static final String MONTH = "1";

    @PostMapping(value={"queryAccountingList"})
    public BkUmcQueryAccountingPeriodSettlementListRspBO queryAccountingList(@RequestBody BkUmcQueryAccountingPeriodSettlementListReqBO reqBO) {
        this.validQueryAccountingListData(reqBO);
        BkUmcAccountingPeriodSettlementQryBO qryBO = (BkUmcAccountingPeriodSettlementQryBO)((Object)UmcRu.js((Object)reqBO, BkUmcAccountingPeriodSettlementQryBO.class));
        BkUmcQueryAccountingPeriodSettlementListRspBO rspBO = new BkUmcQueryAccountingPeriodSettlementListRspBO();
        ArrayList<BkUmcAccountingPeriodSettlementBO> list = new ArrayList<BkUmcAccountingPeriodSettlementBO>();
        BkUmcAccountingPeriodSettlementRspBO bkAccountingPeriodSettlementDOS = this.bkUmcAccountingPeriodSettlementModel.queryAccountingList(qryBO);
        if (ObjectUtil.isEmpty((Object)((Object)bkAccountingPeriodSettlementDOS))) {
            rspBO.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u8d26\u671f\u7ed3\u7b97\u7ed3\u679c\u672a\u7a7a");
        }
        rspBO = (BkUmcQueryAccountingPeriodSettlementListRspBO)UmcRu.js((Object)((Object)bkAccountingPeriodSettlementDOS), BkUmcQueryAccountingPeriodSettlementListRspBO.class);
        Map methodType = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "SETTLEMENT_METHOD")).getMap();
        Map dateType = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "SETTLEMENT_DATE_TYPE")).getMap();
        for (BkAccountingPeriodSettlementDO accountingPeriodSettlementDO : bkAccountingPeriodSettlementDOS.getRows()) {
            BkUmcAccountingPeriodSettlementBO settlementBO = (BkUmcAccountingPeriodSettlementBO)UmcRu.js((Object)accountingPeriodSettlementDO, BkUmcAccountingPeriodSettlementBO.class);
            if (methodType != null && methodType.containsKey(accountingPeriodSettlementDO.getSettlementMethod())) {
                settlementBO.setSettlementMethodStr((String)methodType.get(accountingPeriodSettlementDO.getSettlementMethod()));
            }
            if (dateType != null && dateType.containsKey(accountingPeriodSettlementDO.getSettlementDateType())) {
                settlementBO.setSettlementDateTypeStr((String)dateType.get(accountingPeriodSettlementDO.getSettlementDateType()));
            }
            settlementBO.setTypeStr(accountingPeriodSettlementDO.getType().equals(MONTH) ? "\u9ed8\u8ba4" : "\u9644\u52a0");
            if (MONTH.equals(accountingPeriodSettlementDO.getSettlementDateType())) {
                settlementBO.setSettlementMonth("\u6bcf\u6708" + accountingPeriodSettlementDO.getSettlementDay() + "\u65e5");
            } else {
                settlementBO.setSettlementMonth("\u6bcf" + accountingPeriodSettlementDO.getSettlementMonth() + "\u6708" + accountingPeriodSettlementDO.getSettlementDay() + "\u65e5");
                if (!StringUtils.isBlank((CharSequence)accountingPeriodSettlementDO.getSettlementMonth())) {
                    String[] monthArray = accountingPeriodSettlementDO.getSettlementMonth().split("\u3001");
                    ArrayList<Integer> months = new ArrayList<Integer>();
                    for (int i = 0; i < monthArray.length; ++i) {
                        months.add(Integer.parseInt(monthArray[i]));
                    }
                    settlementBO.setMonths(months);
                }
            }
            list.add(settlementBO);
        }
        rspBO.setRows(list);
        return rspBO;
    }

    @PostMapping(value={"queryAccountingDetail"})
    public BkUmcQueryAccountingPeriodSettlementDetailRspBO queryAccountingDetail(@RequestBody BkUmcQueryAccountingPeriodSettlementDetailReqBO reqBO) {
        this.validQueryAccountingDetailDta(reqBO);
        BkUmcQueryAccountingPeriodSettlementDetailRspBO rspBO = (BkUmcQueryAccountingPeriodSettlementDetailRspBO)UmcRu.success(BkUmcQueryAccountingPeriodSettlementDetailRspBO.class);
        BkAccountingPeriodSettlementDO bkAccountingPeriodSettlementDO = this.bkUmcAccountingPeriodSettlementModel.queryAccountingDetail(reqBO.getId());
        rspBO = (BkUmcQueryAccountingPeriodSettlementDetailRspBO)UmcRu.js((Object)bkAccountingPeriodSettlementDO, BkUmcQueryAccountingPeriodSettlementDetailRspBO.class);
        Map methodType = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "SETTLEMENT_METHOD")).getMap();
        Map dateType = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "SETTLEMENT_DATE_TYPE")).getMap();
        if (methodType != null && methodType.containsKey(bkAccountingPeriodSettlementDO.getSettlementMethod())) {
            rspBO.setSettlementMethodStr((String)methodType.get(bkAccountingPeriodSettlementDO.getSettlementMethod()));
        }
        if (dateType != null && dateType.containsKey(bkAccountingPeriodSettlementDO.getSettlementDateType())) {
            rspBO.setSettlementDateTypeStr((String)dateType.get(bkAccountingPeriodSettlementDO.getSettlementDateType()));
        }
        rspBO.setTypeStr(bkAccountingPeriodSettlementDO.getType().equals(MONTH) ? "\u9ed8\u8ba4" : "\u9644\u52a0");
        return rspBO;
    }

    @PostMapping(value={"updateAccountingPeriod"})
    public BkUmcUpdateAccountingPeriodSettlementRspBO updateAccountingPeriod(@RequestBody BkUmcUpdateAccountingPeriodSettlementReqBO reqBO) {
        this.validUpdateAccountPeriodData(reqBO);
        BkUmcUpdateAccountingPeriodSettlementRspBO rspBO = (BkUmcUpdateAccountingPeriodSettlementRspBO)UmcRu.success(BkUmcUpdateAccountingPeriodSettlementRspBO.class);
        BkAccountingPeriodSettlementDO modelReqBO = (BkAccountingPeriodSettlementDO)UmcRu.js((Object)reqBO, BkAccountingPeriodSettlementDO.class);
        this.bkUmcAccountingPeriodSettlementModel.updateAccountingPeriod(modelReqBO);
        return rspBO;
    }

    private void validUpdateAccountPeriodData(BkUmcUpdateAccountingPeriodSettlementReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8d26\u671f\u7ed3\u7b97\u8bbe\u7f6e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId())) {
            throw new BaseBusinessException("200001", "\u4fee\u6539\u8d26\u671f\u7ed3\u7b97\u8bbe\u7f6e\u5165\u53c2[Id]\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getMonths())) {
            for (Integer month : reqBO.getMonths()) {
                if (null != month) continue;
                throw new BaseBusinessException("200001", "\u4fee\u6539\u8d26\u671f\u7ed3\u7b97\u8bbe\u7f6e\u5165\u53c2[Months]\u4e3a\u7a7a");
            }
        }
    }

    private void validQueryAccountingDetailDta(BkUmcQueryAccountingPeriodSettlementDetailReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u8d26\u671f\u7ed3\u7b97\u8be6\u60c5\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getId())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u8d26\u671f\u7ed3\u7b97\u8be6\u60c5\u5165\u53c2[Id]\u4e3a\u7a7a");
        }
    }

    private void validQueryAccountingListData(BkUmcQueryAccountingPeriodSettlementListReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u652f\u4ed8\u8d26\u671f\u7ed3\u7b97\u8bbe\u7f6e\u5217\u8868\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getConfigurationType())) {
            throw new BaseBusinessException("200001", "\u67e5\u8be2\u652f\u4ed8\u8d26\u671f\u7ed3\u7b97\u8bbe\u7f6e\u5217\u8868\u5165\u53c2[ConfigurationType]\u4e3a\u7a7a");
        }
    }
}

