/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.active.app.atom.ActGiftQueryAtomService;
import com.tydic.active.app.atom.ActSelectDictByCodeAndPcodeAtomService;
import com.tydic.active.app.atom.bo.ActGiftQueryAtomReqBO;
import com.tydic.active.app.atom.bo.ActGiftQueryAtomRspBO;
import com.tydic.active.app.common.bo.ActiveGiftBO;
import com.tydic.active.app.common.bo.ActiveGiftPkgBO;
import com.tydic.active.app.dao.ActiveGiftMapper;
import com.tydic.active.app.dao.ActiveGiftPkgMapper;
import com.tydic.active.app.dao.ActiveGiftStockMapper;
import com.tydic.active.app.dao.ActivePkgComposeMapper;
import com.tydic.active.app.dao.po.ActiveGiftPO;
import com.tydic.active.app.dao.po.ActiveGiftPkgPO;
import com.tydic.active.app.dao.po.ActiveGiftStockPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actGiftQueryAtomService")
public class ActGiftQueryAtomServiceImpl
implements ActGiftQueryAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActGiftQueryAtomServiceImpl.class);
    @Autowired
    private ActiveGiftMapper activeGiftMapper;
    @Autowired
    private ActiveGiftStockMapper activeGiftStockMapper;
    @Autowired
    private ActiveGiftPkgMapper activeGiftPkgMapper;
    @Autowired
    private ActivePkgComposeMapper activePkgComposeMapper;
    @Autowired
    private ActSelectDictByCodeAndPcodeAtomService actSelectDictByCodeAndPcodeAtomService;

    @Override
    public ActGiftQueryAtomRspBO queryGift(ActGiftQueryAtomReqBO reqBO) {
        Long activeId = reqBO.getActiveId();
        ActGiftQueryAtomRspBO rspBO = new ActGiftQueryAtomRspBO();
        ArrayList<ActiveGiftBO> giftAtomBoList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> giftPkgBOList = new ArrayList<ActiveGiftPkgBO>();
        Map<String, String> optionMarkStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "MSC_OPTION_MARK");
        Map<String, String> isSendStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "MSC_GIFT_IS_SEND");
        Map<String, String> giftTypeStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "MSC_GIFT_TYPE");
        Map<String, String> pkgTypeStrMap = this.actSelectDictByCodeAndPcodeAtomService.queryDictBySysCodeAndPcode("MSC", "MSC_GIFT_PKG_TYPE");
        ActiveGiftPO activeGiftPO = new ActiveGiftPO();
        activeGiftPO.setActiveId(activeId);
        activeGiftPO.setActiveTemplateGroupId(reqBO.getActiveTemplateGroupId());
        List<ActiveGiftPO> activeGiftPOList = this.activeGiftMapper.getList(activeGiftPO);
        if (!CollectionUtils.isEmpty(activeGiftPOList)) {
            for (ActiveGiftPO giftPO : activeGiftPOList) {
                if (null != giftPO.getPkgId()) continue;
                ActiveGiftBO giftAtomBo = new ActiveGiftBO();
                BeanUtils.copyProperties((Object)giftPO, (Object)giftAtomBo);
                try {
                    giftAtomBo.setGiftPrice(MoneyUtils.Long2BigDecimal((Long)giftPO.getGiftPrice()));
                }
                catch (Exception e) {
                    LOGGER.error("\u8d60\u54c1\u67e5\u8be2\u539f\u5b50\u670d\u52a1\uff0c\u8d60\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                }
                this.queryGiftCount(giftAtomBo, null);
                if (null != giftAtomBo.getOptionMark()) {
                    giftAtomBo.setOptionMarkStr(optionMarkStrMap.get(giftAtomBo.getOptionMark().toString()));
                }
                if (null != giftAtomBo.getIsSend()) {
                    giftAtomBo.setIsSendStr(isSendStrMap.get(giftAtomBo.getIsSend().toString()));
                }
                if (null != giftAtomBo.getGiftType()) {
                    giftAtomBo.setGiftTypeStr(giftTypeStrMap.get(giftAtomBo.getGiftType().toString()));
                }
                giftAtomBoList.add(giftAtomBo);
            }
        }
        ActiveGiftPkgPO activeGiftPkgPO = new ActiveGiftPkgPO();
        activeGiftPkgPO.setActiveId(activeId);
        activeGiftPkgPO.setActiveTemplateGroupId(reqBO.getActiveTemplateGroupId());
        List<ActiveGiftPkgPO> activeGiftPkgPOList = this.activeGiftPkgMapper.getList(activeGiftPkgPO);
        if (!CollectionUtils.isEmpty(activeGiftPkgPOList)) {
            for (ActiveGiftPkgPO giftPkgPO : activeGiftPkgPOList) {
                ActiveGiftPkgBO activeGiftPkgBO = new ActiveGiftPkgBO();
                BeanUtils.copyProperties((Object)giftPkgPO, (Object)activeGiftPkgBO);
                ArrayList<ActiveGiftBO> giftBOList = new ArrayList<ActiveGiftBO>();
                ActiveGiftPO activeGiftPO2 = new ActiveGiftPO();
                activeGiftPO2.setActiveId(activeId);
                activeGiftPO2.setPkgId(giftPkgPO.getPkgId());
                activeGiftPO2.setActiveTemplateGroupId(reqBO.getActiveTemplateGroupId());
                List<ActiveGiftPO> activeGiftPO2List = this.activeGiftMapper.getList(activeGiftPO2);
                if (!CollectionUtils.isEmpty(activeGiftPO2List)) {
                    for (ActiveGiftPO activeGift : activeGiftPO2List) {
                        ActiveGiftBO giftBo = new ActiveGiftBO();
                        BeanUtils.copyProperties((Object)activeGift, (Object)giftBo);
                        try {
                            giftBo.setGiftPrice(MoneyUtils.Long2BigDecimal((Long)activeGift.getGiftPrice()));
                        }
                        catch (Exception e) {
                            LOGGER.error("\u8d60\u54c1\u67e5\u8be2\u539f\u5b50\u670d\u52a1\uff0c\u8d60\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                        }
                        this.queryGiftCount(giftBo, activeGift.getPkgId());
                        if (null != giftBo.getOptionMark()) {
                            giftBo.setOptionMarkStr(optionMarkStrMap.get(giftBo.getOptionMark().toString()));
                        }
                        if (null != giftBo.getIsSend()) {
                            giftBo.setIsSendStr(isSendStrMap.get(giftBo.getIsSend().toString()));
                        }
                        if (null != giftBo.getGiftType()) {
                            giftBo.setGiftTypeStr(giftTypeStrMap.get(giftBo.getGiftType().toString()));
                        }
                        giftBOList.add(giftBo);
                    }
                }
                activeGiftPkgBO.setGiftList(giftBOList);
                if (null != activeGiftPkgBO.getOptionMark()) {
                    activeGiftPkgBO.setOptionMarkStr(optionMarkStrMap.get(activeGiftPkgBO.getOptionMark().toString()));
                }
                if (null != activeGiftPkgBO.getPkgType()) {
                    activeGiftPkgBO.setPkgTypeStr(pkgTypeStrMap.get(activeGiftPkgBO.getPkgType().toString()));
                }
                giftPkgBOList.add(activeGiftPkgBO);
            }
        }
        rspBO.setGiftList(giftAtomBoList);
        rspBO.setGiftPkgList(giftPkgBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8d60\u54c1\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }

    private void queryGiftCount(ActiveGiftBO giftBo, Long pkgId) {
        ActiveGiftStockPO giftStockPO = new ActiveGiftStockPO();
        giftStockPO.setActiveId(giftBo.getActiveId());
        giftStockPO.setPkgId(pkgId);
        giftStockPO.setGiftId(giftBo.getId());
        ActiveGiftStockPO giftStock = this.activeGiftStockMapper.getModelBy(giftStockPO);
        if (null != giftStock) {
            giftBo.setAlCount(giftStock.getGiftCount());
            giftBo.setSendCount(giftStock.getSendCount());
        }
    }
}

