/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.active.app.ability.ActActivityDetailQueryNewAbilityService;
import com.tydic.active.app.ability.bo.ActActivityDetailQueryNewAbilityReqBO;
import com.tydic.active.app.ability.bo.ActActivityDetailQueryNewAbilityRspBO;
import com.tydic.active.app.busi.ActActivityDetailQueryNewBusiService;
import com.tydic.active.app.busi.bo.ActActivityDetailQueryBusiNewRspBO;
import com.tydic.active.app.busi.bo.ActActivityDetailQueryNewBusiReqBO;
import com.tydic.active.app.comb.ActTranslateForAbilityRspBoCombService;
import com.tydic.active.app.common.bo.ActiveGiftBO;
import com.tydic.active.app.common.bo.ActiveGiftPkgBO;
import com.tydic.active.app.common.bo.ActivityInfoBO;
import com.tydic.active.app.common.bo.SkuActiveBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ACT_GROUP_DEV/2.0.0/com.tydic.active.app.ability.ActActivityDetailQueryNewAbilityService"})
public class ActActivityDetailQueryNewAbilityServiceImpl
implements ActActivityDetailQueryNewAbilityService {
    private static final String PARAM_MSG = "\u6d3b\u52a8\u8be6\u60c5\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    @Autowired
    private ActActivityDetailQueryNewBusiService actActivityDetailQueryNewBusiService;
    @Autowired
    private ActTranslateForAbilityRspBoCombService actTranslateForAbilityRspBoCombService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"queryActiveDetail"})
    public ActActivityDetailQueryNewAbilityRspBO queryActiveDetail(@RequestBody ActActivityDetailQueryNewAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActActivityDetailQueryNewAbilityRspBO rspBO = new ActActivityDetailQueryNewAbilityRspBO();
        String redisKey = "MSC_INFO_";
        redisKey = reqBO.getActiveId() != null ? redisKey + reqBO.getActiveId().toString() : redisKey + reqBO.getActiveCode();
        Object redisObj = this.cacheClient.get(redisKey);
        if (redisObj != null) {
            rspBO = (ActActivityDetailQueryNewAbilityRspBO)redisObj;
        } else {
            this.queryActiveInfoFromDB(reqBO, rspBO);
            if (rspBO.getActivityInfoBO() != null) {
                this.cacheClient.set(redisKey, (Object)rspBO, 18000);
            }
        }
        return rspBO;
    }

    private void validateArg(ActActivityDetailQueryNewAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8be6\u60c5\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getActiveId() && StringUtils.isBlank((CharSequence)reqBO.getActiveCode())) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8be6\u60c5\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u6d3b\u52a8ID[activeId]\u548c\u6d3b\u52a8\u7f16\u7801[activeCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    private void queryActiveInfoFromDB(ActActivityDetailQueryNewAbilityReqBO reqBO, ActActivityDetailQueryNewAbilityRspBO rspBO) {
        ActActivityDetailQueryNewBusiReqBO busiReqBO = new ActActivityDetailQueryNewBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        ActActivityDetailQueryBusiNewRspBO busiRspBO = this.actActivityDetailQueryNewBusiService.queryActiveDetail(busiReqBO);
        if (null == busiRspBO.getActivityInfoBO()) {
            rspBO.setRespCode(busiRspBO.getRespCode());
            rspBO.setRespDesc(busiRspBO.getRespDesc());
            return;
        }
        rspBO.setActivityInfoBO(busiRspBO.getActivityInfoBO());
        this.translate(rspBO.getActivityInfoBO());
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
    }

    private void translate(ActivityInfoBO activityInfoBO) {
        activityInfoBO.setActiveTypeStr(this.actTranslateForAbilityRspBoCombService.transLate(activityInfoBO.getActiveType(), "MSC_ACTIVE_TYPE"));
        activityInfoBO.setActiveStatusStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(activityInfoBO.getActiveStatus()), "MSC_ACTIVE_STATUS"));
        activityInfoBO.setActiveTargetStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(activityInfoBO.getActiveTarget()), "MSC_ACTIVE_TARGET"));
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getSkuActiveList())) {
            for (SkuActiveBO skuActiveBO : activityInfoBO.getSkuActiveList()) {
                skuActiveBO.setStatusStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(skuActiveBO.getStatus()), "MSC_ACTIVE_STATUS"));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getActiveGiftList())) {
            for (ActiveGiftBO activeGiftBO : activityInfoBO.getActiveGiftList()) {
                activeGiftBO.setIsSendStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(activeGiftBO.getIsSend()), "MSC_GIFT_IS_SEND"));
                activeGiftBO.setOptionMarkStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(activeGiftBO.getOptionMark()), "MSC_OPTION_MARK"));
                activeGiftBO.setGiftTypeStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(activeGiftBO.getGiftType()), "MSC_GIFT_TYPE"));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityInfoBO.getActiveGiftPkgList())) {
            for (ActiveGiftPkgBO activeGiftPkgBO : activityInfoBO.getActiveGiftPkgList()) {
                activeGiftPkgBO.setPkgTypeStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(activeGiftPkgBO.getPkgType()), "MSC_GIFT_PKG_TYPE"));
                activeGiftPkgBO.setOptionMarkStr(this.actTranslateForAbilityRspBoCombService.transLate(String.valueOf(activeGiftPkgBO.getOptionMark()), "MSC_OPTION_MARK"));
            }
        }
    }
}

