/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.tydic.active.app.atom.ActCouponValidCheckAtomService;
import com.tydic.active.app.atom.bo.ActCouponValidCheckAtomReqBO;
import com.tydic.active.app.atom.bo.ActCouponValidCheckAtomRspBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.CouponFormMapper;
import com.tydic.active.app.dao.CouponInstMapper;
import com.tydic.active.app.dao.po.CouponFormPO;
import com.tydic.active.app.dao.po.CouponInstPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCouponValidCheckAtomService")
public class ActCouponValidCheckAtomServiceImpl
implements ActCouponValidCheckAtomService {
    private CouponInstMapper couponInstMapper;
    private CouponFormMapper couponFormMapper;

    @Autowired
    public ActCouponValidCheckAtomServiceImpl(CouponInstMapper couponInstMapper, CouponFormMapper couponFormMapper) {
        this.couponInstMapper = couponInstMapper;
        this.couponFormMapper = couponFormMapper;
    }

    @Override
    public ActCouponValidCheckAtomRspBO checkCouponValid(ActCouponValidCheckAtomReqBO reqBO) {
        ActCouponValidCheckAtomRspBO rspBO = new ActCouponValidCheckAtomRspBO();
        CouponInstPO instPO = new CouponInstPO();
        instPO.setCouponNo(reqBO.getCouponNo());
        CouponInstPO couponInstPO = this.couponInstMapper.getModelBy(instPO);
        if (null == couponInstPO) {
            rspBO.setCouponValidMark(ActCommConstant.CouponValidMark.INEFFECTIVE);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
            return rspBO;
        }
        Date now = new Date();
        if (ActCommConstant.CouponState.EXPIRED.equals(couponInstPO.getState()) || ActCommConstant.CouponState.USED.equals(couponInstPO.getState()) || couponInstPO.getEffTime().after(now) || couponInstPO.getExpTime().before(now)) {
            rspBO.setCouponValidMark(ActCommConstant.CouponValidMark.INEFFECTIVE);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u65e0\u6548");
            return rspBO;
        }
        CouponFormPO reqPO = new CouponFormPO();
        reqPO.setFmId(couponInstPO.getFmId());
        CouponFormPO couponFormPO = this.couponFormMapper.selectByPrimaryKey(reqPO);
        if (null != couponFormPO) {
            rspBO.setFmId(couponFormPO.getFmId());
            rspBO.setFmName(couponFormPO.getFmName());
            rspBO.setFmDesc(couponFormPO.getFmDesc());
        }
        rspBO.setCouponValidMark(ActCommConstant.CouponValidMark.VALID);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u6709\u6548");
        return rspBO;
    }
}

