/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.active.app.atom.ActGroupActiveCaculateAtomService;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomReqBO;
import com.tydic.active.app.atom.bo.ActCalculationUniversalAtomRspBO;
import com.tydic.active.app.common.bo.ActDiscountSkuListBO;
import com.tydic.active.app.common.bo.SkuCalculationActiveBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActGroupActiveExtMapper;
import com.tydic.active.app.dao.ActSkuScopeMapper;
import com.tydic.active.app.dao.po.ActGroupActiveExtPO;
import com.tydic.active.app.dao.po.ActSkuScopePO;
import java.math.BigDecimal;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActGroupActiveCaculateAtomServiceImpl
implements ActGroupActiveCaculateAtomService {
    @Autowired
    private ActSkuScopeMapper actSkuScopeMapper;
    @Autowired
    private ActGroupActiveExtMapper actGroupActiveExtMapper;

    @Override
    public ActCalculationUniversalAtomRspBO calculateGroupActivePrice(ActCalculationUniversalAtomReqBO atomReqBO) {
        ActCalculationUniversalAtomRspBO rsp = new ActCalculationUniversalAtomRspBO();
        ActDiscountSkuListBO actDiscountSkuListBO = new ActDiscountSkuListBO();
        BigDecimal totalDiscountMoney = new BigDecimal(0);
        HashMap<String, BigDecimal> skuDiscountMap = new HashMap<String, BigDecimal>();
        for (SkuCalculationActiveBO bo : atomReqBO.getSkuInfoList()) {
            BigDecimal discountPrice;
            BigDecimal discountRate;
            ActSkuScopePO actSkuScopePO = new ActSkuScopePO();
            actSkuScopePO.setActiveId(atomReqBO.getActiveId());
            actSkuScopePO.setMarketingType("10");
            actSkuScopePO.setRangeType(ActCommConstant.RangeType.SKU);
            actSkuScopePO.setRangeId(bo.getSkuId());
            ActSkuScopePO actSkuScope = this.actSkuScopeMapper.getModelBy(actSkuScopePO);
            ActGroupActiveExtPO actGroupActiveExtPO = this.actGroupActiveExtMapper.selectByPrimaryKey(atomReqBO.getActiveId());
            if ("1".equals(actGroupActiveExtPO.getDiscountType())) {
                BigDecimal discountPrice2;
                if (ActCommConstant.HeadDiscountFlag.YES.equals(actGroupActiveExtPO.getHeadDiscountFlag()) && ActCommConstant.GroupActiveOperType.OPENING_A_REGIMENT.equals(bo.getGroupActiveOperType())) {
                    try {
                        discountPrice2 = MoneyUtils.Long2BigDecimal((Long)actSkuScope.getDiscountPrice1());
                    }
                    catch (Exception e) {
                        throw new BusinessException("6012", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff01");
                    }
                    skuDiscountMap.put(bo.getSkuId(), discountPrice2);
                    totalDiscountMoney = totalDiscountMoney.add(discountPrice2);
                    continue;
                }
                try {
                    discountPrice2 = MoneyUtils.Long2BigDecimal((Long)actSkuScope.getDiscountPrice());
                }
                catch (Exception e) {
                    throw new BusinessException("6012", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff01");
                }
                skuDiscountMap.put(bo.getSkuId(), discountPrice2);
                totalDiscountMoney = totalDiscountMoney.add(discountPrice2);
                continue;
            }
            if (ActCommConstant.HeadDiscountFlag.YES.equals(actGroupActiveExtPO.getHeadDiscountFlag()) && ActCommConstant.GroupActiveOperType.OPENING_A_REGIMENT.equals(bo.getGroupActiveOperType())) {
                discountRate = BigDecimal.ONE.subtract(new BigDecimal(actSkuScope.getDiscountRate1()).divide(new BigDecimal(100), 2, 4));
                discountPrice = bo.getTotalPrice().multiply(discountRate);
                skuDiscountMap.put(bo.getSkuId(), discountPrice);
                totalDiscountMoney = totalDiscountMoney.add(discountPrice);
                continue;
            }
            discountRate = BigDecimal.ONE.subtract(new BigDecimal(actSkuScope.getDiscountRate()).divide(new BigDecimal(100), 2, 4));
            discountPrice = bo.getTotalPrice().multiply(discountRate);
            skuDiscountMap.put(bo.getSkuId(), discountPrice);
            totalDiscountMoney = totalDiscountMoney.add(discountPrice);
        }
        actDiscountSkuListBO.setSkuDiscountMap(skuDiscountMap);
        actDiscountSkuListBO.setDiscountMoney(totalDiscountMoney);
        rsp.setActDiscountSkuListBO(actDiscountSkuListBO);
        return rsp;
    }
}

