/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.active.app.atom.impl;

import com.ohaotian.plugin.cache.ActRedisManager;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.active.app.atom.ActQryKillSkuStockPriceAtomService;
import com.tydic.active.app.atom.bo.ActQryKillSkuStockPriceAtomReqBO;
import com.tydic.active.app.atom.bo.ActQryKillSkuStockPriceAtomRspBO;
import com.tydic.active.app.common.bo.ActKillSkuBO;
import com.tydic.active.app.constant.ActCommConstant;
import com.tydic.active.app.dao.ActKillSkuMapper;
import com.tydic.active.app.dao.po.ActKillSkuPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActQryKillSkuStockPriceAtomServiceImpl
implements ActQryKillSkuStockPriceAtomService {
    private static final Logger log = LoggerFactory.getLogger(ActQryKillSkuStockPriceAtomServiceImpl.class);
    @Autowired
    private ActKillSkuMapper actKillSkuMapper;
    @Autowired
    private ActRedisManager cacheManager;

    @Override
    public ActQryKillSkuStockPriceAtomRspBO qryKillSkuStockPrice(ActQryKillSkuStockPriceAtomReqBO atomReqBO) {
        ActQryKillSkuStockPriceAtomRspBO atomRspBO = new ActQryKillSkuStockPriceAtomRspBO();
        HashMap<String, ActKillSkuBO> skuIdKillSkuBOMap = new HashMap<String, ActKillSkuBO>();
        ArrayList<ActKillSkuBO> ActKillSkuBOList = new ArrayList<ActKillSkuBO>();
        ActKillSkuPO record = new ActKillSkuPO();
        record.setActiveId(atomReqBO.getActiveId());
        record.setSkuIds(atomReqBO.getSkuIds());
        record.setStartTime(atomReqBO.getStartTime() == null ? new Date() : atomReqBO.getStartTime());
        record.setEndTime(atomReqBO.getEndTime() == null ? new Date() : atomReqBO.getEndTime());
        List<ActKillSkuPO> actKillSkuPOS = this.actKillSkuMapper.getInfoWithDayAndTime(record);
        if (!CollectionUtils.isEmpty(actKillSkuPOS)) {
            for (ActKillSkuPO actKillSkuPO : actKillSkuPOS) {
                ActKillSkuBO actKillSkuBO = new ActKillSkuBO();
                BeanUtils.copyProperties((Object)actKillSkuPO, (Object)actKillSkuBO);
                this.getCurrentStockNum(actKillSkuBO, actKillSkuPO);
                actKillSkuBO.setCurrentKillPrice(this.getCurrentKillPrice(actKillSkuPO));
                ActKillSkuBOList.add(actKillSkuBO);
                skuIdKillSkuBOMap.put(actKillSkuPO.getSkuId(), actKillSkuBO);
            }
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        atomRspBO.setActKillSkuBOList(ActKillSkuBOList);
        atomRspBO.setSkuIdKillSkuBOMap(skuIdKillSkuBOMap);
        return atomRspBO;
    }

    private Long getCurrentKillPrice(ActKillSkuPO actKillSkuStockPriceBO) {
        if (actKillSkuStockPriceBO.getTimeKillPrice() != null) {
            return actKillSkuStockPriceBO.getTimeKillPrice();
        }
        if (actKillSkuStockPriceBO.getDayKillPrice() != null) {
            return actKillSkuStockPriceBO.getDayKillPrice();
        }
        return actKillSkuStockPriceBO.getKillPrice();
    }

    private void getCurrentStockNum(ActKillSkuBO actKillSkuBO, ActKillSkuPO actKillSkuPO) {
        Integer actualNum = actKillSkuPO.getActualNum() == null ? -1 : actKillSkuPO.getActualNum();
        log.info(actKillSkuPO.getSkuId() + ":\u603b\u5e93\u5b58==" + actualNum);
        Integer dayActualNum = actKillSkuPO.getDayActualNum() == null ? -1 : actKillSkuPO.getDayActualNum();
        log.info(actKillSkuPO.getSkuId() + ":\u65e5\u671f\u603b\u5e93\u5b58==" + dayActualNum);
        Integer timeActualNum = actKillSkuPO.getTimeActualNum() == null ? -1 : actKillSkuPO.getTimeActualNum();
        log.info(actKillSkuPO.getSkuId() + ":\u65f6\u6bb5\u603b\u5e93\u5b58==" + timeActualNum);
        if (timeActualNum != -1) {
            String timeLockRedisKey = "TIME_LOCK_TOTAL_" + actKillSkuPO.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuPO.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuPO.getEndTime()) + "_" + actKillSkuPO.getSkuId();
            Long timeLockRedisValue = this.cacheManager.incrByCount(timeLockRedisKey, 0L);
            Integer timeLockNum = timeLockRedisValue.intValue();
            log.info(timeLockRedisKey + "====\u65f6\u6bb5\u9501\u5b9a\u5e93\u5b58==" + timeLockNum);
            String timeSalesRedisKey = "TIME_SALES_TOTAL_" + actKillSkuPO.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuPO.getStartTime()) + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuPO.getEndTime()) + "_" + actKillSkuPO.getSkuId();
            Long timeSalesRedisValue = this.cacheManager.incrByCount(timeSalesRedisKey, 0L);
            Integer timeSalesNum = timeSalesRedisValue.intValue();
            log.info(timeSalesRedisKey + "====\u65f6\u6bb5\u9500\u552e\u5e93\u5b58==" + timeLockNum);
            actKillSkuBO.setStockControlRange(ActCommConstant.KillSkuControlRange.TIME);
            actKillSkuBO.setCurrentTotalStockNum(timeActualNum);
            actKillSkuBO.setCurrentAvilabeStockNum(Integer.valueOf(timeActualNum - timeLockNum - timeSalesNum));
            actKillSkuBO.setCurrentUsedStockNum(timeSalesNum);
            return;
        }
        if (dayActualNum != -1) {
            String dayLockRedisKey = "DAY_LOCK_TOTAL_" + actKillSkuPO.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuPO.getStartTime()) + "_" + actKillSkuPO.getSkuId();
            Long dayLockRedisValue = this.cacheManager.incrByCount(dayLockRedisKey, 0L);
            Integer dayLockNum = dayLockRedisValue.intValue();
            log.info(dayLockRedisKey + "====\u65e5\u671f\u9501\u5b9a\u5e93\u5b58==" + dayLockNum);
            String daySalesRedisKey = "DAY_SALES_TOTAL_" + actKillSkuPO.getActiveId() + "_" + DateUtils.DateToStryyyyMMdd((Date)actKillSkuPO.getStartTime()) + "_" + actKillSkuPO.getSkuId();
            Long daySalesRedisValue = this.cacheManager.incrByCount(daySalesRedisKey, 0L);
            Integer daySalesNum = daySalesRedisValue.intValue();
            log.info(daySalesRedisKey + "====\u65e5\u671f\u9500\u552e\u5e93\u5b58==" + daySalesNum);
            actKillSkuBO.setStockControlRange(ActCommConstant.KillSkuControlRange.DAY);
            actKillSkuBO.setCurrentTotalStockNum(dayActualNum);
            actKillSkuBO.setCurrentAvilabeStockNum(Integer.valueOf(dayActualNum - dayLockNum - daySalesNum));
            actKillSkuBO.setCurrentUsedStockNum(daySalesNum);
            return;
        }
        if (actualNum != 1) {
            String skuLockRedisKey = "SKU_LOCK_TOTALL_" + actKillSkuPO.getActiveId() + "_" + actKillSkuPO.getSkuId();
            Long skuLockRedisValue = this.cacheManager.incrByCount(skuLockRedisKey, 0L);
            Integer lockNum = skuLockRedisValue.intValue();
            log.info(skuLockRedisKey + "====\u5355\u54c1\u9501\u5b9a\u5e93\u5b58==" + lockNum);
            String skuSalesRedisKey = "SKU_LOCK_TOTALL_" + actKillSkuPO.getActiveId() + "_" + actKillSkuPO.getSkuId();
            Long skuSalesRedisValue = this.cacheManager.incrByCount(skuSalesRedisKey, 0L);
            Integer salesNum = skuSalesRedisValue.intValue();
            log.info(skuSalesRedisKey + "====\u5355\u54c1\u9500\u552e\u5e93\u5b58==" + salesNum);
            actKillSkuBO.setStockControlRange(ActCommConstant.KillSkuControlRange.SKU);
            actKillSkuBO.setCurrentTotalStockNum(actualNum);
            actKillSkuBO.setCurrentAvilabeStockNum(Integer.valueOf(actualNum - lockNum - salesNum));
            actKillSkuBO.setCurrentUsedStockNum(salesNum);
            return;
        }
        actKillSkuBO.setStockControlRange(ActCommConstant.KillSkuControlRange.NO_LIMIT);
        actKillSkuBO.setCurrentTotalStockNum(Integer.valueOf(-1));
        actKillSkuBO.setCurrentAvilabeStockNum(Integer.valueOf(-1));
        actKillSkuBO.setCurrentUsedStockNum(Integer.valueOf(-1));
    }
}

